/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp256k1
extends CustomFpCurve {
    private static final int ARR_LEN = 8;
    private static final int ARR_LEN2 = 16;
    private static final int[] P = new int[]{-977, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P7 = -1;
    private static final int PExt15 = -1;
    private static final int PInv33 = 977;

    static {
        int[] nArray = new int[16];
        nArray[0] = 954529;
        nArray[1] = 1954;
        nArray[2] = 1;
        nArray[8] = -1954;
        nArray[9] = -3;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        PExt = nArray;
        PExtInv = new int[]{-954529, -1955, -2, -1, -1, -1, -1, -1, 1953, 2};
    }

    public Secp256k1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", 8, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.10", "00", "07", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", "01", "04 79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798 483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long cc = Nat.mul33Add(8, 977, xx, 8, xx, 0, z, 0);
        int c = Nat.mul33DWordAdd(8, 977, cc, z, 0);
        if (c != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            Nat.add33To(8, 977, z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        if (x != 0 && Nat.mul33WordAdd(8, 977, x, z, 0) != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            Nat.add33To(8, 977, z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(8, x, y, z);
        if (c != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            Nat.add33To(8, 977, z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(8, x, z);
        if (c != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            Nat.add33To(8, 977, z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(8, x, y, zz);
        if ((c != 0 || zz[15] == -1 && Nat.gte(16, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(16, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(8, x, y, z);
        if (c != 0) {
            Nat.sub33From(8, 977, z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(8, x, 0, z);
        if (c != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            Nat.add33To(8, 977, z);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp256k1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(256, X);
            if (this.arr[7] == -1 && Nat.gte(8, this.arr, P)) {
                Nat.subFrom(8, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(8, x1) || Nat.isOne(8, x1)) {
                return this;
            }
            int[] x2 = new int[8];
            Secp256k1.this.elSquare(x1, x2);
            Secp256k1.this.elMultiply(x2, x1, x2);
            int[] x3 = new int[8];
            Secp256k1.this.elSquare(x2, x3);
            Secp256k1.this.elMultiply(x3, x1, x3);
            int[] x6 = new int[8];
            Secp256k1.this.elSquareN(x3, 3, x6);
            Secp256k1.this.elMultiply(x6, x3, x6);
            int[] x9 = x6;
            Secp256k1.this.elSquareN(x6, 3, x9);
            Secp256k1.this.elMultiply(x9, x3, x9);
            int[] x11 = x9;
            Secp256k1.this.elSquareN(x9, 2, x11);
            Secp256k1.this.elMultiply(x11, x2, x11);
            int[] x22 = new int[8];
            Secp256k1.this.elSquareN(x11, 11, x22);
            Secp256k1.this.elMultiply(x22, x11, x22);
            int[] x44 = x11;
            Secp256k1.this.elSquareN(x22, 22, x44);
            Secp256k1.this.elMultiply(x44, x22, x44);
            int[] x88 = new int[8];
            Secp256k1.this.elSquareN(x44, 44, x88);
            Secp256k1.this.elMultiply(x88, x44, x88);
            int[] x176 = new int[8];
            Secp256k1.this.elSquareN(x88, 88, x176);
            Secp256k1.this.elMultiply(x176, x88, x176);
            int[] x220 = x88;
            Secp256k1.this.elSquareN(x176, 44, x220);
            Secp256k1.this.elMultiply(x220, x44, x220);
            int[] x223 = x44;
            Secp256k1.this.elSquareN(x220, 3, x223);
            Secp256k1.this.elMultiply(x223, x3, x223);
            int[] t1 = x223;
            Secp256k1.this.elSquareN(t1, 23, t1);
            Secp256k1.this.elMultiply(t1, x22, t1);
            Secp256k1.this.elSquareN(t1, 6, t1);
            Secp256k1.this.elMultiply(t1, x2, t1);
            Secp256k1.this.elSquareN(t1, 2, t1);
            int[] t2 = x2;
            Secp256k1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

