/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp384r1
extends CustomFpCurve {
    private static final int ARR_LEN = 12;
    private static final int ARR_LEN2 = 24;
    private static final long M = 0xFFFFFFFFL;
    private static final int[] P;
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P11 = -1;
    private static final int PExt23 = -1;

    static {
        int[] nArray = new int[12];
        nArray[0] = -1;
        nArray[3] = -1;
        nArray[4] = -2;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        P = nArray;
        int[] nArray2 = new int[24];
        nArray2[0] = 1;
        nArray2[1] = -2;
        nArray2[3] = 2;
        nArray2[5] = -2;
        nArray2[7] = 2;
        nArray2[8] = 1;
        nArray2[12] = -2;
        nArray2[13] = 1;
        nArray2[15] = -2;
        nArray2[16] = -3;
        nArray2[17] = -1;
        nArray2[18] = -1;
        nArray2[19] = -1;
        nArray2[20] = -1;
        nArray2[21] = -1;
        nArray2[22] = -1;
        nArray2[23] = -1;
        PExt = nArray2;
        PExtInv = new int[]{-1, 1, -1, -3, -1, 1, -1, -3, -2, -1, -1, -1, 1, -2, -1, 1, 2};
    }

    public Secp384r1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", 12, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.34", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", "01", "04 AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7 3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long xx16 = (long)xx[16] & 0xFFFFFFFFL;
        long xx17 = (long)xx[17] & 0xFFFFFFFFL;
        long xx18 = (long)xx[18] & 0xFFFFFFFFL;
        long xx19 = (long)xx[19] & 0xFFFFFFFFL;
        long xx20 = (long)xx[20] & 0xFFFFFFFFL;
        long xx21 = (long)xx[21] & 0xFFFFFFFFL;
        long xx22 = (long)xx[22] & 0xFFFFFFFFL;
        long xx23 = (long)xx[23] & 0xFFFFFFFFL;
        long n = 1L;
        long t0 = ((long)xx[12] & 0xFFFFFFFFL) + xx20 - 1L;
        long t1 = ((long)xx[13] & 0xFFFFFFFFL) + xx22;
        long t2 = ((long)xx[14] & 0xFFFFFFFFL) + xx22 + xx23;
        long t3 = ((long)xx[15] & 0xFFFFFFFFL) + xx23;
        long t4 = xx17 + xx21;
        long t5 = xx21 - xx23;
        long t6 = xx22 - xx23;
        long t7 = t0 + t5;
        long cc = 0L;
        z[0] = (int)(cc += ((long)xx[0] & 0xFFFFFFFFL) + t7);
        cc >>= 32;
        z[1] = (int)(cc += ((long)xx[1] & 0xFFFFFFFFL) + xx23 - t0 + t1);
        cc >>= 32;
        z[2] = (int)(cc += ((long)xx[2] & 0xFFFFFFFFL) - xx21 - t1 + t2);
        cc >>= 32;
        z[3] = (int)(cc += ((long)xx[3] & 0xFFFFFFFFL) - t2 + t3 + t7);
        cc >>= 32;
        z[4] = (int)(cc += ((long)xx[4] & 0xFFFFFFFFL) + xx16 + xx21 + t1 - t3 + t7);
        cc >>= 32;
        z[5] = (int)(cc += ((long)xx[5] & 0xFFFFFFFFL) - xx16 + t1 + t2 + t4);
        cc >>= 32;
        z[6] = (int)(cc += ((long)xx[6] & 0xFFFFFFFFL) + xx18 - xx17 + t2 + t3);
        cc >>= 32;
        z[7] = (int)(cc += ((long)xx[7] & 0xFFFFFFFFL) + xx16 + xx19 - xx18 + t3);
        cc >>= 32;
        z[8] = (int)(cc += ((long)xx[8] & 0xFFFFFFFFL) + xx16 + xx17 + xx20 - xx19);
        cc >>= 32;
        z[9] = (int)(cc += ((long)xx[9] & 0xFFFFFFFFL) + xx18 - xx20 + t4);
        cc >>= 32;
        z[10] = (int)(cc += ((long)xx[10] & 0xFFFFFFFFL) + xx18 + xx19 - t5 + t6);
        cc >>= 32;
        z[11] = (int)(cc += ((long)xx[11] & 0xFFFFFFFFL) + xx19 + xx20 - t6);
        cc >>= 32;
        this.elReduceInt((int)(++cc), z);
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        long cc = 0L;
        if (x != 0) {
            long xx12 = (long)x & 0xFFFFFFFFL;
            z[0] = (int)(cc += ((long)z[0] & 0xFFFFFFFFL) + xx12);
            cc >>= 32;
            z[1] = (int)(cc += ((long)z[1] & 0xFFFFFFFFL) - xx12);
            if ((cc >>= 32) != 0L) {
                z[2] = (int)(cc += (long)z[2] & 0xFFFFFFFFL);
                cc >>= 32;
            }
            z[3] = (int)(cc += ((long)z[3] & 0xFFFFFFFFL) + xx12);
            cc >>= 32;
            z[4] = (int)(cc += ((long)z[4] & 0xFFFFFFFFL) + xx12);
            cc >>= 32;
        }
        if (cc != 0L && Nat.incAt(12, z, 5) != 0 || z[11] == -1 && Nat.gte(12, z, P)) {
            Secp384r1.addPInvTo(z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(12, x, y, z);
        if (c != 0 || z[11] == -1 && Nat.gte(12, z, P)) {
            Secp384r1.addPInvTo(z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(12, x, y, zz);
        if ((c != 0 || zz[23] == -1 && Nat.gte(24, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(24, zz, PExtInv.length);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(12, x, z);
        if (c != 0 || z[11] == -1 && Nat.gte(12, z, P)) {
            Secp384r1.addPInvTo(z);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(12, x, y, z);
        if (c != 0) {
            Secp384r1.subPInvFrom(z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(12, x, 0, z);
        if (c != 0 || z[11] == -1 && Nat.gte(12, z, P)) {
            Secp384r1.addPInvTo(z);
        }
    }

    private static void addPInvTo(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) + 1L;
        z[0] = (int)c;
        c >>= 32;
        z[1] = (int)(c += ((long)z[1] & 0xFFFFFFFFL) - 1L);
        if ((c >>= 32) != 0L) {
            z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) + 1L);
        c >>= 32;
        z[4] = (int)(c += ((long)z[4] & 0xFFFFFFFFL) + 1L);
        if ((c >>= 32) != 0L) {
            Nat.incAt(12, z, 5);
        }
    }

    private static void subPInvFrom(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - 1L;
        z[0] = (int)c;
        c >>= 32;
        z[1] = (int)(c += ((long)z[1] & 0xFFFFFFFFL) + 1L);
        if ((c >>= 32) != 0L) {
            z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) - 1L);
        c >>= 32;
        z[4] = (int)(c += ((long)z[4] & 0xFFFFFFFFL) - 1L);
        if ((c >>= 32) != 0L) {
            Nat.decAt(12, z, 5);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp384r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(384, X);
            if (this.arr[11] == -1 && Nat.gte(12, this.arr, P)) {
                Nat.subFrom(12, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(12, x1) || Nat.isOne(12, x1)) {
                return this;
            }
            int[] t1 = new int[12];
            int[] t2 = new int[12];
            int[] t3 = new int[12];
            int[] t4 = new int[12];
            Secp384r1.this.elSquare(x1, t1);
            Secp384r1.this.elMultiply(t1, x1, t1);
            Secp384r1.this.elSquareN(t1, 2, t2);
            Secp384r1.this.elMultiply(t2, t1, t2);
            Secp384r1.this.elSquare(t2, t2);
            Secp384r1.this.elMultiply(t2, x1, t2);
            Secp384r1.this.elSquareN(t2, 5, t3);
            Secp384r1.this.elMultiply(t3, t2, t3);
            Secp384r1.this.elSquareN(t3, 5, t4);
            Secp384r1.this.elMultiply(t4, t2, t4);
            Secp384r1.this.elSquareN(t4, 15, t2);
            Secp384r1.this.elMultiply(t2, t4, t2);
            Secp384r1.this.elSquareN(t2, 2, t3);
            Secp384r1.this.elMultiply(t1, t3, t1);
            Secp384r1.this.elSquareN(t3, 28, t3);
            Secp384r1.this.elMultiply(t2, t3, t2);
            Secp384r1.this.elSquareN(t2, 60, t3);
            Secp384r1.this.elMultiply(t3, t2, t3);
            int[] r = t2;
            Secp384r1.this.elSquareN(t3, 120, r);
            Secp384r1.this.elMultiply(r, t3, r);
            Secp384r1.this.elSquareN(r, 15, r);
            Secp384r1.this.elMultiply(r, t4, r);
            Secp384r1.this.elSquareN(r, 33, r);
            Secp384r1.this.elMultiply(r, t1, r);
            Secp384r1.this.elSquareN(r, 64, r);
            Secp384r1.this.elMultiply(r, x1, r);
            Secp384r1.this.elSquareN(r, 30, t1);
            Secp384r1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

