/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec;

import java.math.BigInteger;
import java.util.Random;
import org.denom.Ex;

public abstract class Nat {
    private static final long M = 0xFFFFFFFFL;
    private static final long M32 = 0x55555555L;
    private static final long M64 = 0x5555555555555555L;

    public static int add(int len, int[] x, int[] y, int[] z) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)y[i] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int add33To(int len, int x, int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) + ((long)x & 0xFFFFFFFFL);
        z[0] = (int)c;
        c >>>= 32;
        z[1] = (int)(c += ((long)z[1] & 0xFFFFFFFFL) + 1L);
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, 2);
    }

    public static int addBothTo(int len, int[] x, int[] y, int[] z) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)y[i] & 0xFFFFFFFFL) + ((long)z[i] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int addTo(int len, int[] x, int[] z) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)z[i] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int addTo(int len, int[] x, int xOff, int[] z, int zOff) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[zOff + i] = (int)(c += ((long)x[xOff + i] & 0xFFFFFFFFL) + ((long)z[zOff + i] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int addWordAt(int len, int x, int[] z, int zPos) {
        long c = ((long)x & 0xFFFFFFFFL) + ((long)z[zPos] & 0xFFFFFFFFL);
        z[zPos] = (int)c;
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zPos + 1);
    }

    public static int addWordAt(int len, int x, int[] z, int zOff, int zPos) {
        long c = ((long)x & 0xFFFFFFFFL) + ((long)z[zOff + zPos] & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)c;
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, zPos + 1);
    }

    public static int addWordTo(int len, int x, int[] z) {
        long c = ((long)x & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL);
        z[0] = (int)c;
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, 1);
    }

    public static int cadd(int len, int mask, int[] x, int[] y, int[] z) {
        long MASK = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) + ((long)y[i] & MASK));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    public static void cmov(int len, int mask, int[] x, int xOff, int[] z, int zOff) {
        mask = -(mask & 1);
        int i = 0;
        while (i < len) {
            int z_i = z[zOff + i];
            int diff = z_i ^ x[xOff + i];
            z[zOff + i] = z_i ^= diff & mask;
            ++i;
        }
    }

    public static int[] copy(int len, int[] x) {
        int[] z = new int[len];
        System.arraycopy(x, 0, z, 0, len);
        return z;
    }

    public static void copy(int len, int[] x, int[] z) {
        System.arraycopy(x, 0, z, 0, len);
    }

    public static int dec(int len, int[] z) {
        int i = 0;
        while (i < len) {
            int n = i++;
            z[n] = z[n] - 1;
            if (z[n] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int decAt(int len, int[] z, int zPos) {
        int i = zPos;
        while (i < len) {
            int n = i++;
            z[n] = z[n] - 1;
            if (z[n] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int decAt(int len, int[] z, int zOff, int zPos) {
        int i = zPos;
        while (i < len) {
            int n = zOff + i;
            z[n] = z[n] - 1;
            if (z[n] != -1) {
                return 0;
            }
            ++i;
        }
        return -1;
    }

    public static int[] fromBigInteger(int bitLen, BigInteger x) {
        Ex.MUST(x.signum() >= 0 && x.bitLength() <= bitLen);
        int len = bitLen + 31 >> 5;
        int[] z = new int[len];
        int i = 0;
        while (x.signum() != 0) {
            z[i++] = x.intValue();
            x = x.shiftRight(32);
        }
        return z;
    }

    public static long[] fromBigInteger64(int bitLen, BigInteger x) {
        Ex.MUST(x.signum() >= 0 && x.bitLength() <= bitLen);
        int len = bitLen + 63 >> 6;
        long[] z = new long[len];
        int i = 0;
        while (x.signum() != 0) {
            z[i++] = x.longValue();
            x = x.shiftRight(64);
        }
        return z;
    }

    public static int getBit(int[] x, int bit) {
        if (bit == 0) {
            return x[0] & 1;
        }
        int w = bit >> 5;
        if (w < 0 || w >= x.length) {
            return 0;
        }
        int b = bit & 0x1F;
        return x[w] >>> b & 1;
    }

    public static boolean gte(int len, int[] x, int[] y) {
        int i = len - 1;
        while (i >= 0) {
            int x_i = x[i] ^ Integer.MIN_VALUE;
            int y_i = y[i] ^ Integer.MIN_VALUE;
            if (x_i < y_i) {
                return false;
            }
            if (x_i > y_i) {
                return true;
            }
            --i;
        }
        return true;
    }

    public static int inc(int len, int[] z) {
        int i = 0;
        while (i < len) {
            int n = i++;
            z[n] = z[n] + 1;
            if (z[n] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int len, int[] x, int[] z) {
        for (int i = 0; i < len; ++i) {
            int c;
            z[i] = c = x[i] + 1;
            if (c == 0) continue;
            while (i < len) {
                z[i] = x[i];
                ++i;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int len, int[] z, int zPos) {
        int i = zPos;
        while (i < len) {
            int n = i++;
            z[n] = z[n] + 1;
            if (z[n] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int incAt(int len, int[] z, int zOff, int zPos) {
        int i = zPos;
        while (i < len) {
            int n = zOff + i;
            z[n] = z[n] + 1;
            if (z[n] != 0) {
                return 0;
            }
            ++i;
        }
        return 1;
    }

    public static boolean isOne(int len, int[] x) {
        if (x[0] != 1) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (x[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        int len = x.length;
        int i = 1;
        while (i < len) {
            if (x[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isZero(int len, int[] x) {
        int i = 0;
        while (i < len) {
            if (x[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        int len = x.length;
        int i = 0;
        while (i < len) {
            if (x[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void mul(int len, int[] x, int[] y, int[] zz) {
        zz[len] = Nat.mulWord(len, x[0], y, zz);
        int i = 1;
        while (i < len) {
            zz[i + len] = Nat.mulWordAddTo(len, x[i], y, 0, zz, i);
            ++i;
        }
    }

    public static int mulAddTo(int len, int[] x, int[] y, int[] zz) {
        long zc = 0L;
        int i = 0;
        while (i < len) {
            long c = (long)Nat.mulWordAddTo(len, x[i], y, 0, zz, i) & 0xFFFFFFFFL;
            zz[i + len] = (int)(c += zc + ((long)zz[i + len] & 0xFFFFFFFFL));
            zc = c >>> 32;
            ++i;
        }
        return (int)zc;
    }

    public static long mul33Add(int len, int w, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long wVal = (long)w & 0xFFFFFFFFL;
        long c = 0L;
        long xPrev = 0L;
        int i = 0;
        while (i < len) {
            long xi = (long)x[xOff++] & 0xFFFFFFFFL;
            int n = yOff++;
            xPrev = xi;
            z[zOff++] = (int)(c += wVal * xi + xPrev + ((long)y[n] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return c += xPrev;
    }

    public static int mul33DWordAdd(int len, int x, long y, int[] z, int zOff) {
        long c = 0L;
        long xVal = (long)x & 0xFFFFFFFFL;
        long y00 = y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(c += xVal * y00 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        c >>>= 32;
        long y01 = y >>> 32;
        z[zOff + 1] = (int)(c += xVal * y01 + y00 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        c >>>= 32;
        z[zOff + 2] = (int)(c += y01 + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        c >>>= 32;
        z[zOff + 3] = (int)(c += (long)z[zOff + 3] & 0xFFFFFFFFL);
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, 4);
    }

    public static int mul33WordAdd(int len, int x, int y, int[] z, int zOff) {
        long c = 0L;
        long xVal = (long)x & 0xFFFFFFFFL;
        long yVal = (long)y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(c += yVal * xVal + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        c >>>= 32;
        z[zOff + 1] = (int)(c += yVal + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        c >>>= 32;
        z[zOff + 2] = (int)(c += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, 3);
    }

    public static int mulWordsAdd(int len, int x, int y, int[] z) {
        long c = 0L;
        long xVal = (long)x & 0xFFFFFFFFL;
        long yVal = (long)y & 0xFFFFFFFFL;
        z[0] = (int)(c += yVal * xVal + ((long)z[0] & 0xFFFFFFFFL));
        c >>>= 32;
        z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
        return (c >>>= 32) == 0L ? 0 : Nat.incAt(len, z, 0, 2);
    }

    public static int mulWord(int len, int x, int[] y, int[] z) {
        long c = 0L;
        long xVal = (long)x & 0xFFFFFFFFL;
        int i = 0;
        do {
            z[i] = (int)(c += xVal * ((long)y[i] & 0xFFFFFFFFL));
            c >>>= 32;
        } while (++i < len);
        return (int)c;
    }

    public static int mulWordAddTo(int len, int x, int[] y, int yOff, int[] z, int zOff) {
        long c = 0L;
        long xVal = (long)x & 0xFFFFFFFFL;
        int i = 0;
        do {
            z[zOff + i] = (int)(c += xVal * ((long)y[yOff + i] & 0xFFFFFFFFL) + ((long)z[zOff + i] & 0xFFFFFFFFL));
            c >>>= 32;
        } while (++i < len);
        return (int)c;
    }

    public static int shiftDownBit(int len, int[] z, int c) {
        int i = len;
        while (--i >= 0) {
            int next = z[i];
            z[i] = next >>> 1 | c << 31;
            c = next;
        }
        return c << 31;
    }

    public static int shiftDownBits(int len, int[] z, int bits, int c) {
        int i = len;
        while (--i >= 0) {
            int next = z[i];
            z[i] = next >>> bits | c << -bits;
            c = next;
        }
        return c << -bits;
    }

    public static int shiftDownBits(int len, int[] x, int xOff, int bits, int c, int[] z, int zOff) {
        int i = len;
        while (--i >= 0) {
            int next = x[xOff + i];
            z[zOff + i] = next >>> bits | c << -bits;
            c = next;
        }
        return c << -bits;
    }

    public static int shiftDownWord(int len, int[] z, int c) {
        int i = len;
        while (--i >= 0) {
            int next = z[i];
            z[i] = c;
            c = next;
        }
        return c;
    }

    public static int shiftUpBit(int len, int[] z, int c) {
        int i = 0;
        while (i < len) {
            int next = z[i];
            z[i] = next << 1 | c >>> 31;
            c = next;
            ++i;
        }
        return c >>> 31;
    }

    public static int shiftUpBit(int len, int[] z, int zOff, int c) {
        int i = 0;
        while (i < len) {
            int next = z[zOff + i];
            z[zOff + i] = next << 1 | c >>> 31;
            c = next;
            ++i;
        }
        return c >>> 31;
    }

    public static int shiftUpBit(int len, int[] x, int c, int[] z) {
        int i = 0;
        while (i < len) {
            int next = x[i];
            z[i] = next << 1 | c >>> 31;
            c = next;
            ++i;
        }
        return c >>> 31;
    }

    public static int shiftUpBit(int len, int[] x, int xOff, int c, int[] z, int zOff) {
        int i = 0;
        while (i < len) {
            int next = x[xOff + i];
            z[zOff + i] = next << 1 | c >>> 31;
            c = next;
            ++i;
        }
        return c >>> 31;
    }

    public static int shiftUpBits(int len, int[] z, int bits, int c) {
        int i = 0;
        while (i < len) {
            int next = z[i];
            z[i] = next << bits | c >>> -bits;
            c = next;
            ++i;
        }
        return c >>> -bits;
    }

    public static int shiftUpBits(int len, int[] x, int bits, int c, int[] z) {
        int i = 0;
        while (i < len) {
            int next = x[i];
            z[i] = next << bits | c >>> -bits;
            c = next;
            ++i;
        }
        return c >>> -bits;
    }

    public static void square(int len, int[] x, int[] zz) {
        int extLen = len << 1;
        int c = 0;
        int j = len;
        int k = extLen;
        do {
            long xVal = (long)x[--j] & 0xFFFFFFFFL;
            long p = xVal * xVal;
            zz[--k] = c << 31 | (int)(p >>> 33);
            zz[--k] = (int)(p >>> 1);
            c = (int)p;
        } while (j > 0);
        int i = 1;
        while (i < len) {
            c = Nat.squareWordAdd(x, i, zz);
            Nat.addWordAt(extLen, c, zz, i << 1);
            ++i;
        }
        Nat.shiftUpBit(extLen, zz, x[0] << 31);
    }

    public static void square(int len, int[] x, int xOff, int[] zz, int zzOff) {
        int extLen = len << 1;
        int c = 0;
        int j = len;
        int k = extLen;
        do {
            long xVal = (long)x[xOff + --j] & 0xFFFFFFFFL;
            long p = xVal * xVal;
            zz[zzOff + --k] = c << 31 | (int)(p >>> 33);
            zz[zzOff + --k] = (int)(p >>> 1);
            c = (int)p;
        } while (j > 0);
        int i = 1;
        while (i < len) {
            c = Nat.squareWordAdd(x, xOff, i, zz, zzOff);
            Nat.addWordAt(extLen, c, zz, zzOff, i << 1);
            ++i;
        }
        Nat.shiftUpBit(extLen, zz, zzOff, x[xOff] << 31);
    }

    public static int squareWordAdd(int[] x, int xPos, int[] z) {
        long c = 0L;
        long xVal = (long)x[xPos] & 0xFFFFFFFFL;
        int i = 0;
        do {
            z[xPos + i] = (int)(c += xVal * ((long)x[i] & 0xFFFFFFFFL) + ((long)z[xPos + i] & 0xFFFFFFFFL));
            c >>>= 32;
        } while (++i < xPos);
        return (int)c;
    }

    public static int squareWordAdd(int[] x, int xOff, int xPos, int[] z, int zOff) {
        long c = 0L;
        long xVal = (long)x[xOff + xPos] & 0xFFFFFFFFL;
        int i = 0;
        do {
            z[xPos + zOff] = (int)(c += xVal * ((long)x[xOff + i] & 0xFFFFFFFFL) + ((long)z[xPos + zOff] & 0xFFFFFFFFL));
            c >>>= 32;
            ++zOff;
        } while (++i < xPos);
        return (int)c;
    }

    public static int sub(int len, int[] x, int[] y, int[] z) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += ((long)x[i] & 0xFFFFFFFFL) - ((long)y[i] & 0xFFFFFFFFL));
            c >>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int sub(int len, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[zOff + i] = (int)(c += ((long)x[xOff + i] & 0xFFFFFFFFL) - ((long)y[yOff + i] & 0xFFFFFFFFL));
            c >>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int sub33From(int len, int x, int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[0] = (int)c;
        c >>= 32;
        z[1] = (int)(c += ((long)z[1] & 0xFFFFFFFFL) - 1L);
        return (c >>= 32) == 0L ? 0 : Nat.decAt(len, z, 2);
    }

    public static int subFrom(int len, int[] x, int[] z) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[i] = (int)(c += ((long)z[i] & 0xFFFFFFFFL) - ((long)x[i] & 0xFFFFFFFFL));
            c >>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int subFrom(int len, int[] x, int xOff, int[] z, int zOff) {
        long c = 0L;
        int i = 0;
        while (i < len) {
            z[zOff + i] = (int)(c += ((long)z[zOff + i] & 0xFFFFFFFFL) - ((long)x[xOff + i] & 0xFFFFFFFFL));
            c >>= 32;
            ++i;
        }
        return (int)c;
    }

    public static int subWordFrom(int len, int x, int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[0] = (int)c;
        return (c >>= 32) == 0L ? 0 : Nat.decAt(len, z, 1);
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static BigInteger toBigInteger(int len, int[] x) {
        byte[] bs = new byte[len << 2];
        int i = 0;
        while (i < len) {
            int xI = x[i];
            if (xI != 0) {
                Nat.intToBigEndian(xI, bs, len - 1 - i << 2);
            }
            ++i;
        }
        return new BigInteger(1, bs);
    }

    public static BigInteger toBigInteger64(long[] x) {
        int len = x.length;
        byte[] bs = new byte[len << 3];
        int i = 0;
        while (i < len) {
            long xI = x[i];
            if (xI != 0L) {
                int offset = len - 1 - i << 3;
                Nat.intToBigEndian((int)(xI >>> 32), bs, offset);
                Nat.intToBigEndian((int)(xI & 0xFFFFFFFFL), bs, offset + 4);
            }
            ++i;
        }
        return new BigInteger(1, bs);
    }

    public static void zero(int len, int[] z) {
        int i = 0;
        while (i < len) {
            z[i] = 0;
            ++i;
        }
    }

    public static int[] random(int[] p) {
        int len = p.length;
        Random rand = new Random();
        int[] s = new int[len];
        int m = p[len - 1];
        m |= m >>> 1;
        m |= m >>> 2;
        m |= m >>> 4;
        m |= m >>> 8;
        m |= m >>> 16;
        do {
            int i = 0;
            while (i != len) {
                s[i] = rand.nextInt();
                ++i;
            }
            int n = len - 1;
            s[n] = s[n] & m;
        } while (Nat.gte(len, s, p));
        return s;
    }

    private static void inversionResult(int[] p, int ac, int[] a, int[] z) {
        if (ac < 0) {
            Nat.add(p.length, a, p, z);
        } else {
            System.arraycopy(a, 0, z, 0, p.length);
        }
    }

    private static int inversionStep(int[] p, int[] u, int uLen, int[] x, int xc) {
        int len = p.length;
        int count = 0;
        while (u[0] == 0) {
            Nat.shiftDownWord(uLen, u, 0);
            count += 32;
        }
        int zeroes = Nat.getTrailingZeroes(u[0]);
        if (zeroes > 0) {
            Nat.shiftDownBits(uLen, u, zeroes, 0);
            count += zeroes;
        }
        int i = 0;
        while (i < count) {
            if ((x[0] & 1) != 0) {
                xc = xc < 0 ? (xc += Nat.addTo(len, p, x)) : (xc += Nat.subFrom(len, p, x));
            }
            Nat.shiftDownBit(len, x, xc);
            ++i;
        }
        return xc;
    }

    private static int getTrailingZeroes(int x) {
        int count = 0;
        while ((x & 1) == 0) {
            x >>>= 1;
            ++count;
        }
        return count;
    }

    public static void invert(int[] p, int[] x, int[] z) {
        int len = p.length;
        Ex.MUST(!Nat.isZero(len, x), "'x' cannot be 0");
        if (Nat.isOne(len, x)) {
            System.arraycopy(x, 0, z, 0, len);
            return;
        }
        int[] u = Nat.copy(len, x);
        int[] a = new int[len];
        a[0] = 1;
        int ac = 0;
        if ((u[0] & 1) == 0) {
            ac = Nat.inversionStep(p, u, len, a, ac);
        }
        if (Nat.isOne(len, u)) {
            Nat.inversionResult(p, ac, a, z);
            return;
        }
        int[] v = Nat.copy(len, p);
        int[] b = new int[len];
        int bc = 0;
        int uvLen = len;
        while (true) {
            if (u[uvLen - 1] == 0 && v[uvLen - 1] == 0) {
                --uvLen;
                continue;
            }
            if (Nat.gte(uvLen, u, v)) {
                Nat.subFrom(uvLen, v, u);
                ac += Nat.subFrom(len, b, a) - bc;
                ac = Nat.inversionStep(p, u, uvLen, a, ac);
                if (!Nat.isOne(uvLen, u)) continue;
                Nat.inversionResult(p, ac, a, z);
                return;
            }
            Nat.subFrom(uvLen, u, v);
            bc += Nat.subFrom(len, a, b) - ac;
            bc = Nat.inversionStep(p, v, uvLen, b, bc);
            if (Nat.isOne(uvLen, v)) break;
        }
        Nat.inversionResult(p, bc, b, z);
    }

    public static int expand8to16(int x) {
        x &= 0xFF;
        x = (x | x << 4) & 0xF0F;
        x = (x | x << 2) & 0x3333;
        x = (x | x << 1) & 0x5555;
        return x;
    }

    public static int expand16to32(int x) {
        x &= 0xFFFF;
        x = (x | x << 8) & 0xFF00FF;
        x = (x | x << 4) & 0xF0F0F0F;
        x = (x | x << 2) & 0x33333333;
        x = (x | x << 1) & 0x55555555;
        return x;
    }

    public static long expand32to64(int x) {
        int t = (x ^ x >>> 8) & 0xFF00;
        x ^= t ^ t << 8;
        t = (x ^ x >>> 4) & 0xF000F0;
        x ^= t ^ t << 4;
        t = (x ^ x >>> 2) & 0xC0C0C0C;
        x ^= t ^ t << 2;
        t = (x ^ x >>> 1) & 0x22222222;
        return ((long)((x ^= t ^ t << 1) >>> 1) & 0x55555555L) << 32 | (long)x & 0x55555555L;
    }

    public static void expand64To128(long x, long[] z, int zOff) {
        long t = (x ^ x >>> 16) & 0xFFFF0000L;
        x ^= t ^ t << 16;
        t = (x ^ x >>> 8) & 0xFF000000FF00L;
        x ^= t ^ t << 8;
        t = (x ^ x >>> 4) & 0xF000F000F000F0L;
        x ^= t ^ t << 4;
        t = (x ^ x >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x ^= t ^ t << 2;
        t = (x ^ x >>> 1) & 0x2222222222222222L;
        z[zOff] = (x ^= t ^ t << 1) & 0x5555555555555555L;
        z[zOff + 1] = x >>> 1 & 0x5555555555555555L;
    }

    public static long unshuffle(long x) {
        long t = (x ^ x >>> 1) & 0x2222222222222222L;
        x ^= t ^ t << 1;
        t = (x ^ x >>> 2) & 0xC0C0C0C0C0C0C0CL;
        x ^= t ^ t << 2;
        t = (x ^ x >>> 4) & 0xF000F000F000F0L;
        x ^= t ^ t << 4;
        t = (x ^ x >>> 8) & 0xFF000000FF00L;
        x ^= t ^ t << 8;
        t = (x ^ x >>> 16) & 0xFFFF0000L;
        return x ^= t ^ t << 16;
    }
}

