/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.rfc7748;

public abstract class X25519 {
    private static final int C_A = 486662;
    private static final int C_A24 = 121666;
    private static final int[] PsubS_x = new int[]{64258704, 46628941, 18905110, 42949224, 8920788, 10663709, 35115447, 21804323, 8973338, 4366948};
    static final int SIZE = 10;
    private static final int M24 = 0xFFFFFF;
    private static final int M25 = 0x1FFFFFF;
    private static final int M26 = 0x3FFFFFF;
    private static final int[] ROOT_NEG_ONE = new int[]{34513072, 59165138, 4688974, 3500415, 6194736, 33281959, 54535759, 32551604, 163342, 5703241};
    private static int[] precompBase = null;

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        int i = 0;
        while (i < 8) {
            n[i] = X25519.decode32(k, kOff + i * 4);
            ++i;
        }
        n[0] = n[0] & 0xFFFFFFF8;
        n[7] = n[7] & Integer.MAX_VALUE;
        n[7] = n[7] | 0x40000000;
    }

    private static void pointDouble(int[] x, int[] z) {
        int[] A = X25519.create();
        int[] B = X25519.create();
        X25519.apm(x, z, A, B);
        X25519.sqr(A, A);
        X25519.sqr(B, B);
        X25519.mul(A, B, x);
        X25519.sub(A, B, A);
        X25519.mul(A, 121666, z);
        X25519.add(z, B, z);
        X25519.mul(z, A, z);
    }

    public static synchronized void precompute() {
        if (precompBase != null) {
            return;
        }
        int[] xs = precompBase = new int[2520];
        int[] zs = new int[2510];
        int[] x = X25519.create();
        x[0] = 9;
        int[] z = X25519.create();
        z[0] = 1;
        int[] n = X25519.create();
        int[] d = X25519.create();
        X25519.apm(x, z, n, d);
        int[] c = X25519.create();
        X25519.copy(d, 0, c, 0);
        int off = 0;
        while (true) {
            X25519.copy(n, 0, xs, off);
            if (off == 2510) break;
            X25519.pointDouble(x, z);
            X25519.apm(x, z, n, d);
            X25519.mul(n, c, n);
            X25519.mul(c, d, c);
            X25519.copy(d, 0, zs, off);
            off += 10;
        }
        int[] u = X25519.create();
        X25519.inv(c, u);
        while (true) {
            X25519.copy(xs, off, x, 0);
            X25519.mul(x, u, x);
            X25519.copy(x, 0, precompBase, off);
            if (off == 0) break;
            X25519.copy(zs, off -= 10, z, 0);
            X25519.mul(u, z, u);
        }
    }

    public static void scalarMult(byte[] k, int kOff, byte[] u, int uOff, byte[] r, int rOff) {
        int[] n = new int[8];
        X25519.decodeScalar(k, kOff, n);
        int[] x1 = X25519.create();
        X25519.decode(u, uOff, x1);
        int[] x2 = X25519.create();
        X25519.copy(x1, 0, x2, 0);
        int[] z2 = X25519.create();
        z2[0] = 1;
        int[] x3 = X25519.create();
        x3[0] = 1;
        int[] z3 = X25519.create();
        int[] t1 = X25519.create();
        int[] t2 = X25519.create();
        int bit = 254;
        int swap = 1;
        do {
            X25519.apm(x3, z3, t1, x3);
            X25519.apm(x2, z2, z3, x2);
            X25519.mul(t1, x2, t1);
            X25519.mul(x3, z3, x3);
            X25519.sqr(z3, z3);
            X25519.sqr(x2, x2);
            X25519.sub(z3, x2, t2);
            X25519.mul(t2, 121666, z2);
            X25519.add(z2, x2, z2);
            X25519.mul(z2, t2, z2);
            X25519.mul(x2, z3, x2);
            X25519.apm(t1, x3, x3, z3);
            X25519.sqr(x3, x3);
            X25519.sqr(z3, z3);
            X25519.mul(z3, x1, z3);
            int word = --bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X25519.cswap(swap ^= kt, x2, x3);
            X25519.cswap(swap, z2, z3);
            swap = kt;
        } while (bit >= 3);
        int i = 0;
        while (i < 3) {
            X25519.pointDouble(x2, z2);
            ++i;
        }
        X25519.inv(z2, z2);
        X25519.mul(x2, z2, x2);
        X25519.normalize(x2);
        X25519.encode(x2, r, rOff);
    }

    public static void scalarMultBase(byte[] k, int kOff, byte[] r, int rOff) {
        X25519.precompute();
        int[] n = new int[8];
        X25519.decodeScalar(k, kOff, n);
        int[] x0 = X25519.create();
        int[] x1 = X25519.create();
        x1[0] = 1;
        int[] z1 = X25519.create();
        z1[0] = 1;
        int[] x2 = X25519.create();
        X25519.copy(PsubS_x, 0, x2, 0);
        int[] z2 = X25519.create();
        z2[0] = 1;
        int[] A = x1;
        int[] B = z1;
        int[] C = x0;
        int[] D = A;
        int[] E = B;
        int off = 0;
        int bit = 3;
        int swap = 1;
        do {
            X25519.copy(precompBase, off, x0, 0);
            off += 10;
            int word = bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X25519.cswap(swap ^= kt, x1, x2);
            X25519.cswap(swap, z1, z2);
            swap = kt;
            X25519.apm(x1, z1, A, B);
            X25519.mul(x0, B, C);
            X25519.carry(A);
            X25519.apm(A, C, D, E);
            X25519.sqr(D, D);
            X25519.sqr(E, E);
            X25519.mul(z2, D, x1);
            X25519.mul(x2, E, z1);
        } while (++bit < 255);
        int i = 0;
        while (i < 3) {
            X25519.pointDouble(x1, z1);
            ++i;
        }
        X25519.inv(z1, z1);
        X25519.mul(x1, z1, x1);
        X25519.normalize(x1);
        X25519.encode(x1, r, rOff);
    }

    static void add(int[] x, int[] y, int[] z) {
        int i = 0;
        while (i < 10) {
            z[i] = x[i] + y[i];
            ++i;
        }
    }

    static void addOne(int[] z) {
        z[0] = z[0] + 1;
    }

    static void addOne(int[] z, int zOff) {
        int n = zOff;
        z[n] = z[n] + 1;
    }

    static void apm(int[] x, int[] y, int[] zp, int[] zm) {
        int i = 0;
        while (i < 10) {
            int xi = x[i];
            int yi = y[i];
            zp[i] = xi + yi;
            zm[i] = xi - yi;
            ++i;
        }
    }

    static void carry(int[] z) {
        int z0 = z[0];
        int z1 = z[1];
        int z2 = z[2];
        int z3 = z[3];
        int z4 = z[4];
        int z5 = z[5];
        int z6 = z[6];
        int z7 = z[7];
        int z8 = z[8];
        int z9 = z[9];
        z3 += z2 >> 25;
        z2 &= 0x1FFFFFF;
        z5 += z4 >> 25;
        z4 &= 0x1FFFFFF;
        z8 += z7 >> 25;
        z7 &= 0x1FFFFFF;
        z0 += (z9 >> 25) * 38;
        z9 &= 0x1FFFFFF;
        z1 += z0 >> 26;
        z0 &= 0x3FFFFFF;
        z6 += z5 >> 26;
        z5 &= 0x3FFFFFF;
        z2 += z1 >> 26;
        z1 &= 0x3FFFFFF;
        z4 += z3 >> 26;
        z3 &= 0x3FFFFFF;
        z7 += z6 >> 26;
        z6 &= 0x3FFFFFF;
        z9 += z8 >> 26;
        z8 &= 0x3FFFFFF;
        z[0] = z0;
        z[1] = z1;
        z[2] = z2;
        z[3] = z3;
        z[4] = z4;
        z[5] = z5;
        z[6] = z6;
        z[7] = z7;
        z[8] = z8;
        z[9] = z9;
    }

    static void cnegate(int negate, int[] z) {
        int mask = 0 - negate;
        int i = 0;
        while (i < 10) {
            z[i] = (z[i] ^ mask) - mask;
            ++i;
        }
    }

    static void copy(int[] x, int xOff, int[] z, int zOff) {
        int i = 0;
        while (i < 10) {
            z[zOff + i] = x[xOff + i];
            ++i;
        }
    }

    static int[] create() {
        return new int[10];
    }

    static int[] createTable(int n) {
        return new int[10 * n];
    }

    static void cswap(int swap, int[] a, int[] b) {
        int mask = 0 - swap;
        int i = 0;
        while (i < 10) {
            int ai = a[i];
            int bi = b[i];
            int dummy = mask & (ai ^ bi);
            a[i] = ai ^ dummy;
            b[i] = bi ^ dummy;
            ++i;
        }
    }

    static void decode(byte[] x, int xOff, int[] z) {
        X25519.decode128(x, xOff, z, 0);
        X25519.decode128(x, xOff + 16, z, 5);
        z[9] = z[9] & 0xFFFFFF;
    }

    private static void decode128(byte[] bs, int off, int[] z, int zOff) {
        int t0 = X25519.decode32(bs, off + 0);
        int t1 = X25519.decode32(bs, off + 4);
        int t2 = X25519.decode32(bs, off + 8);
        int t3 = X25519.decode32(bs, off + 12);
        z[zOff + 0] = t0 & 0x3FFFFFF;
        z[zOff + 1] = (t1 << 6 | t0 >>> 26) & 0x3FFFFFF;
        z[zOff + 2] = (t2 << 12 | t1 >>> 20) & 0x1FFFFFF;
        z[zOff + 3] = (t3 << 19 | t2 >>> 13) & 0x3FFFFFF;
        z[zOff + 4] = t3 >>> 7;
    }

    static void encode(int[] x, byte[] z, int zOff) {
        X25519.encode128(x, 0, z, zOff);
        X25519.encode128(x, 5, z, zOff + 16);
    }

    private static void encode128(int[] x, int xOff, byte[] bs, int off) {
        int x0 = x[xOff + 0];
        int x1 = x[xOff + 1];
        int x2 = x[xOff + 2];
        int x3 = x[xOff + 3];
        int x4 = x[xOff + 4];
        int t0 = x0 | x1 << 26;
        X25519.encode32(t0, bs, off + 0);
        int t1 = x1 >>> 6 | x2 << 20;
        X25519.encode32(t1, bs, off + 4);
        int t2 = x2 >>> 12 | x3 << 13;
        X25519.encode32(t2, bs, off + 8);
        int t3 = x3 >>> 19 | x4 << 7;
        X25519.encode32(t3, bs, off + 12);
    }

    private static void encode32(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    static void inv(int[] x, int[] z) {
        int[] x2 = X25519.create();
        int[] t = X25519.create();
        X25519.powPm5d8(x, x2, t);
        X25519.sqr(t, 3, t);
        X25519.mul(t, x2, z);
    }

    static boolean isZeroVar(int[] x) {
        int d = 0;
        int i = 0;
        while (i < 10) {
            d |= x[i];
            ++i;
        }
        return d == 0;
    }

    static void mul(int[] x, int y, int[] z) {
        int x0 = x[0];
        int x1 = x[1];
        int x2 = x[2];
        int x3 = x[3];
        int x4 = x[4];
        int x5 = x[5];
        int x6 = x[6];
        int x7 = x[7];
        int x8 = x[8];
        int x9 = x[9];
        long c0 = (long)x2 * (long)y;
        x2 = (int)c0 & 0x1FFFFFF;
        c0 >>= 25;
        long c1 = (long)x4 * (long)y;
        x4 = (int)c1 & 0x1FFFFFF;
        c1 >>= 25;
        long c2 = (long)x7 * (long)y;
        x7 = (int)c2 & 0x1FFFFFF;
        c2 >>= 25;
        long c3 = (long)x9 * (long)y;
        x9 = (int)c3 & 0x1FFFFFF;
        c3 >>= 25;
        c3 *= 38L;
        z[0] = (int)(c3 += (long)x0 * (long)y) & 0x3FFFFFF;
        c3 >>= 26;
        z[5] = (int)(c1 += (long)x5 * (long)y) & 0x3FFFFFF;
        c1 >>= 26;
        z[1] = (int)(c3 += (long)x1 * (long)y) & 0x3FFFFFF;
        z[3] = (int)(c0 += (long)x3 * (long)y) & 0x3FFFFFF;
        z[6] = (int)(c1 += (long)x6 * (long)y) & 0x3FFFFFF;
        z[8] = (int)(c2 += (long)x8 * (long)y) & 0x3FFFFFF;
        z[2] = x2 + (int)(c3 >>= 26);
        z[4] = x4 + (int)(c0 >>= 26);
        z[7] = x7 + (int)(c1 >>= 26);
        z[9] = x9 + (int)(c2 >>= 26);
    }

    static void mul(int[] x, int[] y, int[] z) {
        int x0 = x[0];
        int y0 = y[0];
        int x1 = x[1];
        int y1 = y[1];
        int x2 = x[2];
        int y2 = y[2];
        int x3 = x[3];
        int y3 = y[3];
        int x4 = x[4];
        int y4 = y[4];
        int u0 = x[5];
        int v0 = y[5];
        int u1 = x[6];
        int v1 = y[6];
        int u2 = x[7];
        int v2 = y[7];
        int u3 = x[8];
        int v3 = y[8];
        int u4 = x[9];
        int v4 = y[9];
        long a0 = (long)x0 * (long)y0;
        long a1 = (long)x0 * (long)y1 + (long)x1 * (long)y0;
        long a2 = (long)x0 * (long)y2 + (long)x1 * (long)y1 + (long)x2 * (long)y0;
        long a3 = (long)x1 * (long)y2 + (long)x2 * (long)y1;
        a3 <<= 1;
        a3 += (long)x0 * (long)y3 + (long)x3 * (long)y0;
        long a4 = (long)x2 * (long)y2;
        a4 <<= 1;
        a4 += (long)x0 * (long)y4 + (long)x1 * (long)y3 + (long)x3 * (long)y1 + (long)x4 * (long)y0;
        long a5 = (long)x1 * (long)y4 + (long)x2 * (long)y3 + (long)x3 * (long)y2 + (long)x4 * (long)y1;
        a5 <<= 1;
        long a6 = (long)x2 * (long)y4 + (long)x4 * (long)y2;
        a6 <<= 1;
        a6 += (long)x3 * (long)y3;
        long a7 = (long)x3 * (long)y4 + (long)x4 * (long)y3;
        long a8 = (long)x4 * (long)y4;
        a8 <<= 1;
        long b0 = (long)u0 * (long)v0;
        long b1 = (long)u0 * (long)v1 + (long)u1 * (long)v0;
        long b2 = (long)u0 * (long)v2 + (long)u1 * (long)v1 + (long)u2 * (long)v0;
        long b3 = (long)u1 * (long)v2 + (long)u2 * (long)v1;
        b3 <<= 1;
        b3 += (long)u0 * (long)v3 + (long)u3 * (long)v0;
        long b4 = (long)u2 * (long)v2;
        b4 <<= 1;
        b4 += (long)u0 * (long)v4 + (long)u1 * (long)v3 + (long)u3 * (long)v1 + (long)u4 * (long)v0;
        long b5 = (long)u1 * (long)v4 + (long)u2 * (long)v3 + (long)u3 * (long)v2 + (long)u4 * (long)v1;
        long b6 = (long)u2 * (long)v4 + (long)u4 * (long)v2;
        b6 <<= 1;
        long b7 = (long)u3 * (long)v4 + (long)u4 * (long)v3;
        long b8 = (long)u4 * (long)v4;
        a0 -= b5 * 76L;
        a1 -= (b6 += (long)u3 * (long)v3) * 38L;
        a2 -= b7 * 38L;
        a3 -= b8 * 76L;
        a5 -= b0;
        a6 -= b1;
        a7 -= b2;
        a8 -= b3;
        x0 += u0;
        y0 += v0;
        x1 += u1;
        y1 += v1;
        x2 += u2;
        y2 += v2;
        x3 += u3;
        y3 += v3;
        x4 += u4;
        y4 += v4;
        long c0 = (long)x0 * (long)y0;
        long c1 = (long)x0 * (long)y1 + (long)x1 * (long)y0;
        long c2 = (long)x0 * (long)y2 + (long)x1 * (long)y1 + (long)x2 * (long)y0;
        long c3 = (long)x1 * (long)y2 + (long)x2 * (long)y1;
        c3 <<= 1;
        c3 += (long)x0 * (long)y3 + (long)x3 * (long)y0;
        long c4 = (long)x2 * (long)y2;
        c4 <<= 1;
        c4 += (long)x0 * (long)y4 + (long)x1 * (long)y3 + (long)x3 * (long)y1 + (long)x4 * (long)y0;
        long c5 = (long)x1 * (long)y4 + (long)x2 * (long)y3 + (long)x3 * (long)y2 + (long)x4 * (long)y1;
        c5 <<= 1;
        long c6 = (long)x2 * (long)y4 + (long)x4 * (long)y2;
        c6 <<= 1;
        c6 += (long)x3 * (long)y3;
        long c7 = (long)x3 * (long)y4 + (long)x4 * (long)y3;
        long c8 = (long)x4 * (long)y4;
        c8 <<= 1;
        long t = a8 + (c3 - a3);
        int z8 = (int)t & 0x3FFFFFF;
        t >>= 26;
        int z9 = (int)(t += c4 - a4 - b4) & 0x1FFFFFF;
        t >>= 25;
        t = a0 + (t + c5 - a5) * 38L;
        z[0] = (int)t & 0x3FFFFFF;
        t >>= 26;
        z[1] = (int)(t += a1 + (c6 - a6) * 38L) & 0x3FFFFFF;
        t >>= 26;
        z[2] = (int)(t += a2 + (c7 - a7) * 38L) & 0x1FFFFFF;
        t >>= 25;
        z[3] = (int)(t += a3 + (c8 - a8) * 38L) & 0x3FFFFFF;
        t >>= 26;
        z[4] = (int)(t += a4 + b4 * 38L) & 0x1FFFFFF;
        t >>= 25;
        z[5] = (int)(t += a5 + (c0 - a0)) & 0x3FFFFFF;
        t >>= 26;
        z[6] = (int)(t += a6 + (c1 - a1)) & 0x3FFFFFF;
        t >>= 26;
        z[7] = (int)(t += a7 + (c2 - a2)) & 0x1FFFFFF;
        t >>= 25;
        z[8] = (int)(t += (long)z8) & 0x3FFFFFF;
        z[9] = z9 + (int)(t >>= 26);
    }

    static void negate(int[] x, int[] z) {
        int i = 0;
        while (i < 10) {
            z[i] = -x[i];
            ++i;
        }
    }

    static void normalize(int[] z) {
        int x = z[9] >>> 23 & 1;
        X25519.reduce(z, x);
        X25519.reduce(z, -x);
    }

    static void one(int[] z) {
        z[0] = 1;
        int i = 1;
        while (i < 10) {
            z[i] = 0;
            ++i;
        }
    }

    private static void powPm5d8(int[] x, int[] rx2, int[] rz) {
        int[] x2 = rx2;
        X25519.sqr(x, x2);
        X25519.mul(x, x2, x2);
        int[] x3 = X25519.create();
        X25519.sqr(x2, x3);
        X25519.mul(x, x3, x3);
        int[] x5 = x3;
        X25519.sqr(x3, 2, x5);
        X25519.mul(x2, x5, x5);
        int[] x10 = X25519.create();
        X25519.sqr(x5, 5, x10);
        X25519.mul(x5, x10, x10);
        int[] x15 = X25519.create();
        X25519.sqr(x10, 5, x15);
        X25519.mul(x5, x15, x15);
        int[] x25 = x5;
        X25519.sqr(x15, 10, x25);
        X25519.mul(x10, x25, x25);
        int[] x50 = x10;
        X25519.sqr(x25, 25, x50);
        X25519.mul(x25, x50, x50);
        int[] x75 = x15;
        X25519.sqr(x50, 25, x75);
        X25519.mul(x25, x75, x75);
        int[] x125 = x25;
        X25519.sqr(x75, 50, x125);
        X25519.mul(x50, x125, x125);
        int[] x250 = x50;
        X25519.sqr(x125, 125, x250);
        X25519.mul(x125, x250, x250);
        int[] t = x125;
        X25519.sqr(x250, 2, t);
        X25519.mul(t, x, rz);
    }

    private static void reduce(int[] z, int c) {
        int z9;
        int t = z9 = z[9];
        z9 = t & 0xFFFFFF;
        t >>= 24;
        t += c;
        t *= 19;
        z[0] = (t += z[0]) & 0x3FFFFFF;
        t >>= 26;
        z[1] = (t += z[1]) & 0x3FFFFFF;
        t >>= 26;
        z[2] = (t += z[2]) & 0x1FFFFFF;
        t >>= 25;
        z[3] = (t += z[3]) & 0x3FFFFFF;
        t >>= 26;
        z[4] = (t += z[4]) & 0x1FFFFFF;
        t >>= 25;
        z[5] = (t += z[5]) & 0x3FFFFFF;
        t >>= 26;
        z[6] = (t += z[6]) & 0x3FFFFFF;
        t >>= 26;
        z[7] = (t += z[7]) & 0x1FFFFFF;
        t >>= 25;
        z[8] = (t += z[8]) & 0x3FFFFFF;
        t >>= 26;
        z[9] = t += z9;
    }

    static void sqr(int[] x, int[] z) {
        int x0 = x[0];
        int x1 = x[1];
        int x2 = x[2];
        int x3 = x[3];
        int x4 = x[4];
        int u0 = x[5];
        int u1 = x[6];
        int u2 = x[7];
        int u3 = x[8];
        int u4 = x[9];
        int x1_2 = x1 * 2;
        int x2_2 = x2 * 2;
        int x3_2 = x3 * 2;
        int x4_2 = x4 * 2;
        long a0 = (long)x0 * (long)x0;
        long a1 = (long)x0 * (long)x1_2;
        long a2 = (long)x0 * (long)x2_2 + (long)x1 * (long)x1;
        long a3 = (long)x1_2 * (long)x2_2 + (long)x0 * (long)x3_2;
        long a4 = (long)x2 * (long)x2_2 + (long)x0 * (long)x4_2 + (long)x1 * (long)x3_2;
        long a5 = (long)x1_2 * (long)x4_2 + (long)x2_2 * (long)x3_2;
        long a6 = (long)x2_2 * (long)x4_2 + (long)x3 * (long)x3;
        long a7 = (long)x3 * (long)x4_2;
        long a8 = (long)x4 * (long)x4_2;
        int u1_2 = u1 * 2;
        int u2_2 = u2 * 2;
        int u3_2 = u3 * 2;
        int u4_2 = u4 * 2;
        long b0 = (long)u0 * (long)u0;
        long b1 = (long)u0 * (long)u1_2;
        long b2 = (long)u0 * (long)u2_2 + (long)u1 * (long)u1;
        long b3 = (long)u1_2 * (long)u2_2 + (long)u0 * (long)u3_2;
        long b4 = (long)u2 * (long)u2_2 + (long)u0 * (long)u4_2 + (long)u1 * (long)u3_2;
        long b5 = (long)u1_2 * (long)u4_2 + (long)u2_2 * (long)u3_2;
        long b6 = (long)u2_2 * (long)u4_2 + (long)u3 * (long)u3;
        long b7 = (long)u3 * (long)u4_2;
        long b8 = (long)u4 * (long)u4_2;
        a0 -= b5 * 38L;
        a1 -= b6 * 38L;
        a2 -= b7 * 38L;
        a3 -= b8 * 38L;
        a5 -= b0;
        a6 -= b1;
        a7 -= b2;
        a8 -= b3;
        x1_2 = (x1 += u1) * 2;
        x2_2 = (x2 += u2) * 2;
        x3_2 = (x3 += u3) * 2;
        x4_2 = (x4 += u4) * 2;
        long c0 = (long)(x0 += u0) * (long)x0;
        long c1 = (long)x0 * (long)x1_2;
        long c2 = (long)x0 * (long)x2_2 + (long)x1 * (long)x1;
        long c3 = (long)x1_2 * (long)x2_2 + (long)x0 * (long)x3_2;
        long c4 = (long)x2 * (long)x2_2 + (long)x0 * (long)x4_2 + (long)x1 * (long)x3_2;
        long c5 = (long)x1_2 * (long)x4_2 + (long)x2_2 * (long)x3_2;
        long c6 = (long)x2_2 * (long)x4_2 + (long)x3 * (long)x3;
        long c7 = (long)x3 * (long)x4_2;
        long c8 = (long)x4 * (long)x4_2;
        long t = a8 + (c3 - a3);
        int z8 = (int)t & 0x3FFFFFF;
        t >>= 26;
        int z9 = (int)(t += c4 - a4 - b4) & 0x1FFFFFF;
        t >>= 25;
        t = a0 + (t + c5 - a5) * 38L;
        z[0] = (int)t & 0x3FFFFFF;
        t >>= 26;
        z[1] = (int)(t += a1 + (c6 - a6) * 38L) & 0x3FFFFFF;
        t >>= 26;
        z[2] = (int)(t += a2 + (c7 - a7) * 38L) & 0x1FFFFFF;
        t >>= 25;
        z[3] = (int)(t += a3 + (c8 - a8) * 38L) & 0x3FFFFFF;
        t >>= 26;
        z[4] = (int)(t += a4 + b4 * 38L) & 0x1FFFFFF;
        t >>= 25;
        z[5] = (int)(t += a5 + (c0 - a0)) & 0x3FFFFFF;
        t >>= 26;
        z[6] = (int)(t += a6 + (c1 - a1)) & 0x3FFFFFF;
        t >>= 26;
        z[7] = (int)(t += a7 + (c2 - a2)) & 0x1FFFFFF;
        t >>= 25;
        z[8] = (int)(t += (long)z8) & 0x3FFFFFF;
        z[9] = z9 + (int)(t >>= 26);
    }

    static void sqr(int[] x, int n, int[] z) {
        X25519.sqr(x, z);
        while (--n > 0) {
            X25519.sqr(z, z);
        }
    }

    static boolean sqrtRatioVar(int[] u, int[] v, int[] z) {
        int[] uv3 = X25519.create();
        int[] uv7 = X25519.create();
        X25519.mul(u, v, uv3);
        X25519.sqr(v, uv7);
        X25519.mul(uv3, uv7, uv3);
        X25519.sqr(uv7, uv7);
        X25519.mul(uv7, uv3, uv7);
        int[] t = X25519.create();
        int[] x = X25519.create();
        X25519.powPm5d8(uv7, t, x);
        X25519.mul(x, uv3, x);
        int[] vx2 = X25519.create();
        X25519.sqr(x, vx2);
        X25519.mul(vx2, v, vx2);
        X25519.sub(vx2, u, t);
        X25519.normalize(t);
        if (X25519.isZeroVar(t)) {
            X25519.copy(x, 0, z, 0);
            return true;
        }
        X25519.add(vx2, u, t);
        X25519.normalize(t);
        if (X25519.isZeroVar(t)) {
            X25519.mul(x, ROOT_NEG_ONE, z);
            return true;
        }
        return false;
    }

    static void sub(int[] x, int[] y, int[] z) {
        int i = 0;
        while (i < 10) {
            z[i] = x[i] - y[i];
            ++i;
        }
    }

    static void subOne(int[] z) {
        z[0] = z[0] - 1;
    }

    static void zero(int[] z) {
        int i = 0;
        while (i < 10) {
            z[i] = 0;
            ++i;
        }
    }
}

