/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.hash.GOSTSBox;
import org.denom.crypt.hash.IHash;

public class GOST3411_94
extends IHash {
    public static final int HASH_SIZE = 32;
    private static final int BLOCK_SIZE = 32;
    private byte[] H = new byte[32];
    private byte[] M = new byte[32];
    private byte[] Sum = new byte[32];
    private byte[][] C = new byte[4][32];
    private Binary L = new Binary(32);
    byte[] a = new byte[8];
    private byte[] S = new byte[32];
    private byte[] U = new byte[32];
    private byte[] V = new byte[32];
    private byte[] W = new byte[32];
    private short[] wS = new short[16];
    private short[] w_S = new short[16];
    private static final byte[] C2;
    private int[] workingKey = new int[8];
    private byte[] SBox = GOSTSBox.D_A;

    static {
        byte[] byArray = new byte[32];
        byArray[1] = -1;
        byArray[3] = -1;
        byArray[5] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[10] = -1;
        byArray[12] = -1;
        byArray[14] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[20] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[31] = -1;
        C2 = byArray;
    }

    public GOST3411_94() {
        super(32);
        this.reset();
    }

    @Override
    public GOST3411_94 clone() {
        Ex.THROW("GOST3411_94 clone Not implemented");
        return null;
    }

    @Override
    public GOST3411_94 cloneState() {
        Ex.THROW("GOST3411_94 cloneState Not implemented");
        return null;
    }

    @Override
    public String name() {
        return "GOST3411";
    }

    @Override
    public int size() {
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.Sum, (byte)0);
        Arrays.fill(this.H, (byte)0);
        Arrays.fill(this.C[1], (byte)0);
        Arrays.fill(this.C[3], (byte)0);
        System.arraycopy(C2, 0, this.C[2], 0, C2.length);
    }

    @Override
    public Binary getHash() {
        this.finish();
        Binary hash = new Binary(this.H);
        this.reset();
        return hash;
    }

    private void finish() {
        if (this.tail.size() != 0) {
            this.tail.resize(32);
            this.processBlock(this.tail, 0);
        }
        this.L.setLongLE(0, this.processedBytes << 3);
        this.processBlockMain(this.L.getDataRef(), 0);
        this.processBlockMain(this.Sum, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        this.sumByteArray(data.getDataRef(), offset);
        this.processBlockMain(data.getDataRef(), offset);
    }

    private byte[] A(byte[] in) {
        int j = 0;
        while (j < 8) {
            this.a[j] = (byte)(in[j] ^ in[j + 8]);
            ++j;
        }
        System.arraycopy(in, 8, in, 0, 24);
        System.arraycopy(this.a, 0, in, 24, 8);
        return in;
    }

    private void Encrypt(byte[] s, int sOff, byte[] in, int inOff) {
        int i = 0;
        while (i < 8) {
            this.workingKey[i] = this.W[i] & 0xFF | (this.W[8 + i] & 0xFF) << 8 | (this.W[16 + i] & 0xFF) << 16 | this.W[24 + i] << 24;
            ++i;
        }
        this.GOST28147Func(in, inOff, s, sOff);
    }

    private void fw() {
        int i = 0;
        while (i < this.S.length / 2) {
            this.wS[i] = (short)(this.S[i * 2 + 1] << 8 | this.S[i * 2] & 0xFF);
            ++i;
        }
        this.w_S[15] = (short)(this.wS[0] ^ this.wS[1] ^ this.wS[2] ^ this.wS[3] ^ this.wS[12] ^ this.wS[15]);
        System.arraycopy(this.wS, 1, this.w_S, 0, 15);
        i = 0;
        while (i < this.S.length / 2) {
            this.S[i * 2 + 1] = (byte)(this.w_S[i] >> 8);
            this.S[i * 2] = (byte)this.w_S[i];
            ++i;
        }
    }

    private void processBlockMain(byte[] in, int inOff) {
        System.arraycopy(in, inOff, this.M, 0, 32);
        System.arraycopy(this.H, 0, this.U, 0, 32);
        System.arraycopy(this.M, 0, this.V, 0, 32);
        int j = 0;
        while (j < 32) {
            this.W[j] = (byte)(this.U[j] ^ this.V[j]);
            ++j;
        }
        this.Encrypt(this.S, 0, this.H, 0);
        int i = 1;
        while (i < 4) {
            byte[] tmpA = this.A(this.U);
            int j2 = 0;
            while (j2 < 32) {
                this.U[j2] = (byte)(tmpA[j2] ^ this.C[i][j2]);
                ++j2;
            }
            this.V = this.A(this.A(this.V));
            j2 = 0;
            while (j2 < 32) {
                this.W[j2] = (byte)(this.U[j2] ^ this.V[j2]);
                ++j2;
            }
            this.Encrypt(this.S, i * 8, this.H, i * 8);
            ++i;
        }
        int n = 0;
        while (n < 12) {
            this.fw();
            ++n;
        }
        i = 0;
        while (i < 32) {
            this.S[i] = (byte)(this.S[i] ^ this.M[i]);
            ++i;
        }
        this.fw();
        i = 0;
        while (i < 32) {
            this.S[i] = (byte)(this.S[i] ^ this.H[i]);
            ++i;
        }
        i = 0;
        while (i < 61) {
            this.fw();
            ++i;
        }
        System.arraycopy(this.S, 0, this.H, 0, this.H.length);
    }

    private void sumByteArray(byte[] in, int offset) {
        int i = 0;
        int carry = 0;
        while (i != this.Sum.length) {
            int sum = (this.Sum[i] & 0xFF) + (in[offset + i] & 0xFF) + carry;
            this.Sum[i] = (byte)sum;
            carry = sum >>> 8;
            ++i;
        }
    }

    private int GOST28147Step(int n1, int key) {
        int cm = key + n1;
        int om = this.SBox[0 + (cm >> 0 & 0xF)] << 0;
        om += this.SBox[16 + (cm >> 4 & 0xF)] << 4;
        om += this.SBox[32 + (cm >> 8 & 0xF)] << 8;
        om += this.SBox[48 + (cm >> 12 & 0xF)] << 12;
        om += this.SBox[64 + (cm >> 16 & 0xF)] << 16;
        om += this.SBox[80 + (cm >> 20 & 0xF)] << 20;
        om += this.SBox[96 + (cm >> 24 & 0xF)] << 24;
        return Integer.rotateLeft(om += this.SBox[112 + (cm >> 28 & 0xF)] << 28, 11);
    }

    void GOST28147Func(byte[] in, int inOff, byte[] out, int outOff) {
        int N1 = this.bytesToInt(in, inOff);
        int N2 = this.bytesToInt(in, inOff + 4);
        int k = 0;
        while (k < 3) {
            int j = 0;
            while (j < 8) {
                int t = N1;
                N1 = N2 ^ this.GOST28147Step(N1, this.workingKey[j]);
                N2 = t;
                ++j;
            }
            ++k;
        }
        int j = 7;
        while (j > 0) {
            int t = N1;
            N1 = N2 ^ this.GOST28147Step(N1, this.workingKey[j]);
            N2 = t;
            --j;
        }
        this.intToBytes(N1, out, outOff);
        this.intToBytes(N2 ^= this.GOST28147Step(N1, this.workingKey[0]), out, outOff + 4);
    }

    private int bytesToInt(byte[] in, int inOff) {
        return (in[inOff + 3] << 24 & 0xFF000000) + (in[inOff + 2] << 16 & 0xFF0000) + (in[inOff + 1] << 8 & 0xFF00) + (in[inOff] & 0xFF);
    }

    private void intToBytes(int num, byte[] out, int outOff) {
        out[outOff + 3] = (byte)(num >>> 24);
        out[outOff + 2] = (byte)(num >>> 16);
        out[outOff + 1] = (byte)(num >>> 8);
        out[outOff] = (byte)num;
    }
}

