/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.denom.Binary;
import org.denom.Ex;

public abstract class IHash
implements Cloneable {
    final int blockSize;
    Binary tail;
    long processedBytes = 0L;

    protected IHash(int blockSize) {
        this.blockSize = blockSize;
        this.tail = new Binary().reserve(blockSize);
    }

    public abstract int size();

    public abstract String name();

    public final Binary calc(Binary data) {
        return this.calc(data, 0, data.size());
    }

    public final Binary calc(Binary data, int offset, int len) {
        this.reset();
        this.process(data, offset, len);
        return this.getHash();
    }

    public void reset() {
        this.processedBytes = 0L;
        this.tail.clear();
    }

    public final void process(Binary data) {
        this.process(data, 0, data.size());
    }

    protected abstract void processBlock(Binary var1, int var2);

    public void process(Binary data, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.processedBytes += (long)length;
        if (!this.tail.empty()) {
            int part1 = Math.min(this.blockSize - this.tail.size(), length);
            this.tail.add(data.getDataRef(), offset, part1);
            offset += part1;
            length -= part1;
            if (this.tail.size() == this.blockSize) {
                this.processBlock(this.tail, 0);
                this.tail.clear();
            }
        }
        while (length >= this.blockSize) {
            this.processBlock(data, offset);
            offset += this.blockSize;
            length -= this.blockSize;
        }
        if (length != 0) {
            this.tail.assign(data, offset, length);
        }
    }

    public Binary calcFileHash(String fileName) {
        this.reset();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RandomAccessFile file = new RandomAccessFile(fileName, "r");){
                Binary buf = new Binary();
                long size = file.length();
                while (size > 0L) {
                    buf.resize(65536);
                    int chunkSize = file.read(buf.getDataRef(), 0, buf.getDataRef().length);
                    Ex.MUST(chunkSize > 0, "Error while hashing file " + fileName);
                    buf.resize(chunkSize);
                    this.process(buf);
                    size -= (long)chunkSize;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
        return this.getHash();
    }

    public abstract Binary getHash();

    public abstract IHash clone();

    public abstract IHash cloneState();

    protected IHash cloneStateBase() {
        IHash cloned = this.clone();
        Ex.MUST(cloned.blockSize == this.blockSize, "Wrong implementation of cloneState");
        cloned.tail = this.tail.clone();
        cloned.processedBytes = this.processedBytes;
        return cloned;
    }
}

