/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.hash.IHash;

public class Keccak
extends IHash {
    protected int hashSizeBits;
    protected byte padBits = 1;
    protected long[] state = new long[25];
    private static long[] CONSTANTS = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};

    public Keccak(int bitLen) {
        super(1600 - (bitLen << 1) >>> 3);
        Ex.MUST(bitLen == 128 || bitLen == 224 || bitLen == 256 || bitLen == 288 || bitLen == 384 || bitLen == 512, "Wrong hash size for Keccak");
        this.hashSizeBits = bitLen;
        this.reset();
    }

    @Override
    public int size() {
        return this.hashSizeBits >>> 3;
    }

    @Override
    public String name() {
        return "Keccak-" + this.hashSizeBits;
    }

    @Override
    public Keccak clone() {
        return new Keccak(this.hashSizeBits);
    }

    @Override
    public Keccak cloneState() {
        Keccak cloned = (Keccak)super.cloneStateBase();
        Ex.MUST(cloned.hashSizeBits == this.hashSizeBits, "Wrong implementation of cloneState");
        Ex.MUST(cloned.padBits == this.padBits, "Wrong implementation of cloneState");
        cloned.state = Arrays.copyOf(this.state, this.state.length);
        return cloned;
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.state, 0L);
    }

    @Override
    public Binary getHash() {
        return this.getHash(this.hashSizeBits >>> 3);
    }

    public Binary getHash(int wantHashSize) {
        this.finish();
        Binary hash = this.squeeze(wantHashSize);
        this.reset();
        return hash;
    }

    private void finish() {
        int tailLen = this.tail.size();
        if (tailLen + 1 == this.blockSize) {
            this.tail.add(this.padBits | 0x80);
        } else {
            this.tail.resize(this.blockSize);
            this.tail.set(tailLen, this.padBits);
            this.tail.set(this.tail.size() - 1, 128);
        }
        this.processBlock(this.tail, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        int i = 0;
        while (i < this.blockSize >>> 3) {
            int n = i++;
            this.state[n] = this.state[n] ^ data.getLongLE(offset);
            offset += 8;
        }
        this.permutation();
    }

    private Binary squeeze(int wantHashSize) {
        Binary hash = new Binary().reserve(wantHashSize);
        int i = 0;
        while (hash.size() < wantHashSize) {
            if (hash.size() > 0 && hash.size() % this.blockSize == 0) {
                this.permutation();
                i = 0;
            }
            hash.addLongLE(this.state[i]);
            ++i;
        }
        hash.resize(wantHashSize);
        return hash;
    }

    private void permutation() {
        long[] A = this.state;
        long a00 = A[0];
        long a01 = A[1];
        long a02 = A[2];
        long a03 = A[3];
        long a04 = A[4];
        long a05 = A[5];
        long a06 = A[6];
        long a07 = A[7];
        long a08 = A[8];
        long a09 = A[9];
        long a10 = A[10];
        long a11 = A[11];
        long a12 = A[12];
        long a13 = A[13];
        long a14 = A[14];
        long a15 = A[15];
        long a16 = A[16];
        long a17 = A[17];
        long a18 = A[18];
        long a19 = A[19];
        long a20 = A[20];
        long a21 = A[21];
        long a22 = A[22];
        long a23 = A[23];
        long a24 = A[24];
        int i = 0;
        while (i < 24) {
            long c0 = a00 ^ a05 ^ a10 ^ a15 ^ a20;
            long c1 = a01 ^ a06 ^ a11 ^ a16 ^ a21;
            long c2 = a02 ^ a07 ^ a12 ^ a17 ^ a22;
            long c3 = a03 ^ a08 ^ a13 ^ a18 ^ a23;
            long c4 = a04 ^ a09 ^ a14 ^ a19 ^ a24;
            long d1 = Long.rotateLeft(c1, 1) ^ c4;
            long d2 = Long.rotateLeft(c2, 1) ^ c0;
            long d3 = Long.rotateLeft(c3, 1) ^ c1;
            long d4 = Long.rotateLeft(c4, 1) ^ c2;
            long d0 = Long.rotateLeft(c0, 1) ^ c3;
            a00 ^= d1;
            a05 ^= d1;
            a10 ^= d1;
            a15 ^= d1;
            a20 ^= d1;
            a01 ^= d2;
            a06 ^= d2;
            a11 ^= d2;
            a16 ^= d2;
            a21 ^= d2;
            a02 ^= d3;
            a07 ^= d3;
            a12 ^= d3;
            a17 ^= d3;
            a22 ^= d3;
            a03 ^= d4;
            a08 ^= d4;
            a13 ^= d4;
            a18 ^= d4;
            a23 ^= d4;
            a04 ^= d0;
            a09 ^= d0;
            a14 ^= d0;
            a19 ^= d0;
            a24 ^= d0;
            c1 = Long.rotateLeft(a01, 1);
            a01 = Long.rotateLeft(a06, 44);
            a06 = Long.rotateLeft(a09, 20);
            a09 = Long.rotateLeft(a22, 61);
            a22 = Long.rotateLeft(a14, 39);
            a14 = Long.rotateLeft(a20, 18);
            a20 = Long.rotateLeft(a02, 62);
            a02 = Long.rotateLeft(a12, 43);
            a12 = Long.rotateLeft(a13, 25);
            a13 = Long.rotateLeft(a19, 8);
            a19 = Long.rotateLeft(a23, 56);
            a23 = Long.rotateLeft(a15, 41);
            a15 = Long.rotateLeft(a04, 27);
            a04 = Long.rotateLeft(a24, 14);
            a24 = Long.rotateLeft(a21, 2);
            a21 = Long.rotateLeft(a08, 55);
            a08 = Long.rotateLeft(a16, 45);
            a16 = Long.rotateLeft(a05, 36);
            a05 = Long.rotateLeft(a03, 28);
            a03 = Long.rotateLeft(a18, 21);
            a18 = Long.rotateLeft(a17, 15);
            a17 = Long.rotateLeft(a11, 10);
            a11 = Long.rotateLeft(a07, 6);
            a07 = Long.rotateLeft(a10, 3);
            a10 = c1;
            c0 = a00 ^ (a01 ^ 0xFFFFFFFFFFFFFFFFL) & a02;
            c1 = a01 ^ (a02 ^ 0xFFFFFFFFFFFFFFFFL) & a03;
            a02 ^= (a03 ^ 0xFFFFFFFFFFFFFFFFL) & a04;
            a03 ^= (a04 ^ 0xFFFFFFFFFFFFFFFFL) & a00;
            a04 ^= (a00 ^ 0xFFFFFFFFFFFFFFFFL) & a01;
            a00 = c0;
            a01 = c1;
            c0 = a05 ^ (a06 ^ 0xFFFFFFFFFFFFFFFFL) & a07;
            c1 = a06 ^ (a07 ^ 0xFFFFFFFFFFFFFFFFL) & a08;
            a07 ^= (a08 ^ 0xFFFFFFFFFFFFFFFFL) & a09;
            a08 ^= (a09 ^ 0xFFFFFFFFFFFFFFFFL) & a05;
            a09 ^= (a05 ^ 0xFFFFFFFFFFFFFFFFL) & a06;
            a05 = c0;
            a06 = c1;
            c0 = a10 ^ (a11 ^ 0xFFFFFFFFFFFFFFFFL) & a12;
            c1 = a11 ^ (a12 ^ 0xFFFFFFFFFFFFFFFFL) & a13;
            a12 ^= (a13 ^ 0xFFFFFFFFFFFFFFFFL) & a14;
            a13 ^= (a14 ^ 0xFFFFFFFFFFFFFFFFL) & a10;
            a14 ^= (a10 ^ 0xFFFFFFFFFFFFFFFFL) & a11;
            a10 = c0;
            a11 = c1;
            c0 = a15 ^ (a16 ^ 0xFFFFFFFFFFFFFFFFL) & a17;
            c1 = a16 ^ (a17 ^ 0xFFFFFFFFFFFFFFFFL) & a18;
            a17 ^= (a18 ^ 0xFFFFFFFFFFFFFFFFL) & a19;
            a18 ^= (a19 ^ 0xFFFFFFFFFFFFFFFFL) & a15;
            a19 ^= (a15 ^ 0xFFFFFFFFFFFFFFFFL) & a16;
            a15 = c0;
            a16 = c1;
            c0 = a20 ^ (a21 ^ 0xFFFFFFFFFFFFFFFFL) & a22;
            c1 = a21 ^ (a22 ^ 0xFFFFFFFFFFFFFFFFL) & a23;
            a22 ^= (a23 ^ 0xFFFFFFFFFFFFFFFFL) & a24;
            a23 ^= (a24 ^ 0xFFFFFFFFFFFFFFFFL) & a20;
            a24 ^= (a20 ^ 0xFFFFFFFFFFFFFFFFL) & a21;
            a20 = c0;
            a21 = c1;
            a00 ^= CONSTANTS[i];
            ++i;
        }
        A[0] = a00;
        A[1] = a01;
        A[2] = a02;
        A[3] = a03;
        A[4] = a04;
        A[5] = a05;
        A[6] = a06;
        A[7] = a07;
        A[8] = a08;
        A[9] = a09;
        A[10] = a10;
        A[11] = a11;
        A[12] = a12;
        A[13] = a13;
        A[14] = a14;
        A[15] = a15;
        A[16] = a16;
        A[17] = a17;
        A[18] = a18;
        A[19] = a19;
        A[20] = a20;
        A[21] = a21;
        A[22] = a22;
        A[23] = a23;
        A[24] = a24;
    }
}

