/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.hash.SHA512;

public class SHA512t
extends SHA512 {
    private int hashSizeBits;
    private long[] IV = new long[8];

    public SHA512t() {
        this(256);
    }

    public SHA512t(int hashSizeBits) {
        super(0);
        Ex.MUST(hashSizeBits < 512 && hashSizeBits > 0 && (hashSizeBits & 7) == 0, "hashSize needs to be a multiple of 8 and less than 512");
        Ex.MUST(hashSizeBits != 384, "Wrong hashSize - use SHA384 instead");
        this.hashSizeBits = hashSizeBits;
        this.calcIV();
        this.reset();
    }

    @Override
    public String name() {
        return "SHA-512/" + Integer.toString(this.hashSizeBits);
    }

    @Override
    public int size() {
        return this.hashSizeBits >>> 3;
    }

    @Override
    public SHA512t clone() {
        return new SHA512t(this.hashSizeBits);
    }

    @Override
    public SHA512t cloneState() {
        SHA512t cloned = (SHA512t)super.cloneState();
        Ex.MUST(cloned.hashSizeBits == this.hashSizeBits, "Wrong implementation of cloneState");
        Ex.MUST(Arrays.equals(cloned.IV, this.IV), "Wrong implementation of cloneState");
        return cloned;
    }

    private void calcIV() {
        this.H[0] = -3482333909917012819L;
        this.H[1] = 2216346199247487646L;
        this.H[2] = -7364697282686394994L;
        this.H[3] = 65953792586715988L;
        this.H[4] = -816286391624063116L;
        this.H[5] = 4512832404995164602L;
        this.H[6] = -5033199132376557362L;
        this.H[7] = -124578254951840548L;
        super.process(new Binary(this.name().getBytes()));
        super.finish();
        System.arraycopy(this.H, 0, this.IV, 0, this.H.length);
    }

    @Override
    public void reset() {
        super.reset();
        System.arraycopy(this.IV, 0, this.H, 0, this.H.length);
    }

    @Override
    public Binary getHash() {
        return super.getHash().first(this.hashSizeBits >>> 3);
    }
}

