/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.StreamCipher;

public class HC128
extends StreamCipher {
    private int[] p = new int[512];
    private int[] q = new int[512];
    private int cnt = 0;
    private byte[] buf = new byte[4];
    private int idx = 0;
    int[] w = new int[1280];

    public HC128() {
        this(Binary.Bin(16));
    }

    public HC128(Binary key) {
        this.setKey(key);
    }

    @Override
    public String getAlgName() {
        return "HC-128";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16, "Wrong key size");
        this.key = key.clone();
    }

    @Override
    public HC128 startEncrypt(Binary iv) {
        this.init(iv);
        return this;
    }

    @Override
    public HC128 startDecrypt(Binary iv) {
        this.init(iv);
        return this;
    }

    private void init(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 16, "Wrong IV size");
        this.idx = 0;
        this.cnt = 0;
        Arrays.fill(this.w, 0);
        int i = 0;
        while (i < 16) {
            int n = i >> 2;
            this.w[n] = this.w[n] | this.key.get(i) << 8 * (i & 3);
            ++i;
        }
        System.arraycopy(this.w, 0, this.w, 4, 4);
        i = 0;
        while (i < iv.size() && i < 16) {
            int n = (i >> 2) + 8;
            this.w[n] = this.w[n] | iv.get(i) << 8 * (i & 3);
            ++i;
        }
        System.arraycopy(this.w, 8, this.w, 12, 4);
        i = 16;
        while (i < 1280) {
            int x = this.w[i - 2];
            int y = this.w[i - 15];
            this.w[i] = (Integer.rotateRight(x, 17) ^ Integer.rotateRight(x, 19) ^ x >>> 10) + this.w[i - 7] + (Integer.rotateRight(y, 7) ^ Integer.rotateRight(y, 18) ^ y >>> 3) + this.w[i - 16] + i;
            ++i;
        }
        System.arraycopy(this.w, 256, this.p, 0, 512);
        System.arraycopy(this.w, 768, this.q, 0, 512);
        i = 0;
        while (i < 512) {
            this.p[i] = this.step();
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.q[i] = this.step();
            ++i;
        }
        this.cnt = 0;
    }

    @Override
    public byte process(byte in) {
        return (byte)(in ^ this.getByte());
    }

    private byte getByte() {
        if (this.idx == 0) {
            Binary.setIntLE(this.buf, 0, this.step());
        }
        byte ret = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return ret;
    }

    private int step() {
        int ret;
        int j = HC128.mod512(this.cnt);
        if (this.cnt < 512) {
            int x = this.p[HC128.mod512(j - 3)];
            int y = this.p[HC128.mod512(j - 10)];
            int z = this.p[HC128.mod512(j - 511)];
            int n = j;
            this.p[n] = this.p[n] + ((Integer.rotateRight(x, 10) ^ Integer.rotateRight(z, 23)) + Integer.rotateRight(y, 8));
            ret = this.h1(this.p[HC128.mod512(j - 12)]) ^ this.p[j];
        } else {
            int x = this.q[HC128.mod512(j - 3)];
            int y = this.q[HC128.mod512(j - 10)];
            int z = this.q[HC128.mod512(j - 511)];
            int n = j;
            this.q[n] = this.q[n] + ((Integer.rotateLeft(x, 10) ^ Integer.rotateLeft(z, 23)) + Integer.rotateLeft(y, 8));
            ret = this.h2(this.q[HC128.mod512(j - 12)]) ^ this.q[j];
        }
        this.cnt = this.cnt + 1 & 0x3FF;
        return ret;
    }

    private int h1(int x) {
        return this.q[x & 0xFF] + this.q[(x >> 16 & 0xFF) + 256];
    }

    private int h2(int x) {
        return this.p[x & 0xFF] + this.p[(x >> 16 & 0xFF) + 256];
    }

    private static int mod512(int x) {
        return x & 0x1FF;
    }
}

