/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.StreamCipher;

public class HC256
extends StreamCipher {
    int[] w = new int[2560];
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] buf = new byte[4];
    private int idx = 0;

    public HC256() {
        this(Binary.Bin(32));
    }

    public HC256(Binary key) {
        this.setKey(key);
    }

    @Override
    public String getAlgName() {
        return "HC-256";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Wrong key size");
        this.key = key.clone();
    }

    @Override
    public HC256 startEncrypt(Binary iv) {
        this.init(iv);
        return this;
    }

    @Override
    public HC256 startDecrypt(Binary iv) {
        this.init(iv);
        return this;
    }

    private void init(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 32, "Wrong IV size");
        this.idx = 0;
        this.cnt = 0;
        Arrays.fill(this.w, 0);
        int i = 0;
        while (i < 32) {
            int n = i >> 2;
            this.w[n] = this.w[n] | this.key.get(i) << 8 * (i & 3);
            ++i;
        }
        i = 0;
        while (i < 32) {
            int n = (i >> 2) + 8;
            this.w[n] = this.w[n] | iv.get(i) << 8 * (i & 3);
            ++i;
        }
        i = 16;
        while (i < 2560) {
            int x = this.w[i - 2];
            int y = this.w[i - 15];
            this.w[i] = (Integer.rotateRight(x, 17) ^ Integer.rotateRight(x, 19) ^ x >>> 10) + this.w[i - 7] + (Integer.rotateRight(y, 7) ^ Integer.rotateRight(y, 18) ^ y >>> 3) + this.w[i - 16] + i;
            ++i;
        }
        System.arraycopy(this.w, 512, this.p, 0, 1024);
        System.arraycopy(this.w, 1536, this.q, 0, 1024);
        i = 0;
        while (i < 4096) {
            this.step();
            ++i;
        }
        this.cnt = 0;
    }

    @Override
    public byte process(byte in) {
        return (byte)(in ^ this.getByte());
    }

    private byte getByte() {
        if (this.idx == 0) {
            Binary.setIntLE(this.buf, 0, this.step());
        }
        byte ret = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return ret;
    }

    private int step() {
        int ret;
        int j = this.cnt & 0x3FF;
        if (this.cnt < 1024) {
            int x = this.p[j - 3 & 0x3FF];
            int y = this.p[j - 1023 & 0x3FF];
            int n = j;
            this.p[n] = this.p[n] + (this.p[j - 10 & 0x3FF] + (Integer.rotateRight(x, 10) ^ Integer.rotateRight(y, 23)) + this.q[(x ^ y) & 0x3FF]);
            x = this.p[j - 12 & 0x3FF];
            ret = this.q[x & 0xFF] + this.q[(x >> 8 & 0xFF) + 256] + this.q[(x >> 16 & 0xFF) + 512] + this.q[(x >> 24 & 0xFF) + 768] ^ this.p[j];
        } else {
            int x = this.q[j - 3 & 0x3FF];
            int y = this.q[j - 1023 & 0x3FF];
            int n = j;
            this.q[n] = this.q[n] + (this.q[j - 10 & 0x3FF] + (Integer.rotateRight(x, 10) ^ Integer.rotateRight(y, 23)) + this.p[(x ^ y) & 0x3FF]);
            x = this.q[j - 12 & 0x3FF];
            ret = this.p[x & 0xFF] + this.p[(x >> 8 & 0xFF) + 256] + this.p[(x >> 16 & 0xFF) + 512] + this.p[(x >> 24 & 0xFF) + 768] ^ this.q[j];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return ret;
    }
}

