/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.x509;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.ec.ECAlg;
import org.denom.crypt.hash.SHA1;
import org.denom.crypt.hash.SHA256;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;

public class CertificateX509v3 {
    public Binary tbsCertificateFull;
    public BerTLVList tbsCertificate;
    public Binary signatureAlgorithm;
    public Binary signatureValue;
    public Binary serialNumber;
    public HashMap<Binary, BerTLV> issuer = new HashMap();
    public long validityNotBefore;
    public long validityNotAfter;
    public HashMap<Binary, BerTLV> subject = new HashMap();
    public Binary subjectPublicKeyAlgorithm;
    public Binary subjectPublicKey;
    Binary issuerUniqueID = Binary.Bin();
    Binary subjectUniqueID = Binary.Bin();
    public HashMap<Binary, BerTLVList> extensions = new HashMap();

    private static long parseTime(BerTLV tlvTime) {
        Ex.MUST(tlvTime.tag == 23 || tlvTime.tag == 24, "Wrong X.509 Certificate: validity tags: wrong time tag");
        String s = tlvTime.value.asUTF8();
        Ex.MUST(s.charAt(s.length() - 1) == 'Z', "Wrong X.509 Certificate: validity time string");
        String format = tlvTime.tag == 23 ? "yyMMddHHmmssX" : "yyyyMMddHHmmssX";
        OffsetDateTime dateTime = OffsetDateTime.parse(s, DateTimeFormatter.ofPattern(format));
        return dateTime.toEpochSecond();
    }

    private static void parseName(BerTLV tlvName, String fieldName, HashMap<Binary, BerTLV> attributes) {
        attributes.clear();
        String errMsg = "Wrong X.509 Certificate: " + fieldName;
        Ex.MUST(tlvName.tag == 48, errMsg);
        BerTLVList tlvs = new BerTLVList(tlvName.value);
        for (BerTLV tlv : tlvs.recs) {
            Ex.MUST(tlv.tag == 49, errMsg);
            BerTLV attribTlv = new BerTLV(tlv.value);
            Ex.MUST(attribTlv.tag == 48, errMsg);
            BerTLVList tl = new BerTLVList(attribTlv.value);
            Ex.MUST(tl.recs.size() == 2, errMsg);
            Ex.MUST(tl.recs.get((int)0).tag == 6, errMsg);
            Binary attrOID = tl.recs.get((int)0).value;
            attributes.put(attrOID, tl.recs.get(1));
        }
    }

    private void parseTbs() {
        Ex.MUST(this.tbsCertificate.recs.size() >= 7, "Wrong X.509 Certificate: 'tbsCertificate' tags number < 7");
        BerTLV tlv0 = this.tbsCertificate.recs.get(0);
        Ex.MUST(tlv0.tag == 160 && tlv0.value.equals("02  01  02"), "Wrong X.509 Certificate: version");
        BerTLV tlv1 = this.tbsCertificate.recs.get(1);
        Ex.MUST(tlv1.tag == 2, "Wrong X.509 Certificate: serialNumber");
        this.serialNumber = tlv1.value;
        BerTLV tlv2 = this.tbsCertificate.recs.get(2);
        Ex.MUST(tlv2.tag == 48, "Wrong X.509 Certificate: signature");
        Binary signature = tlv2.value;
        Ex.MUST(signature.equals(this.signatureAlgorithm), "Wrong X.509 Certificate: 'signature' not equal to 'signatureAlgorithm'");
        CertificateX509v3.parseName(this.tbsCertificate.recs.get(3), "issuer", this.issuer);
        BerTLV tlv4 = this.tbsCertificate.recs.get(4);
        Ex.MUST(tlv4.tag == 48, "Wrong X.509 Certificate: validity");
        BerTLVList tlvs = new BerTLVList(tlv4.value);
        Ex.MUST(tlvs.recs.size() == 2, "Wrong X.509 Certificate: validity tags: wrong number");
        this.validityNotBefore = CertificateX509v3.parseTime(tlvs.recs.get(0));
        this.validityNotAfter = CertificateX509v3.parseTime(tlvs.recs.get(1));
        CertificateX509v3.parseName(this.tbsCertificate.recs.get(5), "subject", this.subject);
        BerTLV tlv6 = this.tbsCertificate.recs.get(6);
        Ex.MUST(tlv6.tag == 48, "Wrong X.509 Certificate: subjectPublicKeyInfo");
        tlvs.assign(tlv6.value);
        Ex.MUST(tlvs.recs.size() == 2 && tlvs.recs.get((int)0).tag == 48 && tlvs.recs.get((int)1).tag == 3, "Wrong X.509 Certificate: subjectPublicKeyInfo");
        this.subjectPublicKeyAlgorithm = tlvs.recs.get((int)0).value;
        Binary b = tlvs.recs.get((int)1).value;
        this.subjectPublicKey = b.last(b.size() - 1);
        Binary val = this.tbsCertificate.find((String)"81").value;
        if (!val.empty()) {
            this.issuerUniqueID = val.last(val.size() - 1);
        }
        if (!(val = this.tbsCertificate.find((String)"82").value).empty()) {
            this.subjectUniqueID = val.last(val.size() - 1);
        }
        this.extensions.clear();
        val = this.tbsCertificate.find((String)"A3/30").value;
        if (!val.empty()) {
            tlvs.assign(val);
            for (BerTLV tlv : tlvs.recs) {
                Ex.MUST(tlv.tag == 48, "Wrong X.509 Certificate: extensions");
                BerTLVList extensionTlvs = new BerTLVList(tlv.value);
                BerTLV oidTlv = extensionTlvs.recs.get(0);
                Ex.MUST(oidTlv.tag == 6, "Wrong X.509 Certificate: extensions: oid tag");
                this.extensions.put(oidTlv.value, extensionTlvs);
            }
        }
    }

    public CertificateX509v3 fromBin(Binary cert) {
        BerTLVList tlvs = new BerTLVList(cert);
        Ex.MUST(tlvs.recs.size() == 1 && tlvs.recs.get((int)0).tag == 48, "Wrong X.509 Certificate: TLV structure");
        Binary certValue = tlvs.recs.get((int)0).value;
        tlvs.assign(certValue);
        Ex.MUST(tlvs.recs.size() == 3, "Wrong X.509 Certificate: TLV structure");
        BerTLV tlv = tlvs.recs.get(0);
        Ex.MUST(tlv.tag == 48, "Wrong X.509 Certificate: 'tbsCertificate' tag != 0x30");
        this.tbsCertificateFull = tlvs.recs.get(0).toBin();
        this.tbsCertificate = new BerTLVList(tlv.value);
        tlv = tlvs.recs.get(1);
        Ex.MUST(tlv.tag == 48, "Wrong X.509 Certificate: 'signatureAlgorithm' tag != 0x30");
        this.signatureAlgorithm = tlv.value;
        tlv = tlvs.recs.get(2);
        Ex.MUST(tlv.tag == 3, "Wrong X.509 Certificate: 'signatureValue' tag != 0x03");
        this.signatureValue = tlv.value.last(tlv.value.size() - 1);
        this.parseTbs();
        return this;
    }

    public boolean verifySignature(ECAlg signerPublicKey) {
        if (this.signatureAlgorithm.equals("06082A8648CE3D040302")) {
            return signerPublicKey.verifyECDSAStd(new SHA256().calc(this.tbsCertificateFull), this.signatureValue);
        }
        if (this.signatureAlgorithm.equals("06072A8648CE3D0401")) {
            return signerPublicKey.verifyECDSAStd(new SHA1().calc(this.tbsCertificateFull), this.signatureValue);
        }
        return false;
    }

    private static void printTime(StringBuilder sb, long epochSeconds) {
        sb.append(Instant.ofEpochSecond(epochSeconds).atZone(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
    }

    public String toString() {
        String s;
        StringBuilder sb = new StringBuilder(512);
        sb.append("signatureAlgorithm        : ");
        sb.append(this.signatureAlgorithm.Hex());
        sb.append('\n');
        sb.append("serialNumber              : ");
        sb.append(this.serialNumber.Hex());
        sb.append('\n');
        sb.append("validityNotBefore         : ");
        CertificateX509v3.printTime(sb, this.validityNotBefore);
        sb.append('\n');
        sb.append("validityNotAfter          : ");
        CertificateX509v3.printTime(sb, this.validityNotAfter);
        sb.append('\n');
        sb.append("subjectPublicKeyAlgorithm : ");
        sb.append(this.subjectPublicKeyAlgorithm.Hex());
        sb.append('\n');
        sb.append("subjectPublicKey          : ");
        sb.append(this.subjectPublicKey.Hex());
        sb.append('\n');
        sb.append("Issuer Name:\n");
        for (Map.Entry<Binary, BerTLV> entry : this.issuer.entrySet()) {
            sb.append("    OID : ");
            sb.append(entry.getKey().Hex());
            sb.append('\n');
            s = "";
            try {
                s = entry.getValue().value.asUTF8();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sb.append("        as Binary : ");
            sb.append(entry.getValue().toBin().Hex());
            sb.append('\n');
            if (s.isEmpty()) continue;
            sb.append("        as UTF-8  : ");
            sb.append(s);
            sb.append('\n');
        }
        sb.append("Subject Name:\n");
        for (Map.Entry<Binary, BerTLV> entry : this.subject.entrySet()) {
            sb.append("    OID : ");
            sb.append(entry.getKey().Hex());
            sb.append('\n');
            s = "";
            try {
                s = entry.getValue().value.asUTF8();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sb.append("        as Binary : ");
            sb.append(entry.getValue().toBin().Hex());
            sb.append('\n');
            if (s.isEmpty()) continue;
            sb.append("        as UTF-8  : ");
            sb.append(s);
            sb.append('\n');
        }
        sb.append("Extensions:\n");
        for (Map.Entry<Binary, Object> entry : this.extensions.entrySet()) {
            sb.append("    OID : ");
            sb.append(entry.getKey().Hex());
            sb.append('\n');
            sb.append("    TLV list :\n");
            sb.append(String.valueOf(((BerTLVList)entry.getValue()).toString(8)) + "\n");
        }
        return sb.toString();
    }
}

