/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import org.denom.Binary;
import org.denom.Ex;

public final class ASN1OID {
    private static void appendNum(Binary res, long num) {
        res.add((int)num & 0x7F);
        num >>>= 7;
        while (num != 0L) {
            res.add((int)num & 0x7F | 0x80);
            num >>>= 7;
        }
    }

    public static Binary toBin(String oidStr) {
        Binary res = new Binary().reserve(16);
        String[] nums = oidStr.split("\\.");
        Ex.MUST(nums.length >= 2, "Too short OID String");
        int i = nums.length - 1;
        while (i > 1) {
            long num = Long.parseLong(nums[i]);
            ASN1OID.appendNum(res, num);
            --i;
        }
        ASN1OID.appendNum(res, Integer.parseInt(nums[0]) * 40 + Integer.parseInt(nums[1]));
        return res.reverse();
    }

    public static String toStr(Binary oid) {
        Ex.MUST(oid.size() > 1, "Too short OID");
        StringBuilder s = new StringBuilder();
        long num = 0L;
        boolean first = true;
        int i = 0;
        while (i < oid.size()) {
            int b = oid.get(i);
            num += (long)(b & 0x7F);
            if (b > 127) {
                num <<= 7;
            } else {
                if (first) {
                    int n1 = 0;
                    while (n1 < 2 && num > 40L) {
                        ++n1;
                        num -= 40L;
                    }
                    s.append(n1);
                    first = false;
                }
                s.append('.');
                s.append(num);
                num = 0L;
            }
            ++i;
        }
        return s.toString();
    }
}

