/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLVList;

public class BerTLV {
    public int tag = 0;
    public final Binary value = new Binary();

    public BerTLV() {
    }

    public BerTLV(Binary bin) {
        this();
        this.assign(bin);
    }

    public BerTLV(String hexStr) {
        this();
        this.assign(hexStr);
    }

    public BerTLV clone() {
        BerTLV result = new BerTLV();
        result.tag = this.tag;
        result.value.assign(this.value);
        return result;
    }

    public boolean equals(Object other) {
        BerTLV b;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        BerTLV berTLV = b = other instanceof BerTLV ? (BerTLV)other : null;
        return b != null && this.tag == b.tag && this.value.equals(b.value);
    }

    public void clear() {
        this.tag = 0;
        this.value.clearMem();
    }

    public boolean isConstructed() {
        return BerTLV.isTagConstructed(this.tag);
    }

    public Binary toBin() {
        if (this.tag != 0) {
            return BerTLV.Tlv(this.tag, this.value);
        }
        return new Binary();
    }

    public String toString() {
        return this.toBin().Hex();
    }

    public void assign(Binary bin) {
        this.clear();
        Ex.MUST(BerTLV.isTLV(bin), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f BER-TLV \u0437\u0430\u043f\u0438\u0441\u044c");
        BerTLV.parseTLV(bin, new Int(0), this);
    }

    public void assign(String hexStr) {
        this.assign(new Binary(hexStr));
    }

    public boolean exists() {
        return this.tag != 0;
    }

    public BerTLV find(int tag, int nth) {
        if (!this.isConstructed()) {
            return new BerTLV();
        }
        return new BerTLVList(this.value).find(tag, nth);
    }

    public BerTLV find(int Tag) {
        return this.find(Tag, 1);
    }

    public BerTLV find(String path) {
        if (!this.isConstructed()) {
            return new BerTLV();
        }
        return new BerTLVList(this.value).find(path);
    }

    public static boolean parseTag(Binary bin, Int offset, Int tag_parsed) {
        int b3;
        int b2;
        int b1;
        int offs = offset.val;
        int size = bin.size();
        if (offs >= size) {
            return false;
        }
        if (((b1 = bin.get(offs++)) & 0x1F) != 31) {
            tag_parsed.val = b1;
            offset.val = offs;
            return tag_parsed.val != 0;
        }
        if (offs == size) {
            return false;
        }
        if ((b2 = bin.get(offs++)) == 0 || b2 == 128) {
            return false;
        }
        if (b2 < 128) {
            tag_parsed.val = b1 << 8 | b2;
            offset.val = offs;
            return true;
        }
        if (offs == size) {
            return false;
        }
        if ((b3 = bin.get(offs++)) > 127) {
            return false;
        }
        tag_parsed.val = b1 << 16 | b2 << 8 | b3;
        offset.val = offs;
        return true;
    }

    public static boolean parseLength(Binary bin, Int offset, Int len_parsed) {
        len_parsed.val = 0;
        if (offset.val >= bin.size()) {
            return false;
        }
        int b1 = bin.get(offset.val);
        if (b1 < 128) {
            len_parsed.val = b1;
            ++offset.val;
            return true;
        }
        if (b1 == 128 || b1 > 132) {
            return false;
        }
        int l = b1 & 0x7F;
        if (offset.val + 1 + l > bin.size()) {
            return false;
        }
        ++offset.val;
        while (l > 0) {
            len_parsed.val <<= 8;
            len_parsed.val |= bin.get(offset.val);
            ++offset.val;
            --l;
        }
        return len_parsed.val >= 0;
    }

    public static Arr<Integer> parseTagList(Binary tags) {
        Arr<Integer> arr = new Arr<Integer>();
        Int offset = new Int(0);
        while (offset.val < tags.size()) {
            Int Tag = new Int(0);
            Ex.MUST(BerTLV.parseTag(tags, offset, Tag), "Wrong Tag in Tag List");
            arr.add(Tag.val);
        }
        Ex.MUST(offset.val == tags.size(), "Wrong Tag List");
        return arr;
    }

    public static boolean parseTLV(Binary bin, Int offset, BerTLV rec) {
        Int offs = new Int(offset.val);
        Int tag_parsed = new Int(0);
        if (!BerTLV.parseTag(bin, offs, tag_parsed)) {
            return false;
        }
        Int len_parsed = new Int(0);
        if (!BerTLV.parseLength(bin, offs, len_parsed)) {
            return false;
        }
        if (offs.val + len_parsed.val > bin.size()) {
            return false;
        }
        rec.tag = tag_parsed.val;
        rec.value.assign(bin, offs.val, len_parsed.val);
        offset.val = offs.val + len_parsed.val;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTagConstructed(int tag) {
        if (tag != 0) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            tag >>>= 8;
lbl4:
            // 2 sources

            ** while ((tag & 65280) != 0)
        }
lbl5:
        // 1 sources

        return (tag & 32) != 0;
    }

    public static boolean isTLV(Binary bin) {
        Int offset = new Int(0);
        BerTLV rec = new BerTLV();
        if (!BerTLV.parseTLV(bin, offset, rec)) {
            return false;
        }
        if (offset.val != bin.size()) {
            return false;
        }
        if (rec.isConstructed()) {
            return BerTLV.isTLVList(rec.value);
        }
        return true;
    }

    public static boolean isTLVList(Binary bin) {
        Int offset = new Int(0);
        BerTLV rec = new BerTLV();
        while (offset.val < bin.size() && BerTLV.parseTLV(bin, offset, rec)) {
            if (!rec.isConstructed() || BerTLV.isTLVList(rec.value)) continue;
            return false;
        }
        return offset.val == bin.size();
    }

    public static void appendTlvTag(Binary bin, int tag) {
        if (tag >>> 8 != 0) {
            if (tag >>> 16 != 0) {
                if (tag >>> 24 != 0) {
                    bin.add(tag >>> 24);
                }
                bin.add(tag >>> 16);
            }
            bin.add(tag >>> 8);
        }
        bin.add(tag);
    }

    public static void appendTlvLen(Binary bin, int len) {
        if (len >= 128) {
            if (len >>> 8 != 0) {
                if (len >>> 16 != 0) {
                    if (len >>> 24 != 0) {
                        bin.add(132);
                        bin.add(len >>> 24);
                    } else {
                        bin.add(131);
                    }
                    bin.add(len >>> 16);
                } else {
                    bin.add(130);
                }
                bin.add(len >>> 8);
            } else {
                bin.add(129);
            }
        }
        bin.add(len & 0xFF);
    }

    public static Binary Tlv(int tag, Binary value) {
        Binary res = new Binary().reserve(4 + value.size());
        BerTLV.appendTlvTag(res, tag);
        BerTLV.appendTlvLen(res, value.size());
        res.add(value);
        return res;
    }

    public static Binary Tlv(int tag, Binary ... value) {
        Binary res = new Binary().reserve(50);
        Binary val = Binary.Bin(value);
        BerTLV.appendTlvTag(res, tag);
        BerTLV.appendTlvLen(res, val.size());
        res.add(val);
        return res;
    }

    public static Binary Tlv(int tag, String valHex) {
        return BerTLV.Tlv(tag, new Binary(valHex));
    }
}

