/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.util.ArrayList;
import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLV;
import org.denom.format.TagDictionary;

public class BerTLVList {
    public final ArrayList<BerTLV> recs = new ArrayList();

    public BerTLVList(Binary bin) {
        this.assign(bin);
    }

    public BerTLVList(String hexStr) {
        this(Binary.Bin(hexStr));
    }

    public BerTLVList assign(Binary bin) {
        Ex.MUST(BerTLV.isTLVList(bin), "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 BER-TLV-\u0437\u0430\u043f\u0438\u0441\u0438");
        this.recs.clear();
        Int offset = new Int(0);
        BerTLV rec = new BerTLV();
        while (offset.val < bin.size() && BerTLV.parseTLV(bin, offset, rec)) {
            this.recs.add(rec.clone());
        }
        return this;
    }

    public void assign(String hexStr) {
        this.assign(Binary.Bin(hexStr));
    }

    public BerTLV find(int Tag, int nth) {
        int k = 0;
        int i = 0;
        while (i < this.recs.size()) {
            if (this.recs.get((int)i).tag == Tag && ++k == nth) {
                return this.recs.get(i);
            }
            ++i;
        }
        return new BerTLV();
    }

    public BerTLV find(int Tag) {
        return this.find(Tag, 1);
    }

    public BerTLV find(String path) {
        String[] tags = path.replaceAll("\\s", "").split("/");
        if (tags.length == 0) {
            return new BerTLV();
        }
        BerTLV res = this.find((int)Binary.Bin(tags[0]).asU32(), 1);
        int i = 1;
        while (i < tags.length) {
            res = res.find((int)Binary.Bin(tags[i]).asU32(), 1);
            ++i;
        }
        return res;
    }

    public String toString(int offset, TagDictionary dictionary) {
        char[] offset_arr = new char[offset];
        Arrays.fill(offset_arr, ' ');
        StringBuilder res = new StringBuilder(300);
        int i = 0;
        while (i < this.recs.size()) {
            String desc;
            BerTLV rec = this.recs.get(i);
            res.append(offset_arr);
            String tag = Integer.toHexString(rec.tag).toUpperCase();
            res.append(tag.length() % 2 == 0 ? tag : "0" + tag);
            if (!rec.isConstructed() && rec.value.size() > 8) {
                res.append(" [" + rec.value.size() + "]");
            }
            if (dictionary != null && !(desc = dictionary.getDescription(rec.tag)).isEmpty()) {
                res.append(" -- " + desc);
            }
            res.append(":\n");
            if (rec.isConstructed()) {
                res.append(new BerTLVList(rec.value).toString(offset + 4, dictionary));
            } else {
                StringBuilder str = new StringBuilder(200);
                str.append(offset_arr);
                str.append("    ");
                str.append(rec.value.Hex(1, 8, 32, 0));
                int k = 0;
                while (k < str.length()) {
                    if (str.charAt(k) == '\n') {
                        str.insert(++k, offset_arr);
                        str.insert(k, "    ");
                    }
                    ++k;
                }
                res.append((CharSequence)str);
                res.append('\n');
            }
            ++i;
        }
        return res.toString();
    }

    public String toString(int offset) {
        return this.toString(offset, null);
    }

    public String toString() {
        return this.toString(0);
    }

    public Binary toBin() {
        Binary bin = new Binary();
        int i = 0;
        while (i < this.recs.size()) {
            bin.add(this.recs.get(i).toBin());
            ++i;
        }
        return bin;
    }
}

