/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.util.Collection;
import org.denom.Binary;
import org.denom.Strings;
import org.denom.format.IBinable;

public class BinBuilder {
    private Binary result;

    public BinBuilder(Binary bin) {
        this.result = bin;
    }

    public BinBuilder() {
        this(new Binary());
    }

    public Binary getResult() {
        return this.result;
    }

    public BinBuilder append(boolean flag) {
        this.result.add(flag ? 1 : 0);
        return this;
    }

    public BinBuilder append(int i) {
        this.result.addInt(i);
        return this;
    }

    public BinBuilder append(long l) {
        this.result.addLong(l);
        return this;
    }

    public BinBuilder append(Binary b) {
        this.result.addInt(b.size());
        this.result.add(b);
        return this;
    }

    public BinBuilder append(Binary b, int offset, int length) {
        this.result.addInt(length);
        this.result.add(b, offset, length);
        return this;
    }

    public BinBuilder append(Binary[] arr) {
        this.result.addInt(arr.length);
        Binary[] binaryArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Binary b = binaryArray[n2];
            this.append(b);
            ++n2;
        }
        return this;
    }

    public BinBuilder appendBinaryCollection(Collection<Binary> collection) {
        this.result.addInt(collection.size());
        for (Binary b : collection) {
            this.append(b);
        }
        return this;
    }

    public BinBuilder append(byte[] arr) {
        this.result.addInt(arr.length);
        this.result.add(arr);
        return this;
    }

    public BinBuilder append(String s) {
        byte[] arr = s.getBytes(Strings.UTF8);
        this.result.addInt(arr.length);
        this.result.add(arr);
        return this;
    }

    public BinBuilder appendStringCollection(Collection<String> collection) {
        this.result.addInt(collection.size());
        for (String str : collection) {
            this.append(str);
        }
        return this;
    }

    public BinBuilder append(IBinable binable) {
        return this.append(binable.toBin());
    }

    public BinBuilder append(IBinable[] binableArray) {
        this.result.addInt(binableArray.length);
        IBinable[] iBinableArray = binableArray;
        int n = binableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinable b = iBinableArray[n2];
            this.append(b);
            ++n2;
        }
        return this;
    }

    public BinBuilder append(Collection<? extends IBinable> collection) {
        this.result.addInt(collection.size());
        for (IBinable iBinable : collection) {
            this.append(iBinable.toBin());
        }
        return this;
    }
}

