/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.format.IBinable;

public class BinParser {
    private Binary bin;
    private int offset;

    public BinParser(Binary bin, int offset) {
        this.bin = bin;
        this.offset = offset;
    }

    public BinParser(Binary bin) {
        this(bin, 0);
    }

    public int getOffset() {
        return this.offset;
    }

    public void reset(Binary bin, int offset) {
        this.bin = bin;
        this.offset = offset;
    }

    public boolean getBoolean() {
        boolean res = this.bin.get(this.offset) != 0;
        ++this.offset;
        return res;
    }

    public int getInt() {
        int res = this.bin.getIntBE(this.offset);
        this.offset += 4;
        return res;
    }

    public long getLong() {
        long res = this.bin.getLongBE(this.offset);
        this.offset += 8;
        return res;
    }

    public byte[] getByteArr() {
        int size = this.bin.getIntBE(this.offset);
        this.offset += 4;
        byte[] res = Arrays.copyOfRange(this.bin.getDataRef(), this.offset, this.offset + size);
        this.offset += size;
        return res;
    }

    public String getString() {
        int size = this.bin.getIntBE(this.offset);
        this.offset += 4;
        String res = new String(this.bin.getDataRef(), this.offset, size, Strings.UTF8);
        this.offset += size;
        return res;
    }

    public String[] getStringArr() {
        int arrLen = this.bin.getIntBE(this.offset);
        this.offset += 4;
        String[] arr = new String[arrLen];
        int i = 0;
        while (i < arrLen) {
            arr[i] = this.getString();
            ++i;
        }
        return arr;
    }

    public Collection<String> getStringCollection(Collection<String> collection) {
        int arrLen = this.bin.getIntBE(this.offset);
        this.offset += 4;
        int i = 0;
        while (i < arrLen) {
            collection.add(this.getString());
            ++i;
        }
        return collection;
    }

    public Binary getBinary() {
        int size = this.bin.getIntBE(this.offset);
        Ex.MUST(size >= 0, "Negative len while parsing Binable object");
        this.offset += 4;
        Binary res = this.bin.slice(this.offset, size);
        this.offset += size;
        return res;
    }

    public Binary getBinary(int maxLen) {
        int size = this.bin.getIntBE(this.offset);
        Ex.MUST(size >= 0, "Negative len while parsing Binable object");
        Ex.MUST(size <= maxLen, "Binable: Incorrect Binary length");
        this.offset += 4;
        Binary res = this.bin.slice(this.offset, size);
        this.offset += size;
        return res;
    }

    public Binary[] getBinaryArr() {
        int arrLen = this.bin.getIntBE(this.offset);
        this.offset += 4;
        Binary[] arr = new Binary[arrLen];
        int i = 0;
        while (i < arrLen) {
            arr[i] = this.getBinary();
            ++i;
        }
        return arr;
    }

    public Collection<Binary> getBinaryCollection(Collection<Binary> collection) {
        int arrLen = this.bin.getIntBE(this.offset);
        this.offset += 4;
        int i = 0;
        while (i < arrLen) {
            collection.add(this.getBinary());
            ++i;
        }
        return collection;
    }

    public IBinable getBinable(Class<? extends IBinable> clazz) {
        IBinable instance = null;
        try {
            int size = this.bin.getIntBE(this.offset);
            this.offset += 4;
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.fromBin(this.bin, this.offset);
            this.offset += size;
        }
        catch (Exception ex) {
            Ex.THROW(ex.toString());
        }
        return instance;
    }

    public IBinable[] getBinableArr(Class<? extends IBinable[]> clazz) {
        IBinable[] arr = null;
        Class<?> componentType = clazz.getComponentType();
        try {
            int arrLen = this.bin.getIntBE(this.offset);
            this.offset += 4;
            arr = (IBinable[])Array.newInstance(componentType, arrLen);
            int i = 0;
            while (i < arr.length) {
                arr[i] = this.getBinable(componentType);
                ++i;
            }
        }
        catch (Exception ex) {
            Ex.THROW(ex.toString());
        }
        return arr;
    }

    public Collection<? extends IBinable> getBinableCollection(Collection<? extends IBinable> collection, Class<? extends IBinable> elemType) {
        int arrLen = this.bin.getIntBE(this.offset);
        this.offset += 4;
        int i = 0;
        while (i < arrLen) {
            collection.add(this.getBinable(elemType));
            ++i;
        }
        return collection;
    }
}

