/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.denom.Ex;

public class Jo {
    public Map<String, Object> map = new LinkedHashMap<String, Object>();
    public Map<String, String> comments;
    private static final char KEYVAL_DELIMITER = '=';
    private static final char ELEMS_DELIMITER = ';';

    public int length() {
        return this.map.size();
    }

    public Jo put(String key, double val) {
        this.put(key, (Object)val);
        return this;
    }

    public Jo put(String key, Object val) {
        this.map.put(key, val);
        return this;
    }

    static void appendIndent(Appendable writer, int indent) throws IOException {
        while (indent > 0) {
            writer.append(' ');
            --indent;
        }
    }

    public void writeCompact(Appendable writer) {
        try {
            writer.append('{');
            Iterator<Map.Entry<String, Object>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                writer.append(entry.getKey());
                writer.append('=');
                Object val = entry.getValue();
                if (val == null) {
                    if (!it.hasNext()) continue;
                    writer.append(';');
                    continue;
                }
                if (val instanceof Jo) {
                    ((Jo)val).writeCompact(writer);
                    continue;
                }
                writer.append(val.toString());
                if (!it.hasNext()) continue;
                writer.append(';');
            }
            writer.append('}');
        }
        catch (IOException exception) {
            throw new Ex(exception);
        }
    }

    public void write(Appendable writer, int indentFactor, int indent) {
        Ex.MUST(indentFactor >= 0 && indent >= 0, "Wrong indent params");
        try {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                Object val = entry.getValue();
                Jo.appendIndent(writer, indent);
                writer.append(entry.getKey());
                writer.append(' ');
                writer.append('=');
                writer.append(' ');
                if (val == null) {
                    writer.append(';');
                } else if (val instanceof Jo) {
                    if (((Jo)val).map.size() != 0) {
                        writer.append('\n');
                        Jo.appendIndent(writer, indent);
                        writer.append('{');
                        writer.append('\n');
                        ((Jo)val).write(writer, indentFactor, indent + indentFactor);
                        Jo.appendIndent(writer, indent);
                    } else {
                        writer.append('{');
                    }
                    writer.append('}');
                } else {
                    writer.append(val.toString());
                }
                writer.append('\n');
            }
        }
        catch (IOException exception) {
            throw new Ex(exception);
        }
    }

    public void save(String filename, int indentFactor, int indent) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter fw = Files.newBufferedWriter(Paths.get(filename, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                this.write(fw, indentFactor, indent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Ex(ex);
        }
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int indentFactor) {
        StringBuilder sb = new StringBuilder(64);
        this.write(sb, indentFactor, 0);
        return sb.toString();
    }
}

