/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.util.ArrayList;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;

public final class LV {
    public static Binary LV1(Binary ... values) {
        Binary res = new Binary().reserve(200);
        Binary[] binaryArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Binary value = binaryArray[n2];
            Ex.MUST(Int.isU8(value.size()), "Too long Value for LV1");
            res.add(value.size());
            res.add(value);
            ++n2;
        }
        return res;
    }

    public static Binary LV2(Binary ... values) {
        Binary res = new Binary().reserve(200);
        Binary[] binaryArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Binary value = binaryArray[n2];
            Ex.MUST(Int.isU16(value.size()), "Too long Value for LV2");
            res.addU16(value.size());
            res.add(value);
            ++n2;
        }
        return res;
    }

    public static Binary LV4(Binary ... values) {
        Binary res = new Binary().reserve(200);
        Binary[] binaryArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Binary value = binaryArray[n2];
            res.addInt(value.size());
            res.add(value);
            ++n2;
        }
        return res;
    }

    public static Binary LV1(Binary value) {
        Ex.MUST(Int.isU8(value.size()), "Too long Value for LV1");
        Binary res = new Binary().reserve(value.size() + 1);
        res.add(value.size());
        res.add(value);
        return res;
    }

    public static Binary LV2(Binary value) {
        Ex.MUST(Int.isU16(value.size()), "Too long Value for LV2");
        Binary res = new Binary().reserve(value.size() + 2);
        res.addU16(value.size());
        res.add(value);
        return res;
    }

    public static Binary LV3(Binary value) {
        Ex.MUST(Int.isU24(value.size()), "Too long Value for LV3");
        Binary res = new Binary().reserve(value.size() + 3);
        res.addU24(value.size());
        res.add(value);
        return res;
    }

    public static Binary LV4(Binary value) {
        Ex.MUST(Int.isU24(value.size()), "Too long Value for LV4");
        Binary res = new Binary().reserve(value.size() + 4);
        res.addInt(value.size());
        res.add(value);
        return res;
    }

    public static Binary LV4Strings(String ... strings) {
        Binary res = new Binary().reserve(200);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Binary value = Binary.Bin().fromUTF8(s);
            res.addInt(value.size());
            res.add(value);
            ++n2;
        }
        return res;
    }

    private static Binary[] parseLV(int lengthSize, Binary bin) {
        ArrayList<Binary> list = new ArrayList<Binary>();
        int size = bin.size();
        int offset = 0;
        while (offset < size) {
            Ex.MUST(offset + lengthSize <= size, "Incorrect LV2 List");
            int len = (int)bin.slice(offset, lengthSize).asU32();
            Ex.MUST(len >= 0 && (offset += lengthSize) + len <= size, "Incorrect LV2 List");
            list.add(new Binary(bin.getDataRef(), offset, len));
            offset += len;
        }
        return list.toArray(new Binary[list.size()]);
    }

    public static Binary[] parseLV1(Binary bin) {
        return LV.parseLV(1, bin);
    }

    public static Binary[] parseLV2(Binary bin) {
        return LV.parseLV(2, bin);
    }

    public static Binary[] parseLV4(Binary bin) {
        return LV.parseLV(4, bin);
    }

    public static String[] parseLV4Strings(Binary data) {
        Binary[] bins = LV.parseLV4(data);
        String[] strings = new String[bins.length];
        int i = 0;
        Binary[] binaryArray = bins;
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            Binary b = binaryArray[n2];
            strings[i++] = b.asUTF8();
            ++n2;
        }
        return strings;
    }
}

