/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.JSONObject;

public class TagDictionary {
    private static final String TAG_PREFIX = "TagDesc ";
    private static final String KEY_AID_LIST = "AID List";
    private final Map<Long, String> descriptions = new HashMap<Long, String>();
    private final List<Binary> aids = new ArrayList<Binary>();

    public void load(String fileName) {
        Ex.MUST(!fileName.isEmpty(), "The path can't be empty");
        this.load(new JSONObject().loadWithComments(fileName));
    }

    public void load(InputStream is) {
        this.load(new JSONObject().loadWithComments(is));
    }

    public void load(JSONObject jo) {
        this.aids.clear();
        this.descriptions.clear();
        for (String key : jo.keySet()) {
            String[] aidList;
            if (key.startsWith(TAG_PREFIX)) {
                String tag = key.substring(TAG_PREFIX.length());
                this.descriptions.put(Binary.Bin(tag).asU32(), jo.getString(key));
            }
            if (!key.equals(KEY_AID_LIST)) continue;
            String[] stringArray = aidList = jo.getString(key).split(",");
            int n = aidList.length;
            int n2 = 0;
            while (n2 < n) {
                String aid = stringArray[n2];
                if (!aid.isEmpty()) {
                    this.aids.add(Binary.Bin(aid));
                }
                ++n2;
            }
        }
    }

    public String getDescription(long tag) {
        String val = this.descriptions.get(tag);
        return val != null ? val : "";
    }

    public boolean isDictionaryForAID(Binary aid) {
        if (this.aids.isEmpty()) {
            return true;
        }
        return this.aids.contains(aid);
    }
}

