/*
 * Decompiled with CFR 0.152.
 */
package org.denom.log;

import java.io.FileWriter;
import java.io.IOException;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;

public class LogFile
implements ILog {
    private FileWriter f;
    private ILog mNextLog;

    public LogFile(String fileName, boolean append) {
        try {
            this.f = new FileWriter(fileName, append);
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    private void writeImpl(String text) {
        try {
            this.f.write(text);
            this.f.flush();
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    @Override
    public void write(String text) {
        this.writeImpl(text);
        if (this.mNextLog != null) {
            this.mNextLog.write(text);
        }
    }

    @Override
    public void write(int color, String text) {
        this.writeImpl(text);
        if (this.mNextLog != null) {
            this.mNextLog.write(color, text);
        }
    }

    @Override
    public void writeln(String text) {
        this.write(String.valueOf(text) + Strings.ln);
    }

    @Override
    public void writeln(int color, String text) {
        this.write(color, String.valueOf(text) + Strings.ln);
    }

    @Override
    public void setDefaultColor(int color) {
    }

    @Override
    public ILog setNext(ILog log) {
        this.mNextLog = log;
        return this;
    }

    @Override
    public void close() {
        try {
            this.f.flush();
            this.f.close();
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }
}

