/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import org.denom.Binary;
import org.denom.Ex;

public class SocketClient
implements AutoCloseable {
    private SocketChannel socketChannel;
    private Socket socket;
    private ReadableByteChannel wrappedChannel;
    private int connectTimeoutMs;

    public SocketClient() {
        this(10);
    }

    public SocketClient(int connectTimeoutSec) {
        Ex.MUST(connectTimeoutSec > 0, "Can't set 'connectTimeout' <= 0");
        this.connectTimeoutMs = connectTimeoutSec * 1000;
        this.createNewChannel();
    }

    public SocketClient(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        this.socket = socketChannel.socket();
        if (socketChannel.isConnected()) {
            this.initWrappedChannel();
        }
    }

    private void createNewChannel() {
        try {
            this.socketChannel = SocketChannel.open();
            this.socket = this.socketChannel.socket();
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    private void initWrappedChannel() {
        try {
            this.wrappedChannel = Channels.newChannel(this.socket.getInputStream());
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    public void connect(String host, int port) {
        this.connect(new InetSocketAddress(host.isEmpty() ? "0.0.0.0" : host, port));
    }

    public void connect(InetSocketAddress addr) {
        try {
            this.socket.connect(addr, this.connectTimeoutMs);
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
        this.initWrappedChannel();
    }

    public void connectHard(String host, int port) {
        host = host.isEmpty() ? "0.0.0.0" : host;
        InetSocketAddress destAddr = new InetSocketAddress(host, port);
        int curTimeout = this.connectTimeoutMs;
        while (!this.socket.isConnected() && curTimeout >= 0) {
            long t0 = System.currentTimeMillis();
            try {
                this.socket.connect(destAddr, curTimeout);
            }
            catch (Throwable ex) {
                if ((curTimeout -= (int)(System.currentTimeMillis() - t0)) < 0) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignored) {
                    Ex.THROW("InterruptedException");
                }
                curTimeout -= 200;
                this.close();
                this.createNewChannel();
            }
        }
        Ex.MUST(this.socketChannel.isConnected(), "Can't connect to " + host + ":" + port);
        this.initWrappedChannel();
    }

    @Override
    public void close() {
        try {
            this.socketChannel.close();
            if (this.wrappedChannel != null) {
                this.wrappedChannel.close();
            }
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void read(Binary buf, int needLen) {
        Ex.MUST(needLen >= 0, "Negative needLen argument");
        if (needLen == 0) {
            return;
        }
        int oldSize = buf.size();
        buf.resize(needLen + oldSize);
        ByteBuffer bb = ByteBuffer.wrap(buf.getDataRef(), oldSize, needLen);
        try {
            while (bb.hasRemaining()) {
                int size = this.wrappedChannel.read(bb);
                if (size > 0) continue;
                this.close();
                Ex.THROW("Connection closed");
            }
        }
        catch (Throwable ex) {
            this.close();
            Ex.THROW(ex);
        }
    }

    public void readSome(Binary buf, int maxLen) {
        Ex.MUST(maxLen >= 0, "Negative maxLen argument");
        if (maxLen == 0) {
            return;
        }
        int oldSize = buf.size();
        buf.resize(maxLen + oldSize);
        ByteBuffer bb = ByteBuffer.wrap(buf.getDataRef(), oldSize, maxLen);
        try {
            int size = this.socketChannel.read(bb);
            if (size <= 0) {
                this.close();
                Ex.THROW("Connection closed");
            }
            buf.resize(oldSize + size);
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
        }
    }

    public void write(Binary data) {
        ByteBuffer byteBuf = ByteBuffer.wrap(data.getDataRef(), 0, data.size());
        try {
            while (byteBuf.hasRemaining()) {
                this.socketChannel.write(byteBuf);
            }
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
        }
    }
}

