/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.denom.Ex;
import org.denom.Sys;
import org.denom.ThreadFactoryNamed;
import org.denom.log.ILog;
import org.denom.net.TCPServerSession;

public class TCPServer {
    private final ILog log;
    private final ServerSocketChannel serverSocket;
    private Selector selector;
    private final ExecutorService ioExecutor;
    private final TCPServerSession sessionConstructor;
    private final Queue<TCPServerSession> flushingSessions = new ConcurrentLinkedQueue<TCPServerSession>();
    private AtomicBoolean wakeupCalled = new AtomicBoolean(false);

    public TCPServer(ILog log, String host, int port, TCPServerSession sessionConstructor) {
        this.log = log;
        this.sessionConstructor = sessionConstructor;
        this.ioExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryNamed(this.getClass().getSimpleName(), 8, 0, false));
        try {
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.configureBlocking(false);
            InetSocketAddress localAddr = host.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            this.serverSocket.bind(localAddr, 300);
            this.selector = Selector.open();
            this.serverSocket.register(this.selector, 16);
            this.ioExecutor.execute(() -> this.ioLoop());
        }
        catch (IOException ex) {
            throw new Ex("Can't open server socket" + ex.toString());
        }
    }

    private void recreateSelector() throws IOException {
        Set<SelectionKey> keys = this.selector.keys();
        Selector newSelector = Selector.open();
        for (SelectionKey key : keys) {
            SelectionKey newKey;
            SelectableChannel ch = key.channel();
            if (ch instanceof ServerSocketChannel) {
                ch.register(newSelector, key.interestOps(), key.attachment());
                continue;
            }
            TCPServerSession session = (TCPServerSession)key.attachment();
            session.selectionKey = newKey = ch.register(newSelector, key.interestOps(), session);
        }
        this.selector.close();
        this.selector = newSelector;
    }

    void needToFlush(TCPServerSession session) {
        this.flushingSessions.offer(session);
        this.wakeup();
    }

    private void flush(TCPServerSession session) {
        try {
            SelectionKey key = session.selectionKey;
            while (!session.writeQueue.isEmpty()) {
                ByteBuffer buf = session.writeQueue.peek();
                session.socket.write(buf);
                if (buf.remaining() != 0) {
                    key.interestOps(key.interestOps() | 4);
                    return;
                }
                session.writeQueue.remove();
                session.onWritten(buf);
            }
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
        catch (Exception ex) {
            session.close();
        }
    }

    private void acceptClient(SocketChannel clientSocket) {
        try {
            clientSocket.configureBlocking(false);
            clientSocket.socket().setTcpNoDelay(true);
            TCPServerSession newSession = this.sessionConstructor.newInstance(this, clientSocket);
            Ex.MUST(newSession != null);
            SelectionKey clientKey = clientSocket.register(this.selector, 1);
            clientKey.attach(newSession);
            newSession.selectionKey = clientKey;
        }
        catch (Throwable ex) {
            try {
                clientSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void wakeup() {
        this.wakeupCalled.getAndSet(true);
        this.selector.wakeup();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ioLoop() {
        try {
            try {
                Thread.currentThread().setPriority(8);
                tries = 5;
                if (true) ** GOTO lbl48
                do {
                    t0 = System.currentTimeMillis();
                    selected = this.selector.select(1000L);
                    t1 = System.currentTimeMillis();
                    delta = t1 - t0;
                    if (!this.wakeupCalled.getAndSet(false) && selected == 0 && delta < 100L) {
                        if (tries == 0) {
                            this.recreateSelector();
                            tries = 5;
                        } else {
                            --tries;
                        }
                    } else {
                        tries = 5;
                        if (selected > 0) {
                            iterator = this.selector.selectedKeys().iterator();
                            while (iterator.hasNext()) {
                                key = iterator.next();
                                iterator.remove();
                                try {
                                    if (key.isAcceptable()) {
                                        serverChannel = (ServerSocketChannel)key.channel();
                                        this.acceptClient(serverChannel.accept());
                                    }
                                    if (key.isWritable()) {
                                        this.flush((TCPServerSession)key.attachment());
                                    }
                                    if (!key.isReadable()) continue;
                                    ((TCPServerSession)key.attachment()).readFromSocket();
                                }
                                catch (IOException ex) {
                                    try {
                                        key.cancel();
                                    }
                                    catch (Throwable var12_13) {
                                        // empty catch block
                                    }
                                    try {
                                        key.channel().close();
                                    }
                                    catch (Throwable var12_14) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        while (!this.flushingSessions.isEmpty()) {
                            this.flush(this.flushingSessions.poll());
                        }
                    }
lbl48:
                    // 4 sources

                    if (!this.serverSocket.isOpen()) return;
                } while (!Thread.currentThread().isInterrupted());
                return;
            }
            catch (ClosedByInterruptException ex) {
                try {
                    this.selector.close();
                    this.serverSocket.close();
                    return;
                }
                catch (Throwable var14_15) {
                    // empty catch block
                }
                return;
            }
            catch (Throwable ex) {
                this.log.writeln(-65536, ex.toString());
                try {
                    this.selector.close();
                    this.serverSocket.close();
                    return;
                }
                catch (Throwable var14_16) {}
                return;
            }
        }
        finally {
            try {
                this.selector.close();
                this.serverSocket.close();
            }
            catch (Throwable var14_18) {}
        }
    }

    public void close() {
        Sys.shutdownNow(this.ioExecutor, 3);
    }
}

