/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

import org.denom.Binary;
import org.denom.log.ILog;
import org.denom.scp81.TlsHelloClient;
import org.denom.scp81.TlsHelloServer;
import org.denom.scp81.TlsPSKClientSession;
import org.denom.scp81.TlsPSKServerSession;
import org.denom.scp81.http.HttpReqParser;
import org.denom.scp81.http.HttpRespParser;

public class SCP81LogParser {
    public Binary psk;
    public ILog log;
    MyServerSession serverSession;
    MyClientSession clientSession;

    public SCP81LogParser(Binary psk, ILog log) {
        this.psk = psk;
        this.log = log;
        this.serverSession = new MyServerSession();
        this.serverSession.setLog(log);
        this.serverSession.psk = psk;
        HttpReqParser httpReqParser = new HttpReqParser().setOnHttpReq(req -> {}).setLog(log);
        this.serverSession.setRecievedAppData(httpReqParser::append);
        this.clientSession = new MyClientSession();
        this.clientSession.setLog(log);
        this.clientSession.psk = psk;
        HttpRespParser httpRespParser = new HttpRespParser().setOnHttpResp(resp -> {}).setLog(log);
        this.clientSession.setRecievedAppData(httpRespParser::append);
    }

    public void fromClient(Binary dataFromClient) {
        this.serverSession.appendIncomingData(dataFromClient);
    }

    public void fromClient(String dataFromClientHex) {
        this.fromClient(Binary.Bin(dataFromClientHex));
    }

    public void fromServer(Binary dataFromServer) {
        this.clientSession.appendIncomingData(dataFromServer);
    }

    public void fromServer(String dataFromServerHex) {
        this.fromServer(Binary.Bin(dataFromServerHex));
    }

    private class MyClientSession
    extends TlsPSKClientSession {
        public MyClientSession() {
            super(0, Binary.Bin(), Binary.Bin());
        }

        @Override
        protected void onServerHello(Binary message, Binary data) {
            TlsHelloServer serverHello = new TlsHelloServer(data);
            this.log.write(this.colorRecv3, serverHello.toString());
            SCP81LogParser.this.serverSession.gotServerHello(serverHello);
            this.gotServerHello(serverHello);
        }

        @Override
        protected void onServerKeyExchange(Binary message, Binary data) {
            Binary pskIdentityHint = data.slice(2, data.getU16(0));
            String str = "";
            try {
                str = pskIdentityHint.asUTF8();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.log.writeln(this.colorRecv3, "       IDENTITY HINT:  " + pskIdentityHint.Hex() + ",    as String:  " + str);
        }

        @Override
        protected void onServerHelloDone(Binary message, Binary data) {
            this.log.writeln(this.colorRecv3, "       SERVER HELLO DONE");
            this.state = 10;
        }

        @Override
        protected void onServerFinished(Binary data) {
            this.log.writeln(this.colorRecv3, "        Server Verify data: " + data.Hex());
            SCP81LogParser.this.clientSession.handshakeDone = true;
        }
    }

    private class MyServerSession
    extends TlsPSKServerSession {
        private MyServerSession() {
        }

        @Override
        protected void onClientHello(Binary message, Binary data) {
            TlsHelloClient clientHello = new TlsHelloClient(data);
            this.log.write(this.colorRecv3, clientHello.toString());
            this.gotClientHello(clientHello);
            SCP81LogParser.this.clientSession.gotClientHello(clientHello);
        }

        @Override
        protected void onClientKeyExchange(Binary message, Binary data) {
            this.identity = data.slice(2, data.getU16(0));
            this.log.writeln(this.colorRecv3, "        Client Identity: " + this.identity.Hex() + ", as String:  " + this.identity.asUTF8());
            this.state = 10;
        }

        @Override
        protected void onClientFinished(Binary message, Binary data) {
            this.log.writeln(this.colorRecv3, "        Client Verify data: " + data.Hex());
            this.handshakeDone = true;
        }
    }
}

