/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

public abstract class TlsConst {

    public static class Alert {
        public static final int CLOSE_NOTIFY = 0;
        public static final int UNEXPECTED_MESSAGE = 10;
        public static final int BAD_RECORD_MAC = 20;
        public static final int RECORD_OVERFLOW = 22;
        public static final int HANDSHAKE_FAILURE = 40;
        public static final int ILLEGAL_PARAMETER = 47;
        public static final int DECODE_ERROR = 50;
        public static final int DECRYPT_ERROR = 51;
        public static final int PROTOCOL_VERSION = 70;
        public static final int INTERNAL_ERROR = 80;
        public static final int UNSUPPORTED_EXTENSION = 110;

        public static String toStr(int alert) {
            switch (alert) {
                case 0: {
                    return "close_notify";
                }
                case 10: {
                    return "unexpected_message";
                }
                case 20: {
                    return "bad_record_mac";
                }
                case 22: {
                    return "record_overflow";
                }
                case 40: {
                    return "handshake_failure";
                }
                case 47: {
                    return "illegal_parameter";
                }
                case 50: {
                    return "decode_error";
                }
                case 51: {
                    return "decrypt_error";
                }
                case 70: {
                    return "protocol_version";
                }
                case 80: {
                    return "internal_error";
                }
                case 110: {
                    return "unsupported_extension";
                }
            }
            return "";
        }
    }

    public static class CipherSuite {
        public static final int PSK_NULL_SHA = 44;
        public static final int PSK_3DES_EDE_CBC_SHA = 139;
        public static final int PSK_AES_128_CBC_SHA = 140;
        public static final int PSK_AES_128_CBC_SHA256 = 174;
        public static final int PSK_NULL_SHA256 = 176;

        public static String toStr(int cipherSuite) {
            switch (cipherSuite) {
                case 44: {
                    return "PSK_WITH_NULL_SHA";
                }
                case 139: {
                    return "PSK_WITH_3DES_EDE_CBC_SHA";
                }
                case 140: {
                    return "PSK_WITH_AES_128_CBC_SHA";
                }
                case 174: {
                    return "PSK_WITH_AES_128_CBC_SHA256";
                }
                case 176: {
                    return "PSK_WITH_NULL_SHA256";
                }
            }
            return "";
        }
    }

    public static class ContentType {
        public static final short CHANGE_CIPHER = 20;
        public static final short ALERT = 21;
        public static final short HANDSHAKE = 22;
        public static final short APPLICATION_DATA = 23;
    }

    public static class Extension {
        public static final int MAX_FRAGMENT_LENGTH = 1;
        public static final int TRUNCATED_HMAC = 4;
        public static final int ENCRYPT_THEN_MAC = 22;

        public static String toStr(int extensionType) {
            switch (extensionType) {
                case 1: {
                    return "max_fragment_length";
                }
                case 4: {
                    return "truncated_hmac";
                }
                case 22: {
                    return "encrypt_then_mac";
                }
            }
            return "";
        }
    }

    public static class HandshakeType {
        public static final int CLIENT_HELLO = 1;
        public static final int SERVER_HELLO = 2;
        public static final int SERVER_KEY_EXCHANGE = 12;
        public static final int SERVER_HELLO_DONE = 14;
        public static final int CLIENT_KEY_EXCHANGE = 16;
        public static final int FINISHED = 20;

        public static String toStr(int type) {
            switch (type) {
                case 1: {
                    return "client_hello";
                }
                case 2: {
                    return "server_hello";
                }
                case 12: {
                    return "server_key_exchange";
                }
                case 14: {
                    return "server_hello_done";
                }
                case 16: {
                    return "client_key_exchange";
                }
                case 20: {
                    return "finished";
                }
            }
            return "";
        }
    }

    public static class Protocol {
        public static final int TLSv1_0 = 769;
        public static final int TLSv1_1 = 770;
        public static final int TLSv1_2 = 771;

        public static String toStr(int protocol) {
            switch (protocol) {
                case 769: {
                    return "TLS 1.0";
                }
                case 770: {
                    return "TLS 1.1";
                }
                case 771: {
                    return "TLS 1.2";
                }
            }
            return "";
        }
    }
}

