/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

import java.util.Map;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.scp81.TlsConst;
import org.denom.scp81.TlsHelloClient;

public class TlsHelloServer {
    public final int protocol;
    public final Binary random;
    public final Binary sessionID;
    public final int cipherSuite;
    public final int compressionMethod;
    public final Map<Integer, Binary> extensions;

    public TlsHelloServer(int version, Binary random, Binary sessionID, int cipherSuite, Map<Integer, Binary> extensions) {
        Ex.MUST(random != null && sessionID != null && extensions != null, "Wrong ClientHello params");
        this.protocol = version;
        this.random = random;
        this.sessionID = sessionID;
        this.cipherSuite = cipherSuite;
        this.compressionMethod = 0;
        this.extensions = extensions;
    }

    public TlsHelloServer(Binary message) {
        this.protocol = message.getU16(0);
        this.random = message.slice(2, 32);
        int offset = 34;
        int len = message.get(offset);
        this.sessionID = message.slice(++offset, len);
        this.cipherSuite = message.getU16(offset += len);
        this.compressionMethod = message.get(offset += 2);
        Ex.MUST(this.compressionMethod == 0, 47);
        this.extensions = TlsHelloClient.parseExtensions(message, ++offset);
    }

    public Binary toBin() {
        Binary b = new Binary().reserve(64);
        b.addU16(this.protocol);
        b.add(this.random);
        b.add(this.sessionID.size());
        b.add(this.sessionID);
        b.addU16(this.cipherSuite);
        b.add(this.compressionMethod);
        TlsHelloClient.addExtensions(b, this.extensions);
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("          SERVER HELLO:\n");
        sb.append(String.format("               version:  %04X (%s)\n", this.protocol, TlsConst.Protocol.toStr(this.protocol)));
        sb.append("                random:  " + this.random.Hex() + "\n");
        sb.append("             sessionId:  " + this.sessionID.Hex() + "\n");
        sb.append(String.format("           cipherSuite:  %04X (%s)\n", this.cipherSuite, TlsConst.CipherSuite.toStr(this.cipherSuite)));
        sb.append("            extensions:\n");
        for (Map.Entry<Integer, Binary> entry : this.extensions.entrySet()) {
            sb.append(String.format("                         type:  %04X (%s),  data:  %s\n", entry.getKey(), TlsConst.Extension.toStr(entry.getKey()), entry.getValue().Hex()));
        }
        return sb.toString();
    }
}

