/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.denom.Binary;
import org.denom.Ex;

public class HttpResp {
    public static final int COLOR = -14614592;
    public String statusLine;
    public HashMap<String, String> headers = new HashMap();
    public Binary body = new Binary();

    public HttpResp setStatusLine(int status, String reasonPhrase) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/1.1 ");
        sb.append(String.valueOf(status));
        sb.append(' ');
        if (reasonPhrase != null) {
            sb.append(reasonPhrase);
        }
        this.statusLine = sb.toString();
        return this;
    }

    public HttpResp setStatusLine(String statusLine) {
        Ex.MUST(statusLine != null, "statusLine == null");
        this.statusLine = statusLine;
        return this;
    }

    public int parseStatus() {
        String s = this.statusLine;
        Ex.MUST(s.startsWith("HTTP/1.1 "), "Wrong HttpResp: StatusLine");
        s = s.substring(9);
        int index = s.indexOf(32);
        Ex.MUST(index > 0, "Wrong HttpResp: StatusLine");
        return Integer.valueOf(s.substring(0, index));
    }

    public String parseReason() {
        String s = this.statusLine;
        Ex.MUST(s.startsWith("HTTP/1.1 "), "Wrong HttpResp: StatusLine");
        s = s.substring(9);
        int index = s.indexOf(32);
        Ex.MUST(index > 0, "Wrong HttpResp: StatusLine");
        return s.substring(index + 1, s.length());
    }

    public HttpResp addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpResp setBody(Binary bodyBin) {
        this.body = bodyBin;
        return this;
    }

    public String getHeadersStr() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : this.headers.entrySet()) {
            sb.append(pair.getKey());
            sb.append(": ");
            sb.append(pair.getValue());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public Binary toBin() {
        Ex.MUST(this.statusLine != null, "HttpResp: statusLine == null");
        StringBuilder sb = new StringBuilder();
        sb.append(this.statusLine);
        sb.append("\r\n");
        sb.append(this.getHeadersStr());
        sb.append("\r\n");
        Binary b = Binary.Bin().fromUTF8(sb.toString());
        if (this.body != null && !this.body.empty()) {
            b.add(this.body);
        }
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.statusLine);
        sb.append("\r\n");
        sb.append(this.getHeadersStr());
        sb.append("\r\n");
        if (this.body != null && !this.body.empty()) {
            sb.append(String.format(Locale.US, "Body [%d]: \r\n", this.body.size()));
            sb.append(this.body.Hex(1, 8, 32, 0));
        }
        return sb.toString();
    }
}

