/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81.http;

import java.util.function.Consumer;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;
import org.denom.scp81.http.HttpResp;

public class HttpRespParser {
    private static final int STATE_STATUS_LINE = 1;
    private static final int STATE_HEADER_LINE = 2;
    private static final int STATE_BODY_BINARY = 3;
    private static final int STATE_CHUNKED_LEN = 4;
    private static final int STATE_CHUNKED_DATA = 5;
    private int parseState = 0;
    private Binary recievedData = Binary.Bin();
    private int parseOffset = 0;
    private HttpResp curResp;
    private int contentLen = 0;
    private boolean isChunked = false;
    private int chunkLen = 0;
    Binary inBuf = Binary.Bin().reserve(256);
    private Consumer<HttpResp> funcOnHttpResp;
    ILog log = null;
    private static final Binary crlf = Binary.Bin("0d0a");

    public HttpRespParser() {
        this.init();
    }

    public HttpRespParser setLog(ILog log) {
        this.log = log;
        return this;
    }

    public HttpRespParser setOnHttpResp(Consumer<HttpResp> funcOnHttpResp) {
        this.funcOnHttpResp = funcOnHttpResp;
        return this;
    }

    private void init() {
        this.parseState = 1;
        this.parseOffset = 0;
        this.curResp = new HttpResp();
        this.contentLen = 0;
        this.isChunked = false;
    }

    public void append(Binary data) {
        int offset = 0;
        while (offset < data.size()) {
            int partSize = Math.min(256, data.size() - offset);
            this.recievedData.add(data, offset, partSize);
            offset += partSize;
            while (this.processRecievedData()) {
            }
        }
    }

    private void gotFullResponse() {
        this.recievedData.assign(this.recievedData, this.parseOffset, this.recievedData.size() - this.parseOffset);
        HttpResp resp = this.curResp;
        this.init();
        if (this.log != null) {
            this.log.writeln(-7303024, "HTTP Response:");
            this.log.writeln(-14614592, resp.toString());
        }
        Ex.MUST(this.funcOnHttpResp != null, "Response handler not set");
        this.funcOnHttpResp.accept(resp);
    }

    private boolean processRecievedData() {
        switch (this.parseState) {
            case 1: {
                String curStr = this.getLine();
                if (curStr == null) {
                    return false;
                }
                this.curResp.setStatusLine(curStr);
                this.parseState = 2;
                return true;
            }
            case 2: {
                String curStr = this.getLine();
                if (curStr == null) {
                    return false;
                }
                if (!curStr.isEmpty()) {
                    int index = curStr.indexOf(58);
                    Ex.MUST(index > 0, "Wrong HTTPResponse: HeaderLine");
                    String key = curStr.substring(0, index);
                    String value = curStr.substring(index + 1).trim();
                    if (key.equals("Content-Length")) {
                        this.contentLen = Integer.valueOf(value);
                        this.curResp.headers.put(key, value);
                    } else if (key.equals("Transfer-Encoding")) {
                        Ex.MUST(value.equals("chunked"), "Wrong HTTPResponse: HeaderLine");
                        this.isChunked = true;
                    } else {
                        this.curResp.headers.put(key, value);
                    }
                    return true;
                }
                if (this.contentLen != 0) {
                    Ex.MUST(!this.isChunked, "Wrong HTTPResponse: chunked or content-length");
                    this.parseState = 3;
                    return true;
                }
                if (this.isChunked) {
                    this.parseState = 4;
                    return true;
                }
                this.gotFullResponse();
                return true;
            }
            case 3: {
                int restLen = this.recievedData.size() - this.parseOffset;
                if (restLen < this.contentLen) {
                    return false;
                }
                Ex.MUST(restLen == this.contentLen, "Wrong HTTPResponse: more data than Content-Length");
                this.curResp.body = this.recievedData.slice(this.parseOffset, this.contentLen);
                this.gotFullResponse();
                return true;
            }
            case 4: {
                String curStr = this.getLine();
                if (curStr == null) {
                    return false;
                }
                this.chunkLen = Integer.valueOf(curStr, 16);
                this.parseState = 5;
                return true;
            }
            case 5: {
                if (this.recievedData.size() - this.parseOffset < this.chunkLen + 2) {
                    return false;
                }
                Binary chunkData = this.recievedData.slice(this.parseOffset, this.chunkLen);
                this.curResp.body.add(chunkData);
                this.parseOffset += this.chunkLen;
                Ex.MUST(this.recievedData.get(this.parseOffset) == 13 && this.recievedData.get(this.parseOffset + 1) == 10, "Wrong HTTPResponse: chunked CRLF");
                this.parseOffset += 2;
                if (this.chunkLen == 0) {
                    this.gotFullResponse();
                } else {
                    this.parseState = 4;
                }
                return true;
            }
        }
        Ex.THROW("Wrong parse state");
        return false;
    }

    private String getLine() {
        int offsetCRLF = this.recievedData.indexOf(crlf, this.parseOffset);
        if (offsetCRLF == -1) {
            return null;
        }
        String s = new String(this.recievedData.getDataRef(), this.parseOffset, offsetCRLF - this.parseOffset, Strings.UTF8);
        this.parseOffset = offsetCRLF + 2;
        return s;
    }
}

