/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81.http;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.scp81.http.HttpResp;

public class SCP81Response
extends HttpResp {
    public SCP81Response() {
        this.addHeader("X-Admin-Protocol", "globalplatform-remote-admin/1.0");
    }

    public void addNextURI(String nextURI) {
        this.addHeader("X-Admin-Next-URI", nextURI);
    }

    public void addTargetApp(String targetApp) {
        this.addHeader("X-Admin-Targeted-Application", targetApp);
    }

    public static SCP81Response noContent() {
        SCP81Response resp = new SCP81Response();
        resp.setStatusLine(204, "No Content");
        return resp;
    }

    public static SCP81Response OkRAM(Binary body) {
        Ex.MUST(!body.empty(), "Empty body in SCP81Response");
        SCP81Response resp = new SCP81Response();
        resp.setStatusLine(200, "OK");
        resp.addHeader("Content-Type", "application/vnd.globalplatform.card-content-mgt;version=1.0");
        resp.addHeader("Content-Length", String.valueOf(body.size()));
        resp.setBody(body);
        return resp;
    }

    public static SCP81Response OkRFM(Binary body) {
        Ex.MUST(!body.empty(), "Empty body in SCP81Response");
        SCP81Response resp = new SCP81Response();
        resp.setStatusLine(200, "OK");
        resp.addHeader("Content-Type", "application/vnd.etsi.scp.command-data;version=1.0");
        resp.addHeader("Content-Length", String.valueOf(body.size()));
        resp.setBody(body);
        return resp;
    }
}

