/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81.http;

import org.denom.Binary;
import org.denom.log.ILog;
import org.denom.net.SocketClient;
import org.denom.scp81.TlsPSKClientSession;
import org.denom.scp81.http.HttpReq;
import org.denom.scp81.http.HttpResp;
import org.denom.scp81.http.HttpRespParser;

public class TlsPSKHttpClient {
    private final SocketClient socketClient;
    private final HttpRespParser respParser;
    private final TlsPSKClientSession session;
    private HttpResp curResp;
    Binary buf = Binary.Bin();

    public TlsPSKHttpClient(SocketClient socketClient, TlsPSKClientSession session, ILog logHTTP) {
        this.socketClient = socketClient;
        this.session = session;
        this.respParser = new HttpRespParser().setLog(logHTTP);
        session.setRecievedAppData(this.respParser::append);
        session.setSendData(socketClient::write);
        this.respParser.setOnHttpResp(r -> {
            HttpResp httpResp = this.curResp = r;
        });
    }

    public void doHandshake() {
        this.session.startHandshake();
        while (!this.session.isHandshakeDone()) {
            this.socketClient.readSome(this.buf, 1024);
            this.session.appendIncomingData(this.buf);
            this.buf.clear();
        }
    }

    public synchronized HttpResp send(HttpReq req) {
        this.session.sendHttpReq(req);
        this.curResp = null;
        this.buf.clear();
        while (this.curResp == null) {
            this.socketClient.readSome(this.buf, 1000);
            this.session.appendIncomingData(this.buf);
            this.buf.clear();
        }
        return this.curResp;
    }
}

