/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.smartcard.CApdu;

public class ApduIso {
    public static CApdu SelectFile(String fileID) {
        return ApduIso.SelectFile(Binary.Bin(fileID), 4, 256);
    }

    public static CApdu SelectFile(Binary fileID) {
        return ApduIso.SelectFile(fileID, 4, 256);
    }

    public static CApdu SelectFile(Binary fileID, int selectAnswer, int Ne) {
        CApdu ap = new CApdu(0, 164, 0, selectAnswer, fileID, Ne, "{ISO} SELECT by FileID");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu SelectAID(Binary aid) {
        return ApduIso.SelectAID(aid, 0, false, 256);
    }

    public static CApdu SelectAID(String aid) {
        return ApduIso.SelectAID(Binary.Bin(aid), 0, false, 256);
    }

    public static CApdu SelectAID(Binary aid, int logicalChannel) {
        CApdu ap = ApduIso.SelectAID(aid);
        ap.cla = ApduIso.addChannelToCLA(ap.cla, logicalChannel);
        return ap;
    }

    public static CApdu SelectAID(String aid, int logicalChannel) {
        CApdu ap = ApduIso.SelectAID(aid);
        ap.cla = ApduIso.addChannelToCLA(ap.cla, logicalChannel);
        return ap;
    }

    public static CApdu SelectAID(Binary aid, int select_answer, boolean next, int len) {
        int p2 = select_answer;
        if (next) {
            p2 = select_answer | 2;
        }
        CApdu ap = new CApdu(0, 164, 4, p2, aid, len, "{ISO} SELECT by AID");
        ap.isTlvData = true;
        return ap;
    }

    public static int addChannelToCLA(int cla, int channelId) {
        Ex.MUST(Int.isU8(channelId) && channelId < 20, "Wrong channelID");
        cla = channelId <= 3 ? (cla |= channelId) : (cla |= 0x40 | channelId - 4);
        return cla;
    }

    public static CApdu ManageChannelOpen(int curChannel, int newChannel) {
        int cla = ApduIso.addChannelToCLA(0, curChannel);
        int Ne = newChannel == 0 ? 1 : 0;
        CApdu ap = new CApdu(cla, 112, 0, newChannel, Binary.Bin(), Ne, "{ISO} MANAGE CHANNEL (open)");
        return ap;
    }

    public static CApdu ManageChannelClose(int curChannel, int \u0441hannelToClose) {
        int cla = ApduIso.addChannelToCLA(0, curChannel);
        CApdu ap = new CApdu(cla, 112, 128, \u0441hannelToClose, Binary.Bin(), 0, "{ISO} MANAGE CHANNEL (close)");
        return ap;
    }

    public static CApdu ReadRecord(int sfi, int recordId) {
        Ex.MUST(sfi >= 0 && sfi < 31, "Wrong 'Short File Id'");
        Ex.MUST(recordId > 0 && recordId <= 255, "Wrong 'Record number'");
        CApdu ap = new CApdu(0, 178, recordId, sfi << 3 | 4, Binary.Bin(), 256, "{ISO} READ RECORD");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu UpdateRecord(int short_id, int record_number, Binary record) {
        Ex.MUST(record_number > 0 && record_number <= 255, "Wrong 'Record number'");
        Ex.MUST(short_id >= 0 && short_id < 31, "Wrong 'Short File ID'");
        CApdu ap = new CApdu(0, 220, record_number, short_id << 3 | 4, record, 0, "{ISO} UPDATE RECORD");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu GetData(int tag, int len) {
        Ex.MUST(Int.isU16(tag), "Wrong Tag");
        return new CApdu(0, 202, tag >>> 8, tag & 0xFF, Binary.Bin(), len, "{ISO} GET DATA");
    }

    public static CApdu PutData(int tag, Binary value) {
        Ex.MUST(Int.isU16(tag), "Wrong BER Tag");
        return new CApdu(0, 218, tag >>> 8, tag & 0xFF, value, 0, "{ISO} PUT DATA");
    }

    public static CApdu GetChallenge(int len) {
        return new CApdu(0, 132, 0, 0, Binary.Bin(), len, "{ISO} GET CHALLENGE");
    }
}

