/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.IApduLogger;
import org.denom.smartcard.RApdu;

public class ApduLoggerMinimal
implements IApduLogger {
    private ILog log;
    private boolean isPrintCallPlace = false;
    private boolean isPrintCommandTime = false;
    private boolean isPrintDescription = false;

    public ApduLoggerMinimal(ILog log) {
        this.log = log;
    }

    @Override
    public void setLog(ILog log) {
        this.log = log;
    }

    @Override
    public ILog getLog() {
        return this.log;
    }

    public ApduLoggerMinimal setPrintCallPlace(boolean isPrintCallPlace) {
        this.isPrintCallPlace = isPrintCallPlace;
        return this;
    }

    public ApduLoggerMinimal setPrintDescription(boolean isPrintDescription) {
        this.isPrintDescription = isPrintDescription;
        return this;
    }

    public ApduLoggerMinimal setPrintCommandTime(boolean isPrintCommandTime) {
        this.isPrintCommandTime = isPrintCommandTime;
        return this;
    }

    @Override
    public void printPowerOn() {
        this.log.writeln(-8326928, "Power on");
    }

    @Override
    public void printPowerOff() {
        this.log.writeln(-8326928, "Power off");
    }

    @Override
    public void printReset() {
        this.log.writeln(-8326928, "Reset");
    }

    @Override
    public void printATR(Binary atr) {
        this.log.writeln(-8326928, "ATR: " + atr.Hex());
    }

    private String oneLineCApdu(CApdu capdu) {
        Binary b = capdu.toBin();
        StringBuilder sb = new StringBuilder();
        sb.append(" ->  ");
        sb.append(b.first(4).Hex(1));
        if (b.size() > 4) {
            sb.append("  ");
            sb.append(b.slice(4, 1).Hex());
        }
        if (b.size() > 5) {
            sb.append("  ");
            int restLen = b.size() - 5;
            if (restLen > 0 && capdu.getNe() > 0) {
                sb.append(b.slice(5, b.size() - 6).Hex());
                sb.append("  ");
                sb.append(b.last(1).Hex());
            } else {
                sb.append(b.slice(5, b.size() - 5).Hex());
            }
        }
        return sb.toString();
    }

    private String oneLineRApdu(RApdu rapdu) {
        String s = " <-  ";
        if (!rapdu.response.empty()) {
            s = String.valueOf(s) + rapdu.response.Hex();
            s = String.valueOf(s) + "  ";
        }
        s = String.valueOf(s) + Binary.Num_Bin(rapdu.status, 2).Hex();
        return s;
    }

    @Override
    public void printBeforeCommand(CApdu capdu, String callClassName) {
        this.log.writeln("");
        if (this.isPrintCallPlace) {
            this.log.write(-7303024, String.valueOf(Strings.currentDateTime()) + " -- ");
            this.log.writeln(-7303024, Ex.getCallerPlace(callClassName));
        }
        if (this.isPrintDescription && capdu.description != null && !capdu.description.isEmpty()) {
            this.log.writeln(-6250258, capdu.description);
        }
        this.log.writeln(-10429734, this.oneLineCApdu(capdu));
    }

    @Override
    public void printCApduSM(CApdu capduSM) {
        this.log.writeln(-7303024, "\t" + this.oneLineCApdu(capduSM));
    }

    @Override
    public void printRApduSM(RApdu rapduSM, boolean isTlvData) {
        this.log.writeln(-7303024, "\t" + this.oneLineRApdu(rapduSM));
    }

    @Override
    public void printAfterCommand(RApdu rapdu, long commandTime, boolean isTlvData) {
        int color = rapdu.isOk() ? -9381264 : -3968;
        this.log.writeln(color, this.oneLineRApdu(rapdu));
        if (this.isPrintCommandTime) {
            this.log.writeln(-7303024, "cmd time: " + commandTime + " ms");
        }
    }
}

