/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.util.Arrays;
import java.util.Locale;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.log.ILog;
import org.denom.log.LogDummy;
import org.denom.smartcard.CApdu;

public class RApdu {
    public static final int ST_OK = 1;
    public static final int ST_ERR = 2;
    public static final int ST_ANY = 3;
    public Binary response = Binary.Bin();
    public int status;

    public RApdu() {
    }

    public RApdu(int status) {
        Ex.MUST(Int.isU16(status), "Wrong status");
        this.status = status;
    }

    public RApdu(Binary response, int status) {
        this(status);
        this.response = response.clone();
    }

    public RApdu(Binary bin) {
        this.assign(bin);
    }

    public RApdu(byte[] bin) {
        this.assign(bin);
    }

    public RApdu clone() {
        return new RApdu(this.response, this.status);
    }

    public int sw1() {
        return this.status >> 8 & 0xFF;
    }

    public int sw2() {
        return this.status & 0xFF;
    }

    public void clear() {
        this.status = 0;
        this.response = Binary.Bin();
    }

    public void assign(byte[] rapdu) {
        int sz = rapdu.length;
        Ex.MUST(sz >= 2, "Wrong len of Response APDU ( < 2 bytes)");
        this.status = (rapdu[sz - 2] & 0xFF) << 8 | rapdu[sz - 1] & 0xFF;
        this.response.assign(rapdu, 0, sz - 2);
    }

    public void assign(Binary rapdu) {
        int sz = rapdu.size();
        Ex.MUST(sz >= 2, "Wrong len of Response APDU ( < 2 bytes)");
        this.status = rapdu.getU16(sz - 2);
        this.response.assign(rapdu, 0, sz - 2);
    }

    public Binary toBin() {
        return new Binary(this.response).addU16(this.status);
    }

    public void print(ILog log, int color, int lineShift, boolean isTlvData) {
        if (log instanceof LogDummy) {
            return;
        }
        String shiftStr = "";
        if (lineShift > 0) {
            char[] arr = new char[lineShift];
            Arrays.fill(arr, ' ');
            shiftStr = new String(arr);
        }
        if (!this.response.empty()) {
            String response_hex = this.response.Hex(1, 8, 32, lineShift);
            log.writeln(color, String.format(Locale.US, "%1$sResponse: %2$d (0x%2$X)", shiftStr, this.response.size()));
            log.writeln(color, response_hex);
            if (isTlvData) {
                CApdu.printFieldAsTLV(this.response, log, color, lineShift, shiftStr);
            }
        }
        log.writeln(color, String.format("%sStatus: %4X (%s)", shiftStr, this.status, RApdu.getStatusDescripton(this.status)));
    }

    public static String getStatusDescripton(int status) {
        int sw1 = status >> 8 & 0xFF;
        int sw2 = status & 0xFF;
        if ((sw1 & 0xF0) != 96 && (sw1 & 0xF0) != 144) {
            return "Protocol error (first nibble must be '6' or '9')";
        }
        if (status == 36864) {
            return "Ok";
        }
        if (sw1 == 97) {
            return String.valueOf(Integer.toHexString(sw2)) + " bytes available";
        }
        if (sw1 == 108) {
            return "Resend command with P3 = " + Integer.toHexString(sw2);
        }
        if ((status & 0xFFF0) == 25536) {
            return "Wrong key, attempts left: " + (sw2 & 0xF);
        }
        if (sw1 == 145) {
            return "Proactive command on card";
        }
        switch (status) {
            case 37632: {
                return "SIM Application Toolkit is busy";
            }
            case 25088: {
                return "Warning: State of non-volatile memory is unchanged";
            }
            case 25217: {
                return "Warning: Part of returned data may be corrupted";
            }
            case 25218: {
                return "Warning: End of file or record reached before reading Ne bytes";
            }
            case 25219: {
                return "Warning: Selected file deactivated";
            }
            case 25220: {
                return "Warning: File control information not formatted according to 5.3.3";
            }
            case 25221: {
                return "Warning: Selected file in termination state";
            }
            case 25222: {
                return "Warning: No input data available from a sensor on the card";
            }
            case 25344: {
                return "State of non-volatile memory has changed";
            }
            case 25473: {
                return "File filled up by the last write";
            }
            case 25600: {
                return "State of non-volatile memory is unchanged";
            }
            case 25601: {
                return "Immediate response required by the card";
            }
            case 25856: {
                return "State of non-volatile memory has changed";
            }
            case 25985: {
                return "Memory failure";
            }
            case 26112: {
                return "Security-related issues";
            }
            case 26368: {
                return "Wrong length";
            }
            case 26624: {
                return "Functions in CLA not supported";
            }
            case 26753: {
                return "Logical channel not supported";
            }
            case 26754: {
                return "Secure messaging not supported";
            }
            case 26755: {
                return "Last command of the chain expected";
            }
            case 26756: {
                return "Command chaining not supported";
            }
            case 26880: {
                return "Command not allowed";
            }
            case 27009: {
                return "Command incompatible with file structure";
            }
            case 27010: {
                return "Security status not satisfied";
            }
            case 27011: {
                return "Authentication method blocked";
            }
            case 27012: {
                return "Reference data not usable";
            }
            case 27013: {
                return "Conditions of use not satisfied";
            }
            case 27014: {
                return "Command not allowed (no current EF)";
            }
            case 27015: {
                return "Expected secure messaging data objects missing";
            }
            case 27016: {
                return "Incorrect secure messaging data objects";
            }
            case 27136: {
                return "Wrong parameters P1-P2";
            }
            case 27264: {
                return "Incorrect parameters in the command data field";
            }
            case 27265: {
                return "Function not supported";
            }
            case 27266: {
                return "File or application not found";
            }
            case 27267: {
                return "Record not found";
            }
            case 27268: {
                return "Not enough memory space in the file";
            }
            case 27269: {
                return "Nc inconsistent with TLV structure";
            }
            case 27270: {
                return "Incorrect parameters P1-P2";
            }
            case 27271: {
                return "Nc inconsistent with parameters P1-P2";
            }
            case 27272: {
                return "Referenced data or reference data not found";
            }
            case 27273: {
                return "File already exists";
            }
            case 27274: {
                return "DF name already exists";
            }
            case 27392: {
                return "Wrong parameters P1-P2";
            }
            case 27648: {
                return "Wrong Le field; SW2 encodes the exact number of available data bytes";
            }
            case 27904: {
                return "Instruction code not supported or invalid ";
            }
            case 28160: {
                return "Class not supported";
            }
            case 28416: {
                return "No precise diagnosis";
            }
        }
        return "Unknown Error";
    }

    public boolean isOk() {
        return this.status == 36864 || this.sw1() == 97 || this.sw1() == 145;
    }

    public void checkStatus(int expectedStatus, String callClassName) {
        if (!this.isExpectedStatus(expectedStatus)) {
            throw new Ex(this.formUnexpectedMsg(expectedStatus), Ex.getCallerPlace(callClassName));
        }
    }

    private boolean isExpectedStatus(int expectedStatus) {
        switch (expectedStatus) {
            case 1: {
                return this.isOk();
            }
            case 2: {
                return !this.isOk();
            }
            case 3: {
                return true;
            }
        }
        return expectedStatus == this.status;
    }

    private String formUnexpectedMsg(int expectedStatus) {
        StringBuilder err = new StringBuilder(100);
        err.append("Wrong status. Expected: ");
        switch (expectedStatus) {
            case 1: {
                err.append("OK");
                break;
            }
            case 2: {
                err.append("ERR");
                break;
            }
            case 3: {
                err.append("ANY");
                break;
            }
            default: {
                err.append(Binary.Num_Bin(expectedStatus, 2).Hex());
            }
        }
        err.append(", card status: ");
        err.append(Binary.Num_Bin(this.status, 2).Hex());
        return err.toString();
    }
}

