/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.ComponentDescriptor;
import org.denom.smartcard.cap.ComponentMethod;
import org.denom.smartcard.cap.ExpFile;

public class CapFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    public Binary manifest = Binary.Bin();
    private static final int ARR_SIZE = 13;
    public CompInfo[] comps = new CompInfo[13];
    public Binary packageAID;
    public ArrayList<Binary> classAIDs = new ArrayList(1);

    public CapFile load(String capPath) {
        this.loadAndParse(capPath, false);
        return this;
    }

    public CapFile parse(String capPath) {
        this.loadAndParse(capPath, true);
        return this;
    }

    public CapComponent getComp(int tag) {
        CompInfo comp = this.comps[tag];
        Ex.MUST(comp != null, "Component absent");
        return comp.parsed;
    }

    private Binary readZipEntry(ZipFile zip, ZipEntry entry, byte[] tmpBuf) {
        Binary b = Binary.Bin();
        long entrySize = entry.getSize();
        Ex.MUST(entrySize <= Integer.MAX_VALUE, "Too large components");
        if (entrySize > 0L) {
            b.reserve((int)entrySize);
        }
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream stream = zip.getInputStream(entry);){
                int len;
                while ((len = stream.read(tmpBuf)) > 0) {
                    b.add(tmpBuf, 0, len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Ex(ex);
        }
        return b;
    }

    private void loadAndParse(String capPath, boolean parseIt) {
        this.manifest = Binary.Bin();
        this.comps = new CompInfo[13];
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zip = new ZipFile(capPath);){
                int tag;
                Enumeration<? extends ZipEntry> entries = zip.entries();
                byte[] tmpBuf = new byte[128];
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entryName.equalsIgnoreCase(MANIFEST_NAME)) {
                        this.manifest = this.readZipEntry(zip, entry, tmpBuf);
                    }
                    if ((tag = CapComponent.findTag(entryName)) == -1) continue;
                    this.comps[tag] = new CompInfo();
                    this.comps[tag].data = this.readZipEntry(zip, entry, tmpBuf);
                    this.comps[tag].name = entryName;
                }
                if (parseIt) {
                    CompInfo comp = this.comps[11];
                    Ex.MUST(comp != null, "Descriptor component is absent");
                    comp.parsed = CapComponent.parse(this, comp.name, comp.data);
                    int i = 0;
                    while (i < CapComponent.LOAD_ORDER.length) {
                        tag = CapComponent.LOAD_ORDER[i];
                        comp = this.comps[tag];
                        if (comp != null && comp.parsed == null) {
                            comp.parsed = CapComponent.parse(this, comp.name, comp.data);
                        }
                        ++i;
                    }
                }
                this.initAIDs();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exp) {
            throw new Ex("CAP-file Error: '" + capPath + "'");
        }
    }

    private void initAIDs() {
        this.classAIDs.clear();
        CompInfo comp = this.comps[1];
        Ex.MUST(comp != null, "'Header.cap' is absent");
        Binary header = comp.data;
        Ex.MUST(header.slice(1, 2).asU16() == header.size() - 3, "Wrong 'Header.cap' size");
        int aidLen = header.get(12);
        this.packageAID = header.slice(13, aidLen);
        comp = this.comps[3];
        if (comp != null && !comp.data.empty()) {
            Binary applet = comp.data;
            Ex.MUST(applet.slice(1, 2).asU16() == applet.size() - 3, "Wrong 'Applet.cap' size");
            int classCount = applet.get(3);
            int beg = 4;
            while (beg <= applet.size() - 1 && classCount != 0) {
                aidLen = applet.get(beg);
                this.classAIDs.add(applet.slice(beg + 1, aidLen));
                beg += 3 + aidLen;
            }
        }
    }

    public Binary toBinary(boolean includeDescriptorCap) {
        Binary bin = Binary.Bin();
        int compCount = CapComponent.LOAD_ORDER.length;
        if (!includeDescriptorCap) {
            --compCount;
        }
        int i = 0;
        while (i < compCount) {
            CompInfo comp = this.comps[CapComponent.LOAD_ORDER[i]];
            if (comp != null) {
                bin.add(comp.data);
            }
            ++i;
        }
        return bin;
    }

    public void save(String capPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(capPath));){
                if (this.manifest != null && !this.manifest.empty()) {
                    zip.putNextEntry(new ZipEntry(MANIFEST_NAME));
                    zip.write(this.manifest.getBytes());
                }
                int i = 1;
                while (i < this.comps.length) {
                    if (this.comps[i] != null) {
                        zip.putNextEntry(new ZipEntry(this.comps[i].name));
                        zip.write(this.comps[i].parsed.toBin().getBytes());
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Ex(ex);
        }
    }

    public ComponentDescriptor.MethodDescriptorInfo findMethodDescriptor(ExpFile expFile, String className, String methodName, String methodDescriptor) {
        ExpFile.ClassInfo classInfo = expFile.findClass(className);
        if (classInfo == null) {
            return null;
        }
        ExpFile.MethodInfo methodInfo = classInfo.findMethod(methodName, methodDescriptor);
        if (methodInfo == null) {
            return null;
        }
        ComponentDescriptor compDesc = (ComponentDescriptor)this.getComp(11);
        ComponentDescriptor.ClassDescriptorInfo[] classDescriptorInfoArray = compDesc.classes;
        int n = compDesc.classes.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentDescriptor.ClassDescriptorInfo c = classDescriptorInfoArray[n2];
            if (c.token == classInfo.token) {
                ComponentDescriptor.MethodDescriptorInfo[] methodDescriptorInfoArray = c.methods;
                int n3 = c.methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    ComponentDescriptor.MethodDescriptorInfo m = methodDescriptorInfoArray[n4];
                    if (m.token == methodInfo.token) {
                        return m;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public ComponentMethod.MethodInfo findMethodInfo(ExpFile expFile, String className, String methodName, String methodDescriptor) {
        ComponentDescriptor.MethodDescriptorInfo md = this.findMethodDescriptor(expFile, className, methodName, methodDescriptor);
        if (md == null) {
            return null;
        }
        ComponentMethod compMethod = (ComponentMethod)this.getComp(7);
        for (ComponentMethod.MethodInfo m : compMethod.methods) {
            if (m.methodDescr != md) continue;
            return m;
        }
        return null;
    }

    public static class CompInfo {
        public String name;
        public Binary data;
        public CapComponent parsed;
    }
}

