/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.IComponentElement;

public class ComponentConstantPool
extends CapComponent {
    public int tag;
    public int size;
    public CPInfo[] constPool;
    public static final byte CONSTANT_ClassRef = 1;
    public static final byte CONSTANT_InstanceFieldRef = 2;
    public static final byte CONSTANT_VirtualMethodRef = 3;
    public static final byte CONSTANT_SuperMethodRef = 4;
    public static final byte CONSTANT_StaticFieldRef = 5;
    public static final byte CONSTANT_StaticMethodRef = 6;

    public ComponentConstantPool(CapFile cap, String fullName, Binary b) {
        super(cap, 5, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        int count = b.getU16(offs += 2);
        offs += 2;
        this.constPool = new CPInfo[count];
        int i = 0;
        while (i < this.constPool.length) {
            this.constPool[i] = new CPInfo();
            offs = this.constPool[i].parse(b, offs);
            ++i;
        }
        Ex.MUST(this.tag == 5 && this.size == b.size() - 3 && offs == b.size(), "Wrong component ConstantPool");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.addU16(this.constPool.length);
        CPInfo[] cPInfoArray = this.constPool;
        int n = this.constPool.length;
        int n2 = 0;
        while (n2 < n) {
            CPInfo cp = cPInfoArray[n2];
            cp.toBin(b);
            ++n2;
        }
        return b;
    }

    public static class CPInfo
    implements IComponentElement {
        public int tag;
        public IComponentElement info;

        @Override
        public int parse(Binary b, int offs) {
            this.tag = b.get(offs++);
            switch (this.tag) {
                case 1: {
                    this.info = new ClassRefInfo();
                    break;
                }
                case 2: {
                    this.info = new InstanceRef();
                    break;
                }
                case 3: {
                    this.info = new InstanceRef();
                    break;
                }
                case 4: {
                    this.info = new InstanceRef();
                    break;
                }
                case 5: {
                    this.info = new StaticRef();
                    break;
                }
                case 6: {
                    this.info = new StaticRef();
                    break;
                }
                default: {
                    throw new Ex("Wrong component ConstantPool");
                }
            }
            offs = this.info.parse(b, offs);
            return offs;
        }

        @Override
        public void toBin(Binary b) {
            b.add(this.tag);
            this.info.toBin(b);
        }
    }

    public static class ClassRef
    implements IComponentElement {
        public boolean isExternal;
        public int internalClassRef;
        public int packageToken;
        public int classToken;

        @Override
        public int parse(Binary b, int offs) {
            int b2 = b.getU16(offs);
            offs += 2;
            if ((b2 & 0x8000) != 0) {
                this.isExternal = true;
                this.packageToken = b2 >> 8 & 0x7F;
                this.classToken = b2 & 0xFF;
            } else {
                this.isExternal = false;
                this.internalClassRef = b2;
            }
            return offs;
        }

        @Override
        public void toBin(Binary b) {
            if (this.isExternal) {
                b.addU16(0x8000 | this.packageToken << 8 | this.classToken);
            } else {
                b.addU16(this.internalClassRef);
            }
        }
    }

    public static class ClassRefInfo
    implements IComponentElement {
        public ClassRef classRef;

        @Override
        public int parse(Binary b, int offs) {
            int padding;
            this.classRef = new ClassRef();
            offs = this.classRef.parse(b, offs);
            Ex.MUST((padding = b.get(offs++)) == 0, "Wrong component ConstantPool");
            return offs;
        }

        @Override
        public void toBin(Binary b) {
            this.classRef.toBin(b);
            b.add(0);
        }
    }

    public static class InstanceRef
    implements IComponentElement {
        public ClassRef classRef;
        public int token;

        @Override
        public int parse(Binary b, int offs) {
            this.classRef = new ClassRef();
            offs = this.classRef.parse(b, offs);
            this.token = b.get(offs++);
            return offs;
        }

        @Override
        public void toBin(Binary b) {
            this.classRef.toBin(b);
            b.add(this.token);
        }
    }

    public static class StaticRef
    implements IComponentElement {
        public boolean isExternal;
        public int offset;
        public int packageToken;
        public int classToken;
        public int token;

        @Override
        public int parse(Binary b, int offs) {
            int b0;
            if (((b0 = b.get(offs++)) & 0x80) != 0) {
                this.isExternal = true;
                this.packageToken = b0 & 0x7F;
                this.classToken = b.get(offs++);
                this.token = b.get(offs++);
            } else {
                this.isExternal = false;
                this.offset = b.getU16(offs);
                offs += 2;
            }
            return offs;
        }

        @Override
        public void toBin(Binary b) {
            if (this.isExternal) {
                b.add(0x80 | this.packageToken);
                b.add(this.classToken);
                b.add(this.token);
            } else {
                b.add(0);
                b.addU16(this.offset);
            }
        }
    }
}

