/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import java.util.ArrayList;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.ComponentClass;
import org.denom.smartcard.cap.ComponentConstantPool;

public class ComponentDescriptor
extends CapComponent {
    public int tag;
    public int size;
    public ClassDescriptorInfo[] classes;
    public int[] constPoolTypes;
    public ArrayList<ComponentClass.TypeDescriptor> typeDesc;

    public ComponentDescriptor(CapFile cap, String fullName, Binary b) {
        super(cap, 11, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int classCount = b.get(offs++);
        this.classes = new ClassDescriptorInfo[classCount];
        int i = 0;
        while (i < this.classes.length) {
            this.classes[i] = new ClassDescriptorInfo();
            offs = this.classes[i].parse(b, offs);
            ++i;
        }
        int constPoolCount = b.getU16(offs);
        offs += 2;
        this.constPoolTypes = new int[constPoolCount];
        int i2 = 0;
        while (i2 < this.constPoolTypes.length) {
            this.constPoolTypes[i2] = b.getU16(offs);
            offs += 2;
            ++i2;
        }
        this.typeDesc = new ArrayList();
        while (offs < b.size()) {
            ComponentClass.TypeDescriptor td = new ComponentClass.TypeDescriptor();
            offs = td.parse(b, offs);
            this.typeDesc.add(td);
        }
        Ex.MUST(this.tag == 11 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Descriptor");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.add(this.classes.length);
        Object[] objectArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassDescriptorInfo cl = objectArray[n2];
            cl.toBin(b);
            ++n2;
        }
        b.addU16(this.constPoolTypes.length);
        objectArray = this.constPoolTypes;
        n = this.constPoolTypes.length;
        n2 = 0;
        while (n2 < n) {
            ClassDescriptorInfo elem = objectArray[n2];
            b.addU16((int)elem);
            ++n2;
        }
        for (ComponentClass.TypeDescriptor td : this.typeDesc) {
            td.toBin(b);
        }
        return b;
    }

    public MethodDescriptorInfo findMethod(int methodOffset) {
        ClassDescriptorInfo[] classDescriptorInfoArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassDescriptorInfo cl = classDescriptorInfoArray[n2];
            MethodDescriptorInfo[] methodDescriptorInfoArray = cl.methods;
            int n3 = cl.methods.length;
            int n4 = 0;
            while (n4 < n3) {
                MethodDescriptorInfo md = methodDescriptorInfoArray[n4];
                if (md.methodOffset == methodOffset) {
                    return md;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static class ClassDescriptorInfo {
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_FINAL = 16;
        public static final int ACC_INTERFACE = 64;
        public static final int ACC_ABSTRACT = 128;
        public int token;
        public int accessFlags;
        public ComponentConstantPool.ClassRef thisClassRef;
        public ComponentConstantPool.ClassRef[] interfaces;
        public FieldDescriptorInfo[] fields;
        public MethodDescriptorInfo[] methods;

        protected int parse(Binary b, int offs) {
            this.token = b.get(offs++);
            this.accessFlags = b.get(offs++);
            this.thisClassRef = new ComponentConstantPool.ClassRef();
            offs = this.thisClassRef.parse(b, offs);
            int interfaceCount = b.get(offs++);
            int fieldCount = b.getU16(offs);
            int methodCount = b.getU16(offs += 2);
            offs += 2;
            this.interfaces = new ComponentConstantPool.ClassRef[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                this.interfaces[i] = new ComponentConstantPool.ClassRef();
                offs = this.interfaces[i].parse(b, offs);
                ++i;
            }
            this.fields = new FieldDescriptorInfo[fieldCount];
            i = 0;
            while (i < fieldCount) {
                this.fields[i] = new FieldDescriptorInfo();
                offs = this.fields[i].parse(b, offs);
                ++i;
            }
            this.methods = new MethodDescriptorInfo[methodCount];
            i = 0;
            while (i < methodCount) {
                this.methods[i] = new MethodDescriptorInfo();
                offs = this.methods[i].parse(b, offs);
                ++i;
            }
            return offs;
        }

        protected void toBin(Binary b) {
            b.add(this.token);
            b.add(this.accessFlags);
            this.thisClassRef.toBin(b);
            b.add(this.interfaces.length);
            b.addU16(this.fields.length);
            b.addU16(this.methods.length);
            Object[] objectArray = this.interfaces;
            int n = this.interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentConstantPool.ClassRef intf = objectArray[n2];
                intf.toBin(b);
                ++n2;
            }
            objectArray = this.fields;
            n = this.fields.length;
            n2 = 0;
            while (n2 < n) {
                Object field = objectArray[n2];
                ((FieldDescriptorInfo)field).toBin(b);
                ++n2;
            }
            objectArray = this.methods;
            n = this.methods.length;
            n2 = 0;
            while (n2 < n) {
                Object method = objectArray[n2];
                ((MethodDescriptorInfo)method).toBin(b);
                ++n2;
            }
        }
    }

    public static class FieldDescriptorInfo {
        public static final byte ACC_PUBLIC = 1;
        public static final byte ACC_PRIVATE = 2;
        public static final byte ACC_PROTECTED = 4;
        public static final byte ACC_STATIC = 8;
        public static final byte ACC_FINAL = 16;
        public int token;
        public int accessFlags;
        public ComponentConstantPool.StaticRef staticField;
        public ComponentConstantPool.ClassRef classRef;
        public int tokenRef;
        public int type;

        protected int parse(Binary b, int offs) {
            this.token = b.get(offs++);
            this.accessFlags = b.get(offs++);
            if ((this.accessFlags & 8) != 0) {
                this.staticField = new ComponentConstantPool.StaticRef();
                offs = this.staticField.parse(b, offs);
            } else {
                this.classRef = new ComponentConstantPool.ClassRef();
                offs = this.classRef.parse(b, offs);
                this.tokenRef = b.get(offs++);
            }
            this.type = b.getU16(offs);
            return offs += 2;
        }

        protected void toBin(Binary b) {
            b.add(this.token);
            b.add(this.accessFlags);
            if ((this.accessFlags & 8) != 0) {
                this.staticField.toBin(b);
            } else {
                this.classRef.toBin(b);
                b.add(this.token);
            }
            b.addU16(this.type);
        }
    }

    public static class MethodDescriptorInfo {
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_PRIVATE = 2;
        public static final int ACC_PROTECTED = 4;
        public static final int ACC_STATIC = 8;
        public static final int ACC_FINAL = 16;
        public static final int ACC_ABSTRACT = 64;
        public static final int ACC_INIT = 128;
        public int token;
        public int accessFlags;
        public int methodOffset;
        public int typeOffset;
        public int bytecodeCount;
        public int exceptionHandlerCount;
        public int exceptionHandlerIndex;

        protected int parse(Binary b, int offs) {
            this.token = b.get(offs++);
            this.accessFlags = b.get(offs++);
            this.methodOffset = b.getU16(offs);
            this.typeOffset = b.getU16(offs += 2);
            this.bytecodeCount = b.getU16(offs += 2);
            this.exceptionHandlerCount = b.getU16(offs += 2);
            this.exceptionHandlerIndex = b.getU16(offs += 2);
            return offs += 2;
        }

        protected void toBin(Binary b) {
            b.add(this.token);
            b.add(this.accessFlags);
            b.addU16(this.methodOffset);
            b.addU16(this.typeOffset);
            b.addU16(this.bytecodeCount);
            b.addU16(this.exceptionHandlerCount);
            b.addU16(this.exceptionHandlerIndex);
        }
    }
}

