/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.ComponentHeader;

public class ComponentDirectory
extends CapComponent {
    public int tag;
    public int size;
    public int[] componentSizes;
    public StaticInfo staticInfo;
    public int importCount;
    public int appletCount;
    public CustomCompInfo[] customComps;

    public ComponentDirectory(CapFile cap, String fullName, Binary b) {
        super(cap, 2, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int minorVersion = ((ComponentHeader)cap.getComp((int)1)).minorVersion;
        this.componentSizes = new int[minorVersion == 2 ? 12 : 11];
        int i = 0;
        while (i < this.componentSizes.length) {
            this.componentSizes[i] = b.getU16(offs);
            offs += 2;
            ++i;
        }
        this.staticInfo = new StaticInfo();
        this.staticInfo.imageSize = b.getU16(offs);
        this.staticInfo.arrayInitCount = b.getU16(offs += 2);
        this.staticInfo.arrayInitSize = b.getU16(offs += 2);
        offs += 2;
        this.importCount = b.get(offs++);
        this.appletCount = b.get(offs++);
        int customCount = b.get(offs++);
        this.customComps = new CustomCompInfo[customCount];
        int i2 = 0;
        while (i2 < customCount) {
            CustomCompInfo comp = new CustomCompInfo();
            comp.tag = b.get(offs++);
            comp.size = b.getU16(offs);
            offs += 2;
            int aidLen = b.get(offs++);
            comp.aid = b.slice(offs, aidLen);
            offs += aidLen;
            this.customComps[i2] = comp;
            ++i2;
        }
        Ex.MUST(this.tag == 2 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Directory");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        Object[] objectArray = this.componentSizes;
        int n = this.componentSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int sz = objectArray[n2];
            b.addU16(sz);
            ++n2;
        }
        b.addU16(this.staticInfo.imageSize);
        b.addU16(this.staticInfo.arrayInitCount);
        b.addU16(this.staticInfo.arrayInitSize);
        b.add(this.importCount);
        b.add(this.appletCount);
        b.add(this.customComps.length);
        objectArray = this.customComps;
        n = this.customComps.length;
        n2 = 0;
        while (n2 < n) {
            int custom = objectArray[n2];
            b.add(custom.tag);
            b.addU16(custom.size);
            b.add(custom.aid.size());
            b.add(custom.aid);
            ++n2;
        }
        return b;
    }

    public static class CustomCompInfo {
        public int tag;
        public int size;
        public Binary aid;
    }

    public static class StaticInfo {
        public int imageSize;
        public int arrayInitCount;
        public int arrayInitSize;
    }
}

