/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;

public class ComponentHeader
extends CapComponent {
    public int tag;
    public int size;
    public int magic;
    public int minorVersion;
    public int majorVersion;
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    public int flags;
    public PackageInfo pkg;
    public String pkgName = "";

    public ComponentHeader(CapFile cap, String fullName, Binary b) {
        super(cap, 1, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        this.magic = b.getIntBE(offs += 2);
        offs += 4;
        this.minorVersion = b.get(offs++);
        this.majorVersion = b.get(offs++);
        this.flags = b.get(offs++);
        this.pkg = new PackageInfo();
        offs = this.pkg.parse(b, offs);
        if (this.minorVersion == 2) {
            int nameLen;
            if ((nameLen = b.get(offs++)) != 0) {
                this.pkgName = b.slice(offs, nameLen).asUTF8();
            }
            offs += nameLen;
        }
        Ex.MUST(this.tag == 1 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Header");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.addInt(this.magic);
        b.add(this.minorVersion);
        b.add(this.majorVersion);
        b.add(this.flags);
        this.pkg.toBin(b);
        if (this.minorVersion == 2) {
            Binary bName = Binary.Bin().fromUTF8(this.pkgName);
            b.add(bName.size());
            b.add(bName);
        }
        return b;
    }

    public static class PackageInfo {
        public int minorVersion;
        public int majorVersion;
        public Binary AID;

        protected int parse(Binary b, int offs) {
            this.minorVersion = b.get(offs++);
            this.majorVersion = b.get(offs++);
            int aidLen = b.get(offs++);
            this.AID = b.slice(offs, aidLen);
            return offs += aidLen;
        }

        protected void toBin(Binary b) {
            b.add(this.minorVersion);
            b.add(this.majorVersion);
            b.add(this.AID.size());
            b.add(this.AID);
        }
    }
}

