/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;

public class ExpFile {
    public int magic;
    public int minorVersion;
    public int majorVersion;
    public ICPInfo[] constPool;
    public int thisPackage;
    public ClassInfo[] classes;
    public static final byte CONSTANT_Package = 13;
    public static final byte CONSTANT_ClassRef = 7;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Utf8 = 1;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_SHAREABLE = 2048;
    public static final int ACC_REMOTE = 4096;

    public ExpFile load(String expPath) {
        Binary b = Binary.Bin().loadFromFile(expPath);
        this.parse(b);
        return this;
    }

    public ExpFile parse(Binary b) {
        int offs = 0;
        this.magic = b.getIntBE(offs);
        offs += 4;
        this.minorVersion = b.get(offs++);
        this.majorVersion = b.get(offs++);
        int constPoolCount = b.getU16(offs);
        offs += 2;
        this.constPool = new ICPInfo[constPoolCount];
        int i = 0;
        while (i < constPoolCount) {
            int tag = b.get(offs++);
            switch (tag) {
                case 13: {
                    this.constPool[i] = new CP_PackageInfo();
                    break;
                }
                case 7: {
                    this.constPool[i] = new CP_ClassRefInfo();
                    break;
                }
                case 3: {
                    this.constPool[i] = new CP_IntegerInfo();
                    break;
                }
                case 1: {
                    this.constPool[i] = new CP_Utf8Info();
                    break;
                }
                default: {
                    throw new Ex("Wrong EXP-file");
                }
            }
            offs = this.constPool[i].parse(b, offs);
            ++i;
        }
        this.thisPackage = b.getU16(offs);
        offs += 2;
        int expClassCount = b.get(offs++);
        this.classes = new ClassInfo[expClassCount];
        int i2 = 0;
        while (i2 < expClassCount) {
            this.classes[i2] = new ClassInfo();
            offs = this.classes[i2].parse(b, offs);
            ++i2;
        }
        Ex.MUST(this.magic == 16435934 && offs == b.size(), "Wrong EXP-file");
        return this;
    }

    public ClassInfo findClass(String className) {
        ClassInfo[] classInfoArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo classInfo = classInfoArray[n2];
            ICPInfo cpInfo = this.constPool[classInfo.nameIndex];
            Ex.MUST(cpInfo.getTag() == 7, "Wrong EXP-file");
            int cpIndex = ((CP_ClassRefInfo)cpInfo).nameIndex;
            cpInfo = this.constPool[cpIndex];
            Ex.MUST(cpInfo.getTag() == 1, "Wrong EXP-file");
            String name = ((CP_Utf8Info)cpInfo).val;
            if (name.equals(className)) {
                return classInfo;
            }
            ++n2;
        }
        return null;
    }

    public MethodInfo findMethod(String className, String methodName, String methodDescriptor) {
        ClassInfo cl = this.findClass(className);
        if (cl == null) {
            return null;
        }
        return cl.findMethod(methodName, methodDescriptor);
    }

    public static class AttributeInfo {
        int nameIndex;
        Binary info;

        public int parse(Binary b, int offs) {
            this.nameIndex = b.getU16(offs);
            int len = b.getIntBE(offs += 2);
            this.info = b.slice(offs += 4, len);
            return offs += len;
        }
    }

    public static class CP_ClassRefInfo
    implements ICPInfo {
        public int nameIndex;

        @Override
        public int parse(Binary b, int offs) {
            this.nameIndex = b.getU16(offs);
            return offs += 2;
        }

        @Override
        public int getTag() {
            return 7;
        }
    }

    public static class CP_IntegerInfo
    implements ICPInfo {
        public int val;

        @Override
        public int parse(Binary b, int offs) {
            this.val = b.getIntBE(offs);
            return offs += 4;
        }

        @Override
        public int getTag() {
            return 3;
        }
    }

    public static class CP_PackageInfo
    implements ICPInfo {
        public static final int ACC_LIBRARY = 1;
        public int flags;
        public int nameIndex;
        public int minorVersion;
        public int majorVersion;
        public Binary aid;

        @Override
        public int parse(Binary b, int offs) {
            this.flags = b.get(offs++);
            this.nameIndex = b.getU16(offs);
            offs += 2;
            this.minorVersion = b.get(offs++);
            this.majorVersion = b.get(offs++);
            int aidLen = b.get(offs++);
            this.aid = b.slice(offs, aidLen);
            return offs += aidLen;
        }

        @Override
        public int getTag() {
            return 13;
        }
    }

    public static class CP_Utf8Info
    implements ICPInfo {
        public String val;

        @Override
        public int parse(Binary b, int offs) {
            int len = b.getU16(offs);
            this.val = b.slice(offs += 2, len).asUTF8();
            return offs += len;
        }

        @Override
        public int getTag() {
            return 1;
        }
    }

    public class ClassInfo {
        public int token;
        public int accessFlags;
        public int nameIndex;
        public int[] supers;
        public int[] interfaces;
        public FieldInfo[] fields;
        public MethodInfo[] methods;

        public int parse(Binary b, int offs) {
            this.token = b.get(offs++);
            this.accessFlags = b.getU16(offs);
            this.nameIndex = b.getU16(offs += 2);
            int count = b.getU16(offs += 2);
            offs += 2;
            this.supers = new int[count];
            int i = 0;
            while (i < this.supers.length) {
                this.supers[i] = b.getU16(offs);
                offs += 2;
                ++i;
            }
            count = b.get(offs++);
            this.interfaces = new int[count];
            i = 0;
            while (i < this.interfaces.length) {
                this.interfaces[i] = b.getU16(offs);
                offs += 2;
                ++i;
            }
            count = b.getU16(offs);
            offs += 2;
            this.fields = new FieldInfo[count];
            i = 0;
            while (i < this.fields.length) {
                this.fields[i] = new FieldInfo();
                offs = this.fields[i].parse(b, offs);
                ++i;
            }
            count = b.getU16(offs);
            offs += 2;
            this.methods = new MethodInfo[count];
            i = 0;
            while (i < this.methods.length) {
                this.methods[i] = new MethodInfo();
                offs = this.methods[i].parse(b, offs);
                ++i;
            }
            return offs;
        }

        public MethodInfo findMethod(String name, String descriptor) {
            MethodInfo[] methodInfoArray = this.methods;
            int n = this.methods.length;
            int n2 = 0;
            while (n2 < n) {
                MethodInfo method = methodInfoArray[n2];
                ICPInfo cpInfo = ExpFile.this.constPool[method.nameIndex];
                Ex.MUST(cpInfo.getTag() == 1, "Wrong EXP-file");
                String curMethodName = ((CP_Utf8Info)cpInfo).val;
                if (name.equals(curMethodName)) {
                    cpInfo = ExpFile.this.constPool[method.descriptorIndex];
                    Ex.MUST(cpInfo.getTag() == 1, "Wrong EXP-file");
                    String curDescriptor = ((CP_Utf8Info)cpInfo).val;
                    if (descriptor.equals(curDescriptor)) {
                        return method;
                    }
                }
                ++n2;
            }
            return null;
        }
    }

    public static class FieldInfo {
        public int token;
        public int accessFlags;
        public int nameIndex;
        public int descriptorIndex;
        public AttributeInfo[] attributes;

        public int parse(Binary b, int offs) {
            this.token = b.get(offs++);
            this.accessFlags = b.getU16(offs);
            this.nameIndex = b.getU16(offs += 2);
            this.descriptorIndex = b.getU16(offs += 2);
            int count = b.getU16(offs += 2);
            offs += 2;
            this.attributes = new AttributeInfo[count];
            int i = 0;
            while (i < this.attributes.length) {
                this.attributes[i] = new AttributeInfo();
                offs = this.attributes[i].parse(b, offs);
                ++i;
            }
            return offs;
        }
    }

    public static interface ICPInfo {
        public int parse(Binary var1, int var2);

        public int getTag();
    }

    public static class MethodInfo {
        public int token;
        public int accessFlags;
        public int nameIndex;
        public int descriptorIndex;

        public int parse(Binary b, int offs) {
            this.token = b.get(offs++);
            this.accessFlags = b.getU16(offs);
            this.nameIndex = b.getU16(offs += 2);
            this.descriptorIndex = b.getU16(offs += 2);
            return offs += 2;
        }
    }
}

