/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.AES;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.crypt.blockcipher.DES;
import org.denom.crypt.blockcipher.TripleDES;

public class EmvCrypt {
    public static Binary deriveMKTripleDes(TripleDES IMK, Binary Y) {
        Ex.MUST(IMK.getKeySize() == 16, "Wrong key size");
        Ex.MUST(Y.size() == 8, "Wrong size of derivation data");
        Binary Y2 = Binary.xor(Y, Binary.Bin(8, 255));
        Binary Z = Binary.Bin(Y, Y2);
        Z = IMK.encrypt(Z, CryptoMode.ECB, AlignMode.NONE, null);
        DES.setOddParityBits(Z);
        return Z;
    }

    public static Binary deriveMKTripleDes(TripleDES IMK, Binary PAN, Binary PAN_SN) {
        Binary X = Binary.Bin(PAN, PAN_SN);
        Binary Y = X.last(8);
        return EmvCrypt.deriveMKTripleDes(IMK, Y);
    }

    public static Binary deriveMKAes(AES IMK, Binary PAN, Binary PAN_SN) {
        Binary Y = Binary.Bin(Binary.Bin(16 - PAN.size() - PAN_SN.size()), PAN, PAN_SN);
        int keySize = IMK.getKeySize();
        if (keySize == 16) {
            IMK.encryptBlock(Y);
            return Y;
        }
        Binary Y2 = Binary.xor(Y, Binary.Bin(16, 255));
        Binary MK = IMK.encrypt(Binary.Bin(Y, Y2), CryptoMode.ECB, AlignMode.NONE, null);
        return MK.first(keySize);
    }

    public static Binary calcSK(BlockCipher MK, Binary R) {
        Ex.MUST(R.size() == MK.getBlockSize(), "Wrong R size for EMV session key");
        if (MK instanceof AES && MK.getKeySize() == 16) {
            Binary sk = R.clone();
            MK.encryptBlock(sk);
            return sk;
        }
        Binary l = R.clone();
        l.set(2, 240);
        Binary r = R.clone();
        r.set(2, 15);
        Binary sk = MK.encrypt(Binary.Bin(l, r), CryptoMode.ECB, AlignMode.NONE, null).first(MK.getKeySize());
        return sk;
    }

    public static Binary calcSKac(BlockCipher MKac, Binary atc) {
        Ex.MUST(atc.size() == 2, "Wrong ATC size");
        Binary R = atc.clone();
        R.resize(MKac.getBlockSize());
        Binary SKac = EmvCrypt.calcSK(MKac, R);
        return SKac;
    }

    public static Binary calcTripleDesSKac(int kdm, TripleDES MKac, Binary atc, Binary unpredictableNumber) {
        if (kdm == 1) {
            Ex.MUST(atc.size() == 2, "Wrong ATC size");
            Ex.MUST(unpredictableNumber.size() == 4, "Wrong unpredictableNumber size");
            Binary R = atc.clone();
            R.resize(4);
            R.add(unpredictableNumber);
            Binary SKac = EmvCrypt.calcSK(MKac, R);
            return SKac;
        }
        return EmvCrypt.calcSKac(MKac, atc);
    }

    public static Binary calcMAC(TripleDES SK, Binary msg) {
        return SK.calcMACAlg3(msg, AlignMode.BLOCK, null);
    }

    public static Binary calcMAC(AES SK, Binary msg) {
        return SK.calcCMAC(msg, null).first(8);
    }

    public static Binary calcAC(TripleDES SKac, Binary msg) {
        return EmvCrypt.calcMAC(SKac, msg);
    }

    public static Binary calcAC(AES SKac, Binary msg) {
        return EmvCrypt.calcMAC(SKac, msg);
    }

    public static Binary calcARPCMethod1(BlockCipher SKac, Binary ARQC, Binary ARC) {
        Ex.MUST(ARC.size() == 2, "Wrong ARC size");
        Ex.MUST(ARQC.size() == 8, "Wrong ARQC size");
        Binary Y = Binary.Bin(8);
        Y.set(0, ARC, 0, 2);
        Y.xor(ARQC);
        Y.resize(SKac.getBlockSize());
        SKac.encryptBlock(Y);
        return Y;
    }

    public static Binary calcARPCMethod2(BlockCipher SKac, Binary ARQC, Binary CSU, Binary proprietaryAuthData) {
        Ex.MUST(ARQC.size() == 8, "Wrong ARQC size");
        Ex.MUST(CSU.size() == 4, "Wrong CSU size");
        Binary Y = ARQC.clone();
        Y.add(CSU);
        if (proprietaryAuthData != null) {
            Ex.MUST(proprietaryAuthData.size() <= 8, "Wrong proprietaryAuthData size");
            Y.add(proprietaryAuthData);
        }
        if (SKac instanceof TripleDES) {
            return EmvCrypt.calcMAC((TripleDES)SKac, Y).first(4);
        }
        if (SKac instanceof AES) {
            return EmvCrypt.calcMAC((AES)SKac, Y).first(4);
        }
        throw new Ex("Wrong SKac algorithm");
    }

    public static Binary calcIssuerAuthData(BlockCipher SKac, Binary ARQC, Binary CSU, Binary proprietaryAuthData) {
        Binary res = EmvCrypt.calcARPCMethod2(SKac, ARQC, CSU, proprietaryAuthData);
        res.add(CSU);
        if (proprietaryAuthData != null) {
            res.add(proprietaryAuthData);
        }
        return res;
    }

    public static AES calcSKsmi(AES MKsmi, Binary ac) {
        Binary b = Binary.Bin(ac, Binary.Bin(8));
        MKsmi.encryptBlock(b);
        return new AES(b);
    }
}

