/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv;

import java.util.Arrays;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;
import org.denom.smartcard.emv.TagInfo;

public interface ITagDictionary {
    public TagInfo find(int var1);

    public TagInfo find(String var1);

    default public String BerTLVListToString(BerTLVList tlvs, int offset) {
        char[] offset_arr = new char[offset];
        Arrays.fill(offset_arr, ' ');
        StringBuilder res = new StringBuilder(300);
        int i = 0;
        while (i < tlvs.recs.size()) {
            TagInfo tagInfo;
            BerTLV rec = tlvs.recs.get(i);
            res.append(offset_arr);
            String tag = Integer.toHexString(rec.tag).toUpperCase();
            res.append(tag.length() % 2 == 0 ? tag : "0" + tag);
            if (!rec.isConstructed() && rec.value.size() > 8) {
                res.append(" [" + rec.value.size() + "]");
            }
            if ((tagInfo = this.find(rec.tag)) != null) {
                res.append(" -- " + tagInfo.name);
            }
            res.append(":\n");
            if (rec.isConstructed()) {
                res.append(this.BerTLVListToString(new BerTLVList(rec.value), offset + 4));
            } else {
                StringBuilder str = new StringBuilder(200);
                str.append(offset_arr);
                str.append("    ");
                str.append(rec.value.Hex(1, 8, 32, 0));
                int k = 0;
                while (k < str.length()) {
                    if (str.charAt(k) == '\n') {
                        str.insert(++k, offset_arr);
                        str.insert(k, "    ");
                    }
                    ++k;
                }
                res.append((CharSequence)str);
                res.append('\n');
            }
            ++i;
        }
        return res.toString();
    }
}

