/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.certificate;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.ec.ECAlg;
import org.denom.crypt.hash.SHA256;

public class CertificateEccNISTIssuer {
    public static final int ASI = 16;
    public int certFormat = 18;
    public int certEncoding = 0;
    public Binary issuerId;
    public int asi = 16;
    public Binary expirationDate;
    public Binary serialNumber;
    public Binary RID;
    public Binary caPKIndex;
    public Binary issuerPublicKeyX;
    public Binary signature;

    public CertificateEccNISTIssuer prepareToSign(Binary RID, Binary caPKIndex, Binary issuerId, int validYears, Binary serial, ECAlg issuerPublic) {
        Ex.MUST(issuerId.size() == 5 && serial.size() == 3 && RID.size() == 5 && caPKIndex.size() == 1, "Wrong params for Issuer Cert");
        this.certFormat = 18;
        this.certEncoding = 0;
        this.issuerId = issuerId.clone();
        this.asi = 16;
        String hex = ZonedDateTime.now(ZoneOffset.UTC).plusYears(validYears).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        this.expirationDate = Binary.Bin(hex);
        this.serialNumber = serial.clone();
        this.RID = RID.clone();
        this.caPKIndex = caPKIndex.clone();
        Binary pub = issuerPublic.getPublic(true);
        this.issuerPublicKeyX = pub.last(pub.size() - 1);
        return this;
    }

    public CertificateEccNISTIssuer fromBin(Binary cert) {
        this.certFormat = cert.get(0);
        this.certEncoding = cert.get(1);
        this.issuerId = cert.slice(2, 5);
        this.asi = cert.get(7);
        this.expirationDate = cert.slice(8, 4);
        this.serialNumber = cert.slice(12, 3);
        this.RID = cert.slice(15, 5);
        this.caPKIndex = cert.slice(20, 1);
        Ex.MUST(this.certFormat == 18 && this.certEncoding == 0 && this.asi == 16, "Unsupported Issuer ECC Cert format");
        int NField = 32;
        int offset = 21;
        this.issuerPublicKeyX = cert.slice(offset, NField);
        this.signature = cert.last(cert.size() - (offset += NField));
        return this;
    }

    public Binary formDataToSign() {
        Binary b = Binary.Bin();
        b.add(this.certFormat);
        b.add(this.certEncoding);
        b.add(this.issuerId);
        b.add(this.asi);
        b.add(this.expirationDate);
        b.add(this.serialNumber);
        b.add(this.RID);
        b.add(this.caPKIndex);
        b.add(this.issuerPublicKeyX);
        return b;
    }

    public Binary toBin() {
        Binary b = this.formDataToSign();
        b.add(this.signature);
        return b;
    }

    public boolean verifySignature(ECAlg caPublicKey) {
        Binary b = this.formDataToSign();
        return caPublicKey.verifyECSDSA_X(b, new SHA256(), this.signature);
    }

    public void sign(ECAlg caPrivateKey) {
        Binary b = this.formDataToSign();
        this.signature = caPrivateKey.signECSDSA_X(b, new SHA256());
    }
}

