/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.crypt.blockcipher.AES;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.crypt.ec.ECAlg;
import org.denom.crypt.ec.Fp.FpCurveAbstract;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;
import org.denom.smartcard.emv.kernel8.struct.TlvDatabase;

public final class Kernel8Crypt {
    public static Binary generateEccKey(ECAlg ecAlg) {
        Binary pub;
        FpCurveAbstract curve = (FpCurveAbstract)ecAlg.getCurve();
        int nSize = curve.getNField();
        BigInteger p = curve.getP();
        BigInteger p2 = p.add(BigInteger.ONE).divide(BigInteger.valueOf(2L));
        BigInteger y = null;
        do {
            ecAlg.generateKeyPair();
            pub = ecAlg.getPublic(false);
        } while ((y = new BigInteger(Binary.Bin(Binary.Bin(1), pub.last(nSize)).getBytes())).compareTo(p2) != -1);
        return pub.slice(1, nSize);
    }

    public static void restorePublicKey(ECAlg ecAlg, Binary publicKeyX) {
        int NField = ((FpCurveAbstract)ecAlg.getCurve()).getNField();
        ecAlg.setPublic(Binary.Bin(1, 2).add(publicKeyX));
        Binary key02 = ecAlg.getPublic(false);
        key02 = key02.last(NField);
        ecAlg.setPublic(Binary.Bin(1, 3).add(publicKeyX));
        Binary key03 = ecAlg.getPublic(false);
        key03 = key03.last(NField);
        if (key02.compareTo(key03) == -1) {
            ecAlg.setPublic(Binary.Bin(1, 2).add(publicKeyX));
        }
    }

    public static Binary BDHCalcPc(ECAlg Qc, Binary r) {
        ECAlg ecAlg = Qc.clone();
        ecAlg.setPrivate(r);
        Binary Pc = ecAlg.calcDH(Qc.getPublic(false));
        return Pc;
    }

    public static Binary BDHCalcZ(ECAlg Qk, Binary Dc, Binary r) {
        ECAlg ecAlg = Qk.clone();
        ecAlg.setPrivate(Dc);
        Binary p = Binary.Bin(1, 2).add(ecAlg.calcDH(Qk.getPublic(false)));
        ecAlg.setPrivate(r);
        Binary z = ecAlg.calcDH(p);
        return z;
    }

    public static Binary BDHCalcZ(ECAlg Dk, Binary Pc) {
        Binary PcPoint = Binary.Bin(1, 2).add(Pc);
        Binary z = Dk.calcDH(PcPoint);
        return z;
    }

    public static Binary BDHCalcKd(Binary z) {
        AES aes = new AES(Binary.Bin(16));
        Binary Kd = aes.calcCMAC(z, null);
        return Kd;
    }

    public static Binary BDHCalcSessionKey(Binary Kd, int b1) {
        AES aes = new AES(Kd);
        Binary b = Binary.Bin(1, b1).add("01 00 54334A325957773D A5A5A5 0180");
        aes.encryptBlock(b);
        return b;
    }

    public static Binary BDHCalcSKc(Binary Kd) {
        return Kernel8Crypt.BDHCalcSessionKey(Kd, 1);
    }

    public static Binary BDHCalcSKi(Binary Kd) {
        return Kernel8Crypt.BDHCalcSessionKey(Kd, 2);
    }

    public static Binary[] BDHCalcSessionKeys(ECAlg Dk, Binary Pc) {
        Binary z = Kernel8Crypt.BDHCalcZ(Dk, Pc);
        Binary Kd = Kernel8Crypt.BDHCalcKd(z);
        Binary SKc = Kernel8Crypt.BDHCalcSKc(Kd);
        Binary SKi = Kernel8Crypt.BDHCalcSKi(Kd);
        return new Binary[]{SKc, SKi};
    }

    public static boolean BDHValidate(ECAlg Qc, Binary r, Binary Pc) {
        ECAlg ec = Qc.clone();
        ec.setPrivate(r);
        Binary QcPoint = Qc.getPublic(false);
        Binary myPc = ec.calcDH(QcPoint);
        return Pc.equals(myPc);
    }

    public static Binary cryptCTR(BlockCipher SessionKey, int messageCounter, Binary data) {
        Ex.MUST(Int.isU16(messageCounter), "Wrong messageCounter for crypt CTR");
        Binary SV = Binary.Bin(SessionKey.getBlockSize());
        SV.setU16(0, messageCounter);
        return SessionKey.cryptCTR(data, SV);
    }

    public static Binary BDHRecoverR(BlockCipher SKc, Binary Er, int CMC) {
        return Kernel8Crypt.cryptCTR(SKc, CMC, Er);
    }

    public static Binary formSDAData(Binary sdaRecords, Binary extendedSDARelData, Binary aip) {
        return Binary.Bin().add(sdaRecords).add(extendedSDARelData).add(aip);
    }

    public static Binary getSdaRecords(Map<Binary, Binary> records, Arr<Binary> sdaRecIds) {
        Binary sdaRecords = Binary.Bin();
        for (Binary sdaRecId : sdaRecIds) {
            Binary record = records.get(sdaRecId);
            BerTLV rec = new BerTLV(record);
            Ex.MUST(rec.tag == 112, "Record body for SDA must be in tag 0x70");
            sdaRecords.add(rec.value);
        }
        return sdaRecords;
    }

    public static Binary createExtSDARelData(TlvDatabase tlvDB) {
        Binary res = Binary.Bin();
        if (!tlvDB.IsNotEmpty(10453258)) {
            return res;
        }
        Binary extTagList = tlvDB.GetValue(10453258);
        Arr<Integer> tags = BerTLV.parseTagList(extTagList);
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            int tag = (Integer)iterator.next();
            Binary val = tlvDB.GetValue(tag);
            if (val != null) {
                res.add(BerTLV.Tlv(tag, val));
                continue;
            }
            res.add(BerTLV.Tlv(tag, Binary.Bin()));
        }
        return res;
    }

    public static Binary calcAesCmacPlus(AES aes, Binary message) {
        Binary cmac = aes.calcCMAC(message, null);
        cmac = aes.decrypt(cmac, CryptoMode.CBC, AlignMode.NONE, cmac);
        return cmac;
    }

    public static Binary calcIADMac(AES aesSKi, Binary inputData) {
        Binary b = Binary.Bin(2).add(inputData);
        Binary cmac = Kernel8Crypt.calcAesCmacPlus(aesSKi, b);
        return cmac.first(8);
    }

    public static Binary formDataForIADMac(Binary PDOLValues, Binary CDOL1RelatedData, Binary terminalRREntropy, Binary lastERRDResponse, Binary genAcResponse, Binary sdaHash) {
        Binary data = Binary.Bin().reserve(300);
        data.add(PDOLValues);
        data.add(CDOL1RelatedData);
        if (terminalRREntropy != null && lastERRDResponse != null) {
            data.add(terminalRREntropy);
            data.add(lastERRDResponse);
        }
        ArrayList<BerTLV> tlvs = new BerTLVList((Binary)new BerTLV((Binary)genAcResponse).value).recs;
        for (BerTLV tlv : tlvs) {
            if (tlv.tag == 40742 || tlv.tag == 10453253) continue;
            data.add(tlv.toBin());
        }
        data.add(sdaHash);
        return data;
    }

    public static Binary calcEDAMac(AES SKi, Binary ac, Binary iadMac) {
        Binary data = Binary.Bin(2).add(ac).add(iadMac);
        Binary edaMac = SKi.calcCMAC(data, null).first(8);
        return edaMac;
    }

    public static Binary calcMac(BlockCipher alg, int messageCounter, Binary data) {
        Ex.MUST(Int.isU16(messageCounter), "Wrong messageCounter for calcMac");
        Binary b = Binary.Bin().addU16(messageCounter).add(data);
        return alg.calcCMAC(b, null).first(8);
    }

    public static Binary encryptReadData(BlockCipher SKc, BlockCipher SKi, int CMC, Binary plainTlv) {
        Binary encryptedTLV = Kernel8Crypt.cryptCTR(SKc, CMC, plainTlv);
        Binary mac = Kernel8Crypt.calcMac(SKi, CMC, encryptedTLV);
        return encryptedTLV.add(mac);
    }

    public static Binary decryptReadData(BlockCipher SKc, BlockCipher SKi, int CMC, Binary crypt) {
        if (crypt.size() < 8) {
            return null;
        }
        Binary cardMac = crypt.last(8);
        Binary encryptedTLV = crypt.first(crypt.size() - 8);
        Binary myMac = Kernel8Crypt.calcMac(SKi, CMC, encryptedTLV);
        if (!myMac.equals(cardMac)) {
            return null;
        }
        Binary plainTLV = Kernel8Crypt.cryptCTR(SKc, CMC, encryptedTLV);
        return plainTLV;
    }

    public static Binary cryptWriteData(BlockCipher SKc, int KMC, Binary plainTlv) {
        return Kernel8Crypt.cryptCTR(SKc, KMC, plainTlv);
    }

    public static Binary calcDataEnvelopeMac(BlockCipher SKi, int CMC, Binary plainTlv) {
        return Kernel8Crypt.calcMac(SKi, CMC, plainTlv);
    }
}

