/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.AES;
import org.denom.crypt.ec.ECAlg;
import org.denom.crypt.ec.Fp.custom.Secp256r1;
import org.denom.crypt.hash.SHA256;
import org.denom.format.BerTLV;
import org.denom.smartcard.emv.certificate.CertificateEccNISTIcc;
import org.denom.smartcard.emv.certificate.CertificateEccNISTIssuer;
import org.denom.smartcard.emv.kernel8.IKernel8Crypter;
import org.denom.smartcard.emv.kernel8.Kernel8Crypt;

public class Kernel8CrypterNIST
implements IKernel8Crypter {
    public static int ASI = 0;
    public static int ECNField = 32;
    public static Binary kernelQualifier = Binary.Bin("02 80 00 10 FF FF 00 00");
    private SHA256 hashAlg = new SHA256();
    private ECAlg ecAlg = new ECAlg(new Secp256r1(), new Random(System.nanoTime()));
    private ECAlg ecDk = this.ecAlg.clone();
    private final Binary Pc = Binary.Bin();
    private final Binary rRecovered = Binary.Bin();
    private Binary sdaHash = Binary.Bin();
    private final AES SKc = new AES();
    private final AES SKi = new AES();
    private int CMC = 32768;
    private int KMC = 0;

    @Override
    public int getASI() {
        return ASI;
    }

    @Override
    public Binary getKernelQualifier() {
        return kernelQualifier.clone();
    }

    @Override
    public void resetSession() {
        this.Pc.clear();
        this.rRecovered.clear();
        this.sdaHash.clear();
        this.SKc.setKey(Binary.Bin(16));
        this.SKi.setKey(Binary.Bin(16));
        this.CMC = 32768;
        this.KMC = 0;
    }

    @Override
    public Binary getKernelKeyData() {
        this.ecDk.generateKeyPair();
        Binary Qk = this.ecDk.getPublic(false);
        return Qk.last(Qk.size() - 1);
    }

    @Override
    public boolean processCardKeyData(Binary cardKeyData) {
        if (cardKeyData.size() != ECNField * 2) {
            return false;
        }
        try {
            this.Pc.assign(cardKeyData, 0, ECNField);
            Binary[] SKcSKi = Kernel8Crypt.BDHCalcSessionKeys(this.ecDk, this.Pc);
            this.SKc.setKey(SKcSKi[0]);
            this.SKi.setKey(SKcSKi[1]);
            Binary encryptedR = cardKeyData.last(ECNField);
            this.rRecovered.assign(Kernel8Crypt.BDHRecoverR(this.SKc, encryptedR, this.CMC));
            ++this.CMC;
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }

    private boolean processIssuerCertificate(Binary caPKIndex, Binary issuerCertBin, Binary aid, Binary pan) {
        try {
            CertificateEccNISTIssuer issuerCert = new CertificateEccNISTIssuer().fromBin(issuerCertBin);
            String panStr = pan.Hex(0);
            String issuerIdStr = issuerCert.issuerId.Hex(0);
            int lenIId = issuerIdStr.indexOf(70);
            if (lenIId == -1) {
                lenIId = issuerIdStr.length();
            }
            if (!(panStr = panStr.substring(0, lenIId)).equals(issuerIdStr = issuerIdStr.substring(0, lenIId))) {
            }
            Binary now = Binary.Bin(ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            if (issuerCert.expirationDate.compareTo(now) < 0) {
            }
            if (!issuerCert.RID.equals(aid.first(5))) {
            }
            if (!issuerCert.caPKIndex.equals(caPKIndex)) {
            }
            if (!issuerCert.verifySignature(this.ecAlg)) {
            }
            Kernel8Crypt.restorePublicKey(this.ecAlg, issuerCert.issuerPublicKeyX);
            return true;
        }
        finally {
            return false;
        }
    }

    private boolean processICCCertificate(Binary iccCertBin, Binary sdaHash) {
        try {
            CertificateEccNISTIcc iccCert = new CertificateEccNISTIcc().fromBin(iccCertBin);
            Binary now = Binary.Bin(ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
            Binary dateTime = Binary.Bin(iccCert.expirationDate, iccCert.expirationTime);
            if (dateTime.compareTo(now) < 0) {
            }
            if (!sdaHash.equals(iccCert.iccdHash)) {
            }
            if (!iccCert.verifySignature(this.ecAlg)) {
            }
            this.ecAlg.setPublic(Binary.Bin("02").add(iccCert.iccPublicKeyX));
        }
        finally {
            return false;
        }
        return true;
    }

    @Override
    public void calcSdaHash(Binary sdaData) {
        this.sdaHash = this.hashAlg.calc(sdaData);
    }

    @Override
    public boolean processCertificates(Binary caPKIndex, Binary caPublicKey, Binary issuerCert, Binary iccCert, Binary aid, Binary pan) {
        this.ecAlg.setPublic(caPublicKey);
        boolean isOk = this.processIssuerCertificate(caPKIndex, issuerCert, aid, pan);
        if (!isOk) {
            return false;
        }
        isOk = this.processICCCertificate(iccCert, this.sdaHash);
        if (!isOk) {
            return false;
        }
        return Kernel8Crypt.BDHValidate(this.ecAlg, this.rRecovered, this.Pc);
    }

    @Override
    public Binary calcIADMac(Binary PDOLValues, Binary CDOL1RelatedData, Binary terminalRREntropy, Binary lastERRDResponse, Binary genAcResponse) {
        Binary data = Kernel8Crypt.formDataForIADMac(PDOLValues, CDOL1RelatedData, terminalRREntropy, lastERRDResponse, genAcResponse, this.sdaHash);
        return Kernel8Crypt.calcIADMac(this.SKi, data);
    }

    @Override
    public Binary calcEDAMac(Binary IADMac, Binary cardAC) {
        return Kernel8Crypt.calcEDAMac(this.SKi, cardAC, IADMac);
    }

    @Override
    public Binary decryptRecord(Binary rec) {
        BerTLV tlv = new BerTLV(rec);
        if (tlv.tag == 112) {
            return rec.clone();
        }
        Ex.MUST(tlv.tag == 218, "Wrong tag in record");
        Binary plain = Kernel8Crypt.cryptCTR(this.SKc, this.CMC++, tlv.value);
        Binary res = BerTLV.Tlv(112, plain);
        return res;
    }

    @Override
    public Binary cryptWriteData(Binary plainTlv) {
        return Kernel8Crypt.cryptCTR(this.SKc, this.KMC++, plainTlv);
    }

    @Override
    public Binary calcDataEnvelopeMac(Binary plainTlv) {
        return Kernel8Crypt.calcMac(this.SKi, this.CMC++, plainTlv);
    }

    @Override
    public Binary decryptReadData(Binary crypt) {
        return Kernel8Crypt.decryptReadData(this.SKc, this.SKi, this.CMC++, crypt);
    }
}

