/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8;

import java.util.LinkedHashMap;
import java.util.Map;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.BerTLV;
import org.denom.log.ILog;
import org.denom.log.LogDummy;
import org.denom.smartcard.ApduIso;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.emv.ApduEmv;
import org.denom.smartcard.emv.EmvUtil;
import org.denom.smartcard.emv.kernel8.IKernel8Crypter;
import org.denom.smartcard.emv.kernel8.Kernel8Crypt;
import org.denom.smartcard.emv.kernel8.struct.TagDictKernel8;
import org.denom.smartcard.emv.kernel8.struct.TlvDatabase;

public class TerminalK8 {
    public CardReader cr = null;
    public ILog log = new LogDummy();
    public Binary appAid = Binary.Bin();
    public Map<Binary, Binary> caPublicKeys = new LinkedHashMap<Binary, Binary>();
    public TlvDatabase tlvDB;
    public IKernel8Crypter crypter;
    public Binary aip = Binary.Bin();
    public Binary pdolValues = Binary.Bin();
    public Binary IadMac;
    public Binary sdaRecords = Binary.Bin();
    public Binary lastERRDResponse;
    private final String thisClassName = TerminalK8.class.getName();

    public TerminalK8() {
    }

    public TerminalK8(CardReader cr, Binary aid, IKernel8Crypter crypter) {
        this.cr = cr;
        this.appAid = aid.clone();
        this.crypter = crypter;
    }

    public void resetSession() {
        this.tlvDB = new TlvDatabase(new TagDictKernel8());
        this.aip.clear();
        this.pdolValues.clear();
        this.sdaRecords = Binary.Bin();
        this.lastERRDResponse = null;
        this.IadMac = Binary.Bin();
        this.crypter.resetSession();
    }

    public TerminalK8 setReader(CardReader reader) {
        this.cr = reader;
        this.resetSession();
        return this;
    }

    public TerminalK8 setAID(Binary aid) {
        this.appAid = aid.clone();
        this.resetSession();
        return this;
    }

    public TerminalK8 setLog(ILog log) {
        this.log = log;
        return this;
    }

    public void addCAPublicKey(Binary caPKIndex, Binary caPublicKey) {
        this.caPublicKeys.put(caPKIndex, caPublicKey);
    }

    public Binary getVal(int tag) {
        return this.tlvDB.GetValue(tag);
    }

    private void processFCI(Binary fci) {
        Ex.MUST(BerTLV.isTLV(fci), "Not TLV in response on SELECT");
        BerTLV tlv = new BerTLV(fci);
        Ex.MUST(tlv.tag == 111, "Not FCI on Select");
        this.tlvDB.store(tlv);
        Ex.MUST(this.tlvDB.ParseAndStoreCardResponse(fci, false), "Wrong FCI");
    }

    public Binary select() {
        this.cr.Cmd(ApduIso.SelectAID(this.appAid), 3);
        Ex.MUST(this.cr.rapdu.isOk() || this.cr.rapdu.sw1() == 98 || this.cr.rapdu.sw1() == 99, "Can't select card application, status: " + Binary.Num_Bin(this.cr.rapdu.status, 2).Hex());
        this.resetSession();
        this.processFCI(this.cr.resp);
        return this.cr.resp.clone();
    }

    public void getProcessingOptions() {
        Binary fci = this.tlvDB.GetTLV(111);
        this.resetSession();
        if (!fci.empty()) {
            this.processFCI(fci);
        }
        this.tlvDB.store(149, Binary.Bin(5));
        this.tlvDB.store(40759, Binary.Bin().random(4));
        Binary cardQualifier = this.tlvDB.GetValue(40748);
        Ex.MUST(cardQualifier != null, "CardQualifier absent");
        Ex.MUST(this.crypter.isASISupported(cardQualifier), "ASI not supported");
        this.tlvDB.store(158, this.crypter.getKernelKeyData());
        this.tlvDB.store(40747, this.crypter.getKernelQualifier());
        if (this.tlvDB.IsNotEmpty(40760)) {
            this.pdolValues = this.tlvDB.formDOLValues(this.tlvDB.GetValue(40760));
        }
        this.Cmd(ApduEmv.GetProcessingOptions(this.pdolValues));
        BerTLV tlvResp = new BerTLV(this.cr.resp);
        Ex.MUST(tlvResp.tag == 119, "Wrong TLV in GPO response");
        Ex.MUST(this.tlvDB.ParseAndStoreCardResponse(this.cr.resp, false), "Wrong GPO Response");
        Binary cardKeyData = this.tlvDB.GetValue(10453251);
        Ex.MUST(this.crypter.processCardKeyData(cardKeyData), "Wrong GPO Response");
        this.aip = this.tlvDB.GetValue(130);
    }

    public Binary exchangeRRData() {
        this.Cmd(ApduEmv.ExchangeRelayResistanceData(this.tlvDB.GetValue(40759)));
        BerTLV tlv = new BerTLV(this.cr.resp);
        Ex.MUST(tlv.tag == 128 && tlv.value.size() == 10, "Wrong response on ExchangeRelayResistanceData");
        this.lastERRDResponse = tlv.value;
        return tlv.value;
    }

    public void readAFLRecords() {
        Binary afl = this.tlvDB.GetValue(148);
        Arr<Binary> sdaRecIds = new Arr<Binary>();
        Map<Binary, Binary> records = EmvUtil.readAflRecords(this.cr, EmvUtil.parseAFL(afl, sdaRecIds));
        for (Binary rec : records.values()) {
            rec.assign(this.crypter.decryptRecord(rec));
            this.tlvDB.ParseAndStoreCardResponse(rec, false);
        }
        this.sdaRecords = Kernel8Crypt.getSdaRecords(records, sdaRecIds);
    }

    public Binary getData(int tag) {
        this.cr.Cmd(ApduEmv.GetData(tag));
        return this.cr.resp.clone();
    }

    public Binary readLog(int sfi, int recordId) {
        this.Cmd(ApduIso.ReadRecord(sfi, recordId));
        return this.cr.resp.clone();
    }

    public Binary readRecord(int sfi, int recordId) {
        this.Cmd(ApduIso.ReadRecord(sfi, recordId));
        return this.crypter.decryptRecord(this.cr.resp);
    }

    private void processCertificates() {
        Binary b = this.tlvDB.GetValue(143);
        Ex.MUST(b != null, "CA PK Index absent on card");
        Binary caPublicKey = this.caPublicKeys.get(b);
        Ex.MUST(caPublicKey != null, "Unknown CA Key");
        Binary issuerCertBin = this.tlvDB.GetValue(144);
        Ex.MUST(issuerCertBin != null, "Issuer Public Key Cert absent on card");
        Binary iccCertBin = this.tlvDB.GetValue(40774);
        Ex.MUST(iccCertBin != null, "ICC Public Key Cert absent on card");
        Binary aid = this.tlvDB.GetValue(132);
        Binary pan = this.tlvDB.GetValue(90);
        Ex.MUST(this.crypter.processCertificates(b, caPublicKey, issuerCertBin, iccCertBin, aid, pan), "Local authentication failed");
    }

    private void processIadMac(Binary genACResponse, Binary cdolRelData) {
        Binary terminalRREntropy = null;
        if (this.lastERRDResponse != null) {
            terminalRREntropy = this.tlvDB.GetValue(40759);
        }
        this.IadMac = this.crypter.calcIADMac(this.pdolValues, cdolRelData, terminalRREntropy, this.lastERRDResponse, genACResponse);
        this.tlvDB.store(10453257, this.IadMac);
        Binary iad = this.tlvDB.GetRef(40720);
        int copyIadMac = (this.aip.get(1) & 6) >> 1;
        if (copyIadMac == 2) {
            Binary val = this.tlvDB.GetValue(10453255);
            if (!this.tlvDB.IsNotEmpty(10453255) || val.asU16() + 8 > iad.size()) {
                throw new Ex("Wrong IAD-MAC Offset");
            }
            iad.set(val.asU16(), this.IadMac, 0, this.IadMac.size());
        }
    }

    public Binary generateAC(int cryptType, TlvDatabase params, boolean moreCommands) {
        this.tlvDB.append(params);
        Binary cdolRelData = this.tlvDB.formDOLValues(this.tlvDB.GetValue(140));
        this.crypter.calcSdaHash(Kernel8Crypt.formSDAData(this.sdaRecords, Kernel8Crypt.createExtSDARelData(this.tlvDB), this.aip));
        this.processCertificates();
        this.Cmd(ApduEmv.GenerateAC(cryptType, cdolRelData, moreCommands));
        BerTLV tlv77 = new BerTLV(this.cr.resp);
        Ex.MUST(tlv77.tag == 119, "Wrong Tag in GENERATE AC Response");
        Ex.MUST(this.tlvDB.ParseAndStoreCardResponse(this.cr.resp, false), "Wrong GENERATE AC Response");
        this.processIadMac(this.cr.resp, cdolRelData);
        Binary cardAC = this.tlvDB.GetValue(40742);
        Ex.MUST(cardAC != null, "Card AC absent");
        Binary cardEdaMac = this.tlvDB.GetValue(10453253);
        Ex.MUST(cardEdaMac != null, "Card EDA-MAC absent");
        Binary myEdaMac = this.crypter.calcEDAMac(this.IadMac, cardAC);
        Ex.MUST(myEdaMac.equals(cardEdaMac), "Wrong card EDA-MAC");
        if (this.tlvDB.IsNotEmpty(10453252)) {
            Binary cardTvr = this.tlvDB.GetValue(10453252);
            this.tlvDB.store(149, cardTvr);
        }
        return this.cr.resp.clone();
    }

    public Binary ReadData(int tag) {
        this.Cmd(ApduEmv.ReadData(tag));
        return this.crypter.decryptReadData(this.cr.resp);
    }

    public void WriteData(Binary plainTlv, boolean moreCommands) {
        Binary encryptedTlv = this.crypter.cryptWriteData(plainTlv);
        this.Cmd(ApduEmv.WriteData(encryptedTlv, moreCommands));
        Binary myMac = this.crypter.calcDataEnvelopeMac(plainTlv);
        Ex.MUST(myMac.equals(this.cr.resp), "Wrong card MAC");
    }

    private void Cmd(CApdu capdu) {
        this.cr.callerClassName = this.thisClassName;
        this.cr.Cmd(capdu, 1);
    }
}

