/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;
import org.denom.format.JSONArray;
import org.denom.format.JSONObject;
import org.denom.log.ILog;
import org.denom.smartcard.ApduIso;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.RApdu;
import org.denom.smartcard.emv.ApduEmv;
import org.denom.smartcard.emv.EmvUtil;
import org.denom.smartcard.emv.TagInfo;
import org.denom.smartcard.emv.kernel8.IKernel8Crypter;
import org.denom.smartcard.emv.kernel8.Kernel8Crypt;
import org.denom.smartcard.emv.kernel8.struct.ErrorIndication;
import org.denom.smartcard.emv.kernel8.struct.OUT;
import org.denom.smartcard.emv.kernel8.struct.OutcomeParameterSet;
import org.denom.smartcard.emv.kernel8.struct.TagDictKernel8;
import org.denom.smartcard.emv.kernel8.struct.TlvDatabase;
import org.denom.smartcard.emv.kernel8.struct.UIRD;

public class TerminalKernel8 {
    private static final int COLOR_KERNEL8 = -11364866;
    public CardReader cr;
    public ILog log;
    private Random algRandom;
    private Map<Binary, Binary> caPublicKeys = new LinkedHashMap<Binary, Binary>();
    private TagDictKernel8 dict = new TagDictKernel8();
    private TlvDatabase config;
    private boolean sessionStarted = false;
    public TlvDatabase tlvDB;
    private OutcomeParameterSet outcomeParameterSet = new OutcomeParameterSet();
    private UIRD uird1 = new UIRD();
    private UIRD uird2 = new UIRD();
    private ErrorIndication errorIndication = new ErrorIndication();
    private int rrpCounter;
    private static final int KERNEL_DECISION_DECLINE = 0;
    private static final int KERNEL_DECISION_ACCEPT = 64;
    private static final int KERNEL_DECISION_ONLINE = 128;
    private int kernelDecision;
    private Binary aip;
    private Binary signedRecords;
    private Binary pdolValues;
    private Binary cdolRelData;
    private Binary lastERRDResponse;
    private Binary iadMac;
    private List<IKernel8Crypter> crypters;
    IKernel8Crypter curCrypter;

    public TerminalKernel8(JSONObject joTerminalConfig, CardReader cr, ILog log, Random rand, List<IKernel8Crypter> crypters) {
        Ex.MUST(cr != null && log != null && joTerminalConfig != null, "Null params for POS Terminal");
        this.cr = cr;
        this.log = log;
        this.algRandom = rand;
        this.crypters = crypters;
        Ex.MUST(crypters.size() > 0, "Crypter for terminal not set");
        this.setConfig(joTerminalConfig);
    }

    public TerminalKernel8 setReader(CardReader cr) {
        this.cr = cr;
        return this;
    }

    public TerminalKernel8 setLog(ILog log) {
        this.log = log;
        return this;
    }

    public void setConfig(JSONObject jo) {
        this.config = new TlvDatabase(new TagDictKernel8());
        JSONObject joParams = jo.getJSONObject("Parameters");
        Iterator<String> keys = joParams.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Binary val = joParams.getBinary(key);
            TagInfo tagInfo = this.dict.find(key);
            if (tagInfo == null) {
                Ex.THROW("Unknown POS terminal param: " + key);
                continue;
            }
            Ex.MUST(tagInfo.isGoodLen(val), "Wrong length: " + key);
            this.config.store(tagInfo.tag, val);
        }
        JSONArray jaCAKeys = jo.optJSONArray("CA Keys");
        if (jaCAKeys == null) {
            return;
        }
        int i = 0;
        while (i < jaCAKeys.length()) {
            JSONObject joCAKey = jaCAKeys.getJSONObject(i);
            Binary caPKIndex = joCAKey.getBinary("CA PK Index");
            Binary caPublicKey = joCAKey.getBinary("CA Public Key");
            this.addCAPublicKey(caPKIndex, caPublicKey);
            ++i;
        }
    }

    public void addCAPublicKey(Binary caPKIndex, Binary caPublicKey) {
        this.caPublicKeys.put(caPKIndex, caPublicKey);
    }

    private void checkParamPresent(int tag) {
        if (!this.tlvDB.IsPresent(tag)) {
            Ex.THROW("Tag " + Binary.Num_Bin(tag, 0).Hex() + " (" + this.dict.find((int)tag).name + ") is absent in POS terminal parameters");
        }
    }

    private void checkMandatoryParams() {
        this.checkParamPresent(40768);
        this.checkParamPresent(40710);
        this.checkParamPresent(40713);
        this.checkParamPresent(10453510);
        this.checkParamPresent(10453511);
        this.checkParamPresent(10453512);
        this.checkParamPresent(10453534);
        this.checkParamPresent(10453535);
        this.checkParamPresent(10453522);
        this.checkParamPresent(10453513);
        this.checkParamPresent(10453530);
        this.checkParamPresent(10453524);
        this.checkParamPresent(10453521);
        this.checkParamPresent(10453533);
        this.checkParamPresent(10453523);
        this.checkParamPresent(10453517);
        this.checkParamPresent(10453518);
        this.checkParamPresent(10453527);
        this.checkParamPresent(10453528);
        this.checkParamPresent(10453514);
        this.checkParamPresent(10453515);
        this.checkParamPresent(10453516);
        this.checkParamPresent(40730);
        this.checkParamPresent(10453525);
        this.checkParamPresent(10453526);
        this.checkParamPresent(40733);
        this.checkParamPresent(40757);
        this.checkParamPresent(10453519);
        this.checkParamPresent(156);
    }

    private OUT createOUT(boolean isDataRecord, UIRD uird1, UIRD uird2) {
        this.tlvDB.store(10453508, this.errorIndication.toBin());
        return new OUT(this.tlvDB, this.outcomeParameterSet, isDataRecord, uird1, uird2);
    }

    private OUT createOUT(UIRD uird1) {
        return this.createOUT(false, uird1, null);
    }

    private void kernel8Start(TlvDatabase termParamsForSession) {
        this.tlvDB = this.config.clone();
        this.tlvDB.append(termParamsForSession);
        this.outcomeParameterSet = new OutcomeParameterSet();
        this.outcomeParameterSet.onInitKernel8();
        this.uird1 = new UIRD();
        this.uird2 = new UIRD();
        this.errorIndication = new ErrorIndication();
        this.errorIndication.msgOnError = 28;
        this.checkMandatoryParams();
        this.uird1.holdTime = this.tlvDB.GetValue(10453521);
        this.tlvDB.GetRef(40733).and(Binary.Bin("93 7F FF FF  FF FF FF FF"));
    }

    private Binary selectApplication() {
        Binary appAid = this.tlvDB.GetValue(40710);
        this.cr.Cmd(ApduIso.SelectAID(appAid), 3);
        Ex.MUST(this.cr.rapdu.isOk() || this.cr.rapdu.sw1() == 98 || this.cr.rapdu.sw1() == 99, "Can't select card application, status: " + Binary.Num_Bin(this.cr.rapdu.status, 2).Hex());
        this.log.writeln(-11364866, "Select: " + appAid.Hex());
        return this.cr.resp;
    }

    private boolean parseFCITemplate(Binary fci) {
        if (!BerTLV.isTLV(fci)) {
            return false;
        }
        BerTLV tlv = new BerTLV(fci);
        if (tlv.tag != 111) {
            return false;
        }
        this.tlvDB.store(tlv);
        return this.tlvDB.ParseAndStoreCardResponse(fci, false);
    }

    private void setTVRBit(long bit) {
        long tvr = this.tlvDB.GetRef(149).asNum();
        this.tlvDB.store(149, Binary.Num_Bin(tvr |= bit, 5));
    }

    private void setTRMDBit(long bit) {
        long tvr = this.tlvDB.GetRef(40733).asNum();
        this.tlvDB.store(40733, Binary.Num_Bin(tvr |= bit, 8));
    }

    private void processC_Init(Binary cardQualifier) {
        this.curCrypter = null;
        int i = 0;
        while (i < this.crypters.size()) {
            IKernel8Crypter crypter = this.crypters.get(i);
            if (crypter.isASISupported(cardQualifier)) {
                this.curCrypter = crypter;
                break;
            }
            ++i;
        }
        if (this.curCrypter == null) {
            this.errorIndication.L2 = 6;
            this.uird1.messageId = 28;
            this.uird1.status = 0;
            this.outcomeParameterSet.setStatus(64);
            this.outcomeParameterSet.setStart(240);
            this.outcomeParameterSet.setB5Bit(7);
            throw this.createOUT(this.uird1);
        }
        this.curCrypter.resetSession();
        this.signedRecords = Binary.Bin();
        this.tlvDB.store(40747, this.curCrypter.getKernelQualifier());
        this.tlvDB.store(158, this.curCrypter.getKernelKeyData());
    }

    private void initOnSelectApp(Binary fci) {
        boolean ok = this.parseFCITemplate(fci);
        if (!ok) {
            this.errorIndication.L2 = 4;
            this.errorIndication.msgOnError = 255;
        }
        if (!(!ok || this.tlvDB.IsNotEmpty(132) && this.tlvDB.IsNotEmpty(40748) && this.tlvDB.GetValue(40748).get(0) != 0)) {
            this.errorIndication.L2 = 1;
            this.errorIndication.msgOnError = 255;
            ok = false;
        }
        if (!ok) {
            this.outcomeParameterSet.setStatus(80);
            this.outcomeParameterSet.setStart(32);
            throw this.createOUT(null);
        }
        if (this.tlvDB.IsNotEmpty(24365)) {
            Binary langPref = this.tlvDB.GetValue(24365);
            langPref.resize(8);
            this.uird1.languagePref = langPref;
            this.uird2.languagePref = langPref.clone();
        }
        if ((this.tlvDB.GetValue(40748).get(4) & 0x80) != 0) {
            this.outcomeParameterSet.setFieldOffRequest(this.tlvDB.GetValue(10453522).get(0));
        }
        this.tlvDB.store(40756, Binary.Bin("000000"));
        this.kernelDecision = 64;
        Binary tvr = Binary.Bin(5);
        this.tlvDB.store(149, tvr);
        this.setTVRBit(128L);
        Binary terminalCapabilities = Binary.Bin(3);
        terminalCapabilities.set(0, this.tlvDB.GetValue(10453510).get(0));
        terminalCapabilities.set(2, this.tlvDB.GetValue(10453514).get(0));
        this.tlvDB.store(40755, terminalCapabilities);
        this.rrpCounter = 0;
        this.tlvDB.store(10453260, Binary.Bin("0000"));
        Binary unpredictableNumber = Binary.Bin().random(this.algRandom, 4);
        this.tlvDB.store(40759, unpredictableNumber);
        this.tlvDB.store(10453532, Binary.Bin("80"));
        this.tlvDB.store(10453531, Binary.Bin("00"));
        boolean isRSAEnabled = this.tlvDB.GetValue(10453513).getBit(0, 5);
        if (isRSAEnabled) {
            this.outcomeParameterSet.setStatus(64);
            this.errorIndication.L2 = 15;
            throw this.createOUT(null);
        }
        this.processC_Init(this.tlvDB.GetValue(40748));
    }

    private void S202122232425_E() {
        this.uird1.messageId = 28;
        this.uird1.status = 0;
        this.outcomeParameterSet.setStatus(64);
        this.outcomeParameterSet.setB5Bit(7);
        this.outcomeParameterSet.setStart(240);
        throw this.createOUT(this.uird1);
    }

    private void parsingError() {
        this.errorIndication.L2 = 4;
        this.S202122232425_E();
    }

    private void statusError(int status) {
        this.errorIndication.L2 = 3;
        this.errorIndication.SW12 = status;
        this.S202122232425_E();
    }

    private void getProcessingOptions() {
        this.pdolValues = this.tlvDB.IsNotEmpty(40760) ? this.tlvDB.formDOLValues(this.tlvDB.GetValue(40760)) : Binary.Bin();
        this.cr.Cmd(ApduEmv.GetProcessingOptions(this.pdolValues), 3);
        this.log.writeln(-11364866, "Get Processing Options (SC ASI = " + Binary.Bin(1, this.curCrypter.getASI()).Hex() + ")");
        if (this.cr.rapdu.status != 36864) {
            this.errorIndication.L2 = 3;
            this.errorIndication.SW12 = this.cr.rapdu.status;
            this.errorIndication.msgOnError = 255;
            this.outcomeParameterSet.setFieldOffRequest(255);
            this.outcomeParameterSet.setStatus(80);
            this.outcomeParameterSet.setStart(32);
            throw this.createOUT(null);
        }
        Binary gpoResp = this.cr.resp;
        boolean parseOk = this.tlvDB.ParseAndStoreCardResponse(gpoResp, false);
        if (gpoResp.size() < 2 || gpoResp.get(0) != 119 || !parseOk) {
            this.parsingError();
        }
        boolean ok = this.tlvDB.IsNotEmpty(148);
        ok &= this.tlvDB.IsNotEmpty(130);
        ok &= this.tlvDB.IsNotEmpty(10453251);
        if (!(ok &= this.tlvDB.IsNotEmpty(140) || this.tlvDB.IsNotEmpty(10453536))) {
            this.errorIndication.L2 = 1;
            this.S202122232425_E();
        }
        if (!this.tlvDB.IsNotEmpty(140)) {
            this.tlvDB.store(140, this.tlvDB.GetValue(10453536));
        }
        if (!(ok = this.curCrypter.processCardKeyData(this.tlvDB.GetValue(10453251)))) {
            this.errorIndication.L2 = 16;
            this.S202122232425_E();
        }
    }

    private void performRRP() {
        Binary terminalEntropy = this.tlvDB.GetValue(40759);
        this.cr.Cmd(ApduEmv.ExchangeRelayResistanceData(terminalEntropy), 3);
        long diffTimeMicros = this.cr.cmdTime * 1000L;
        if (this.cr.rapdu.status != 36864) {
            this.statusError(this.cr.rapdu.status);
        }
        if (this.cr.resp.size() < 12 || this.cr.resp.getU16(0) != 32778) {
            this.parsingError();
        }
        this.lastERRDResponse = this.cr.resp.slice(2, 10);
        int minTimeForProcessingRRApdu = this.lastERRDResponse.slice(4, 2).asU16();
        int maxTimeForProcessingRRApdu = this.lastERRDResponse.slice(6, 2).asU16();
        int deviceEstimatedTransmissionTimeForRRRapdu = this.lastERRDResponse.slice(8, 2).asU16();
        int tCmd = (int)Math.min(diffTimeMicros / 100L, 65535L);
        int tCApdu = this.tlvDB.GetValue(10453525).asU16();
        int terminalExpectedRRapdu = this.tlvDB.GetValue(10453526).asU16();
        int tRapdu = Math.min(deviceEstimatedTransmissionTimeForRRRapdu, terminalExpectedRRapdu);
        int measuredRRProcessingTime = Math.max(0, tCmd - tCApdu - tRapdu);
        int RRTimeExcess = Math.max(0, measuredRRProcessingTime - maxTimeForProcessingRRApdu);
        this.tlvDB.store(10453260, Binary.Bin().addU16(RRTimeExcess));
        int minRRGracePeriod = this.tlvDB.GetValue(10453523).asU16();
        if (measuredRRProcessingTime < Math.max(0, minTimeForProcessingRRApdu - minRRGracePeriod)) {
            this.errorIndication.L2 = 6;
            this.S202122232425_E();
        }
        int maxRRGracePeriod = this.tlvDB.GetValue(10453524).asU16();
        boolean again = this.rrpCounter < 2;
        if (again &= measuredRRProcessingTime > maxTimeForProcessingRRApdu + maxRRGracePeriod) {
            ++this.rrpCounter;
            this.performRRP();
        } else {
            boolean rrpOk = true;
            if (measuredRRProcessingTime > maxTimeForProcessingRRApdu + maxRRGracePeriod) {
                this.setTVRBit(4L);
                rrpOk = false;
            }
            boolean exceeded = deviceEstimatedTransmissionTimeForRRRapdu != 0 && terminalExpectedRRapdu != 0;
            int RRTransmissionThreshold = this.tlvDB.GetValue(10453528).asU16();
            boolean f1 = deviceEstimatedTransmissionTimeForRRRapdu * 100 / terminalExpectedRRapdu < RRTransmissionThreshold;
            boolean f2 = terminalExpectedRRapdu * 100 / deviceEstimatedTransmissionTimeForRRRapdu < RRTransmissionThreshold;
            int RRAccuracyThreshold = this.tlvDB.GetValue(10453527).asU16();
            boolean f3 = Math.max(0, measuredRRProcessingTime - minTimeForProcessingRRApdu) > RRAccuracyThreshold;
            if (exceeded &= f1 || f2 || f3) {
                this.setTVRBit(8L);
                rrpOk = false;
            }
            this.setTVRBit(2L);
            this.log.writeln(-11364866, "RRP done (" + (rrpOk ? "OK" : "Failed") + ")");
        }
    }

    private Map<Binary, Binary> readRecords(Arr<Binary> recIds) {
        TreeMap<Binary, Binary> records = new TreeMap<Binary, Binary>();
        for (Binary recId : recIds) {
            this.cr.Cmd(ApduIso.ReadRecord(recId.get(0), recId.get(1)), 3);
            if (this.cr.rapdu.status != 36864) {
                this.statusError(this.cr.rapdu.status);
            }
            records.put(recId, this.cr.resp);
        }
        return records;
    }

    private Binary decryptRecord(Binary rec) {
        BerTLV tlv = new BerTLV(rec);
        if (tlv.tag == 112) {
            return rec.clone();
        }
        if (tlv.tag != 218) {
            this.parsingError();
        }
        return this.curCrypter.decryptRecord(rec);
    }

    private void processAFL() {
        Binary afl = this.tlvDB.GetValue(148);
        Arr<Binary> sdaRecIds = new Arr<Binary>();
        Arr<Binary> recIds = null;
        try {
            recIds = EmvUtil.parseAFL(afl, sdaRecIds);
        }
        catch (Throwable ex) {
            this.parsingError();
        }
        Map<Binary, Binary> records = this.readRecords(recIds);
        for (Binary rec : records.values()) {
            if (!BerTLV.isTLV(rec)) {
                this.parsingError();
            }
            rec.assign(this.decryptRecord(rec));
            if (this.tlvDB.ParseAndStoreCardResponse(rec, false)) continue;
            this.parsingError();
        }
        this.signedRecords = Kernel8Crypt.getSdaRecords(records, sdaRecIds);
        this.log.writeln(-11364866, "Read AFL records");
    }

    public OUT startTransaction(TlvDatabase termParamsForSession) {
        OUT out = null;
        try {
            this.kernel8Start(termParamsForSession);
            Binary fci = this.selectApplication();
            this.initOnSelectApp(fci);
            this.getProcessingOptions();
            this.aip = this.tlvDB.GetValue(130);
            boolean isRRP = this.tlvDB.GetValue(10453513).getBit(0, 4);
            if (isRRP &= this.aip.getBit(1, 0)) {
                this.performRRP();
            } else {
                this.setTVRBit(1L);
            }
            this.processAFL();
            this.sessionStarted = true;
        }
        catch (OUT ex) {
            out = ex;
        }
        return out;
    }

    public Binary readData(int tag) {
        Binary data;
        Ex.MUST(this.sessionStarted, "Kernel8 terminal: Wrong usage");
        this.cr.Cmd(ApduEmv.ReadData(tag), 3);
        if (this.cr.rapdu.status != 36864) {
            this.tlvDB.store(10453532, Binary.Bin("00"));
        }
        if ((data = this.curCrypter.decryptReadData(this.cr.resp)) == null || !BerTLV.isTLV(data) || new BerTLV((Binary)data).tag != tag || !this.tlvDB.ParseAndStoreCardResponse(data, false)) {
            this.tlvDB.store(10453532, Binary.Bin("00"));
        }
        this.log.writeln(-11364866, "Read Data");
        return data;
    }

    private void errorMissingDataForCerts() {
        this.errorIndication.L2 = 6;
        this.S2627C();
    }

    private boolean processCertificates() {
        Binary caPKIndex;
        Binary caPKKey;
        if (!this.tlvDB.IsNotEmpty(143)) {
            this.errorMissingDataForCerts();
        }
        if ((caPKKey = this.caPublicKeys.get(caPKIndex = this.tlvDB.GetRef(143))) == null) {
            return false;
        }
        if (!this.tlvDB.IsNotEmpty(144)) {
            this.errorMissingDataForCerts();
        }
        Binary issuerCert = this.tlvDB.GetValue(144);
        if (!this.tlvDB.IsNotEmpty(40774)) {
            this.errorMissingDataForCerts();
        }
        Binary iccCert = this.tlvDB.GetValue(40774);
        Binary aid = this.tlvDB.GetValue(132);
        Binary pan = this.tlvDB.GetValue(90);
        return this.curCrypter.processCertificates(caPKIndex, caPKKey, issuerCert, iccCert, aid, pan);
    }

    private void terminalActionAnalysis() {
        boolean terminalOfflineOnly;
        long tvr = this.tlvDB.GetRef(149).asNum();
        long tacDenial = this.tlvDB.GetRef(10453515).asNum();
        long tacOnline = this.tlvDB.GetRef(10453516).asNum();
        if ((tvr & tacDenial) != 0L) {
            this.kernelDecision = 0;
            return;
        }
        boolean cardOnlineOnly = !this.tlvDB.GetRef(130).getBit(1, 3);
        int termType = this.tlvDB.GetRef(40757).asU16();
        boolean terminalOnlineOnly = termType == 17 || termType == 33 || termType == 20 || termType == 36 || termType == 52;
        boolean bl = terminalOfflineOnly = termType == 35 || termType == 38 || termType == 54 || termType == 19 || termType == 22;
        if (terminalOnlineOnly) {
            this.kernelDecision = 128;
            return;
        }
        if (terminalOfflineOnly) {
            this.kernelDecision = cardOnlineOnly ? 0 : 64;
            return;
        }
        if (cardOnlineOnly) {
            this.kernelDecision = 128;
            return;
        }
        this.kernelDecision = (tvr & tacOnline) != 0L ? 128 : 64;
    }

    private boolean isDoLocalAuth() {
        return this.tlvDB.GetRef(40747).getBit(1, 7) && this.tlvDB.GetRef(130).getBit(0, 0);
    }

    private void prepareForGenAC() {
        Binary cardAID;
        Binary termAID;
        int n;
        Binary cvmCapability;
        if (!this.tlvDB.IsNotEmpty(40706) || !this.tlvDB.IsNotEmpty(154)) {
            this.outcomeParameterSet.setStatus(64);
            this.errorIndication.L3 = 3;
            this.errorIndication.msgOnError = 255;
            throw this.createOUT(null);
        }
        Binary amountNumeric = this.tlvDB.GetValue(40706);
        Binary cvmRequiredLimit = this.tlvDB.GetValue(10453518);
        if (!EmvUtil.IsAmountNumeric(amountNumeric) || !EmvUtil.IsAmountNumeric(cvmRequiredLimit)) {
            this.outcomeParameterSet.setStatus(64);
            this.errorIndication.L2 = 15;
            throw this.createOUT(null);
        }
        if (amountNumeric.compareTo(cvmRequiredLimit) != -1) {
            this.outcomeParameterSet.setB5Bit(3);
            cvmCapability = this.tlvDB.GetValue(10453511);
            this.setTRMDBit(0x80000000000000L);
        } else {
            cvmCapability = this.tlvDB.GetValue(10453512);
        }
        this.tlvDB.GetRef(40755).set(1, cvmCapability.get(0));
        Binary trmd = this.tlvDB.GetRef(40733);
        trmd.set(0, cvmCapability.get(0));
        Binary floorLimit = this.tlvDB.GetValue(10453517);
        if (amountNumeric.compareTo(floorLimit) == 1) {
            this.setTVRBit(32768L);
        }
        if ((n = (termAID = this.tlvDB.GetValue(40710)).size()) > (cardAID = this.tlvDB.GetValue(132)).size() || !termAID.equals(cardAID.first(n))) {
            this.setTVRBit(64L);
        }
        if (!this.isDoLocalAuth()) {
            this.setTVRBit(0x8000000000L);
        }
        this.terminalActionAnalysis();
    }

    private void S2627C() {
        this.uird1.messageId = 28;
        this.uird1.status = 0;
        this.uird1.holdTime = this.tlvDB.GetValue(10453521);
        this.outcomeParameterSet.setStatus(64);
        this.outcomeParameterSet.setB5Bit(7);
        throw this.createOUT(this.uird1);
    }

    private void parseGenACResponse(RApdu rapdu) {
        if (rapdu.status != 36864) {
            this.errorIndication.L2 = 3;
            this.errorIndication.SW12 = this.cr.rapdu.status;
            this.S2627C();
        }
        boolean parseOk = this.tlvDB.ParseAndStoreCardResponse(rapdu.response, false);
        if (rapdu.response.size() < 2 || rapdu.response.get(0) != 119 || !parseOk) {
            this.errorIndication.L2 = 4;
            this.S2627C();
        }
        boolean ok = this.tlvDB.IsNotEmpty(40758);
        ok &= this.tlvDB.IsNotEmpty(40743);
        ok &= this.tlvDB.IsNotEmpty(40742);
        ok &= this.tlvDB.IsNotEmpty(10453250);
        ok &= this.tlvDB.IsNotEmpty(10453253);
        ok &= this.tlvDB.IsNotEmpty(40720);
        if (!(ok &= this.tlvDB.IsNotEmpty(90))) {
            this.errorIndication.L2 = 1;
            this.S2627C();
        }
    }

    private void processIADMAC(Binary genACResponse) {
        long tvr = this.tlvDB.GetRef(149).asNum();
        boolean isRRPPerformed = (tvr & 2L) != 0L;
        Binary terminalRREntropy = null;
        if (isRRPPerformed) {
            terminalRREntropy = this.tlvDB.GetValue(40759);
        }
        this.iadMac = this.curCrypter.calcIADMac(this.pdolValues, this.cdolRelData, terminalRREntropy, this.lastERRDResponse, genACResponse);
        this.tlvDB.store(10453257, this.iadMac);
        Binary iad = this.tlvDB.GetRef(40720);
        int copyIadMac = (this.aip.get(1) & 6) >> 1;
        if (copyIadMac == 1) {
            int offset = this.tlvDB.GetValue(10453534).asU16();
            if (offset + 8 > iad.size()) {
                this.errorIndication.L2 = 6;
                this.S2627C();
            }
            iad.set(offset, this.iadMac, 0, this.iadMac.size());
        }
        if (copyIadMac == 2) {
            Binary val = this.tlvDB.GetValue(10453255);
            if (!this.tlvDB.IsNotEmpty(10453255) || val.asU16() + 8 > iad.size()) {
                this.errorIndication.L2 = 6;
                this.S2627C();
            }
            iad.set(val.asU16(), this.iadMac, 0, this.iadMac.size());
        }
    }

    private void processEDAMAC() {
        Binary cardAC = this.tlvDB.GetValue(40742);
        Binary cardEdaMac = this.tlvDB.GetValue(10453253);
        Binary myEdaMac = this.curCrypter.calcEDAMac(this.iadMac, cardAC);
        if (!myEdaMac.equals(cardEdaMac)) {
            this.errorIndication.L2 = 19;
            this.S2627C();
        }
    }

    private void analyseCVD() {
        int cvd = this.tlvDB.GetValue(10453250).asU16();
        if (cvd == 255) {
            this.outcomeParameterSet.setCVM(240);
            this.setTVRBit(0x800000L);
            this.tlvDB.store(40756, Binary.Bin("3F0001"));
            return;
        }
        long trmd = this.tlvDB.GetValue(40733).asNum();
        if (cvd == 0 && (trmd & 0x800000000000000L) != 0L) {
            this.tlvDB.store(40756, Binary.Bin("1F0002"));
            this.outcomeParameterSet.setCVM(0);
            return;
        }
        if (cvd == 1 && (trmd & 0x2000000000000000L) != 0L) {
            this.tlvDB.store(40756, Binary.Bin("1E0000"));
            this.outcomeParameterSet.setCVM(16);
            return;
        }
        if (cvd == 3 && (trmd & 0x400000000000000L) != 0L) {
            this.tlvDB.store(40756, Binary.Bin("010002"));
            this.outcomeParameterSet.setCVM(48);
            return;
        }
        if (cvd == 15) {
            this.tlvDB.store(40756, Binary.Bin("3F0000"));
            this.outcomeParameterSet.setCVM(240);
            return;
        }
        if (cvd == 2 && (trmd & 0x4000000000000000L) != 0L) {
            this.tlvDB.store(40756, Binary.Bin("020000"));
            this.setTVRBit(262144L);
            this.outcomeParameterSet.setCVM(32);
            return;
        }
        this.tlvDB.store(40756, Binary.Bin("3F0001"));
        this.setTVRBit(0x800000L);
        this.outcomeParameterSet.setCVM(240);
    }

    private void secondChecks(int refControlParam) {
        int acType = this.tlvDB.GetRef(40743).asU16() & 0xC0;
        boolean cidValid = acType == 64 && refControlParam == 64;
        cidValid |= acType == 128 && (refControlParam == 64 || refControlParam == 128);
        if (!(cidValid |= acType == 0)) {
            this.errorIndication.L2 = 6;
            this.S2627C();
        }
        if (this.tlvDB.IsNotEmpty(10453252)) {
            Binary tvr = this.tlvDB.GetValue(149);
            Binary mask = this.tlvDB.GetValue(10453530);
            Binary cardTvr = this.tlvDB.GetValue(10453252);
            tvr.and(mask);
            mask.xor(Binary.Bin(5, 255));
            cardTvr.and(mask);
            tvr.or(cardTvr);
            this.tlvDB.store(149, tvr);
        }
        this.analyseCVD();
        this.terminalActionAnalysis();
    }

    private boolean writeData(Binary plainTlv, boolean moreCommands) {
        Binary encryptedTlv = this.curCrypter.cryptWriteData(plainTlv);
        this.cr.Cmd(ApduEmv.WriteData(encryptedTlv, moreCommands), 3);
        if (this.cr.rapdu.status != 36864) {
            return false;
        }
        Binary myMac = this.curCrypter.calcDataEnvelopeMac(plainTlv);
        return myMac.equals(this.cr.resp);
    }

    private void writeData() {
        Binary b = this.tlvDB.GetRef(12550404);
        BerTLVList tlvList = new BerTLVList(b);
        boolean res = true;
        int i = 0;
        while (i < tlvList.recs.size()) {
            boolean isMore = i != tlvList.recs.size() - 1;
            res &= this.writeData(tlvList.recs.get(i).toBin(), isMore);
            ++i;
        }
        if (res) {
            this.tlvDB.store(10453531, Binary.Bin("80"));
        }
        this.log.writeln(-11364866, "Write Data done (" + (res ? "OK" : "Not OK") + ")");
    }

    private boolean isCardMsgIdAllowed(int cardMsgId) {
        Binary allowedMsgIds = this.tlvDB.GetValue(10453533);
        int i = 0;
        while (i < allowedMsgIds.size()) {
            if (allowedMsgIds.get(i) == cardMsgId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void finishTransaction() {
        boolean isCashOrPurchase;
        boolean isReport = this.tlvDB.GetValue(10453513).getBit(0, 3);
        if (!isReport) {
            long tvr = this.tlvDB.GetRef(149).asNum();
            this.tlvDB.store(149, Binary.Num_Bin(tvr &= 0xFFFFFFFBFFFFFFFFL, 5));
        }
        this.outcomeParameterSet.setB5Bit(5);
        this.errorIndication.msgOnError = 255;
        Binary restartIndicator = this.tlvDB.GetValue(10453256);
        if (this.tlvDB.IsNotEmpty(10453256) && (restartIndicator.get(0) & 0xF0) == 32) {
            this.uird1.holdTime = this.tlvDB.GetValue(10453521);
            this.uird1.status = 0;
            this.uird2.holdTime = Binary.Bin("000000");
            this.uird2.status = 2;
            this.uird1.messageId = 33;
            this.uird2.messageId = 33;
            int cardMsgId = restartIndicator.get(1);
            if (cardMsgId != 0 && this.isCardMsgIdAllowed(cardMsgId)) {
                this.uird1.messageId = cardMsgId;
                this.uird2.messageId = cardMsgId;
            }
            this.outcomeParameterSet.setStatus(64);
            this.outcomeParameterSet.setStart(16);
            this.outcomeParameterSet.setB5Bit(6);
            this.outcomeParameterSet.setB5Bit(7);
            throw this.createOUT(true, this.uird1, this.uird2);
        }
        this.uird1.status = 0;
        this.outcomeParameterSet.setB5Bit(7);
        int acType = this.tlvDB.GetRef(40743).asU16() & 0xC0;
        if (acType == 64 && this.kernelDecision == 64) {
            this.outcomeParameterSet.setStatus(16);
            this.uird1.holdTime = this.tlvDB.GetValue(10453521);
            this.uird1.messageId = this.outcomeParameterSet.getCVM() == 16 ? 26 : 3;
            throw this.createOUT(true, this.uird1, null);
        }
        if (acType == 128 && this.kernelDecision != 0 || this.kernelDecision == 128 && acType != 0) {
            this.outcomeParameterSet.setStatus(48);
            this.uird1.holdTime = Binary.Bin("000000");
            this.uird1.messageId = 27;
            throw this.createOUT(true, this.uird1, null);
        }
        int trcType = this.tlvDB.GetValue(156).get(0);
        boolean bl = isCashOrPurchase = trcType == 1 || trcType == 23 || trcType == 0 || trcType == 25;
        if (!isCashOrPurchase) {
            this.outcomeParameterSet.setStatus(64);
            this.uird1.holdTime = Binary.Bin("000000");
            this.uird1.messageId = 30;
            throw this.createOUT(true, this.uird1, null);
        }
        if (!this.tlvDB.IsNotEmpty(10453256)) {
            this.outcomeParameterSet.setStatus(32);
            this.uird1.holdTime = this.tlvDB.GetValue(10453521);
            this.uird1.messageId = 7;
            throw this.createOUT(true, this.uird1, null);
        }
        if ((restartIndicator.get(0) & 0xF0) == 48) {
            this.outcomeParameterSet.setStatus(96);
            int altIntf = restartIndicator.get(0) & 0xF;
            if (altIntf == 1 || altIntf == 2 || altIntf == 15) {
                this.outcomeParameterSet.setAlternateInterface(altIntf << 4);
            }
            this.uird1.holdTime = this.tlvDB.GetValue(10453521);
            this.uird1.messageId = 24;
            int cardMsgId = restartIndicator.get(1);
            if (cardMsgId != 0 && this.isCardMsgIdAllowed(cardMsgId)) {
                this.uird1.messageId = cardMsgId;
            }
            throw this.createOUT(true, this.uird1, null);
        }
        this.outcomeParameterSet.setStatus(32);
        this.uird1.holdTime = this.tlvDB.GetValue(10453521);
        this.uird1.messageId = 7;
        int cardMsgId = restartIndicator.get(1);
        if (cardMsgId != 0 && this.isCardMsgIdAllowed(cardMsgId)) {
            this.uird1.messageId = cardMsgId;
        }
        throw this.createOUT(true, this.uird1, null);
    }

    public OUT generateAC() {
        Ex.MUST(this.sessionStarted, "Kernel8 terminal: Wrong usage");
        OUT out = null;
        try {
            this.prepareForGenAC();
            int refControlParam = this.kernelDecision;
            this.cdolRelData = this.tlvDB.formDOLValues(this.tlvDB.GetValue(140));
            boolean isWriteData = this.tlvDB.IsNotEmpty(12550404);
            this.cr.Cmd(ApduEmv.GenerateAC(refControlParam, this.cdolRelData, isWriteData), 3);
            this.log.writeln(-11364866, "Generate AC");
            this.parseGenACResponse(this.cr.rapdu);
            this.curCrypter.calcSdaHash(Kernel8Crypt.formSDAData(this.signedRecords, Kernel8Crypt.createExtSDARelData(this.tlvDB), this.aip));
            if (this.isDoLocalAuth()) {
                boolean ok = this.processCertificates();
                if (!ok) {
                    this.setTVRBit(0x400000000L);
                }
                this.log.writeln(-11364866, "Local authentication done (" + (ok ? "OK" : "Failed") + ")");
            }
            this.processIADMAC(this.cr.resp);
            this.log.writeln(-11364866, "IAD-MAC calculated");
            this.processEDAMAC();
            this.log.writeln(-11364866, "EDA-MAC verified");
            this.secondChecks(refControlParam);
            if (isWriteData) {
                this.writeData();
            }
            this.finishTransaction();
        }
        catch (OUT ex) {
            out = ex;
        }
        this.sessionStarted = false;
        return out;
    }
}

