/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.BerTLV;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.etsi.CTLVList;

public class ApduEtsi {
    public static final int STATUS_P1_NoIndication = 0;
    public static final int STATUS_P1_AppInitialized = 1;
    public static final int STATUS_P1_AppTermination = 2;
    public static final int STATUS_P2_SelectAnswer = 0;
    public static final int STATUS_P2_DFName = 1;
    public static final int STATUS_P2_NoAnswer = 12;

    public static CApdu Status(int p1, int p2) {
        CApdu ap = new CApdu(128, 242, p1, p2, Binary.Bin(), 256, "{ETSI} STATUS");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu TerminalProfile(Binary dataField) {
        return new CApdu(128, 16, 0, 0, dataField, 0, "{ETSI} TERMINAL PROFILE");
    }

    public static CApdu Envelope(int eventTag, Binary eventData) {
        return new CApdu(128, 194, 0, 0, BerTLV.Tlv(eventTag, eventData), 256, "{ETSI} ENVELOPE");
    }

    public static CApdu Envelope(int eventTag, CTLVList ctlvs) {
        return ApduEtsi.Envelope(eventTag, ctlvs.toBin());
    }

    public static CApdu Fetch(int lengthOfExpectedData) {
        Ex.MUST(lengthOfExpectedData <= 256, "Fetch: 'lengthOfExpectedData' too large");
        return new CApdu(128, 18, 0, 0, Binary.Bin(), lengthOfExpectedData, "{ETSI} FETCH");
    }

    public static CApdu TerminalResponse(Binary dataField) {
        return new CApdu(128, 20, 0, 0, dataField, 0, "{ETSI} TERMINAL RESPONSE");
    }

    public static CApdu TerminalResponse(CTLVList ctlvs) {
        return ApduEtsi.TerminalResponse(ctlvs.toBin());
    }
}

