/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import java.util.HashSet;
import org.denom.Binary;
import org.denom.Ex;

public class EventList {
    public HashSet<Integer> list = new HashSet();
    public static final int MT_CALL = 0;
    public static final int CALL_CONNECTED = 1;
    public static final int CALL_DISCONNECTED = 2;
    public static final int LOCATION_STATUS = 3;
    public static final int USER_ACTIVITY = 4;
    public static final int IDLE_SCREE_AVAILABLE = 5;
    public static final int CARD_READER_STATUS = 6;
    public static final int LANGUAGE_SELECTION = 7;
    public static final int BROWSER_TERMINATION = 8;
    public static final int DATA_AVAILABLE = 9;
    public static final int CHANNEL_STATUS = 10;
    public static final int ACCESS_TECHNOLOGY_CHANGE_SINGLE = 11;
    public static final int DISPLAY_PARAMETERS_CHANGED = 12;
    public static final int LOCAL_CONNECTION = 13;
    public static final int NETWORK_SEARCH_MODE_CHANGE = 14;
    public static final int BROWSING_STATUS = 15;
    public static final int FRAMES_INFORMATION_CHANGE = 16;
    public static final int I_WLAN_ACCESS_STATUS = 17;
    public static final int NETWORK_REJECTION = 18;
    public static final int HCI_CONNECTIVITY_EVENT = 19;
    public static final int ACCESS_TECHNOLOGY_CHANGE_MULTI = 20;
    public static final int CSG_CELL_SELECTION = 21;
    public static final int CONTACTLESS_STATE_REQUEST = 22;
    public static final int IMS_REGISTRATION = 23;
    public static final int IMS_INCOMING_DATA = 24;
    public static final int PROFILE_CONTAINER = 25;
    public static final int SECURED_PROFILE_CONTAINER = 27;
    public static final int POLL_INTERVAL_NEGOTIATION = 28;
    public static final int DATA_CONNECTION_STATUS_CHANGE = 29;
    public static final int CAG_CELL_SELECTION = 30;

    public EventList() {
    }

    public EventList(Binary bin) {
        this.assign(bin);
    }

    public void assign(Binary bin) {
        this.list.clear();
        int i = 0;
        while (i < bin.size()) {
            int event = bin.get(i);
            Ex.MUST(this.list.add(event), "Event list already contains event " + event);
            ++i;
        }
    }

    public static String getDescription(int event) {
        switch (event) {
            case 0: {
                return "MT call";
            }
            case 1: {
                return "Call connected";
            }
            case 2: {
                return "Call disconnected";
            }
            case 3: {
                return "Location status";
            }
            case 4: {
                return "User activity";
            }
            case 5: {
                return "Idle screen available";
            }
            case 6: {
                return "Card reader status";
            }
            case 7: {
                return "Language selection";
            }
            case 8: {
                return "Browser termination";
            }
            case 9: {
                return "Data available";
            }
            case 10: {
                return "Channel status";
            }
            case 11: {
                return "Access Technology Change (single access technology)";
            }
            case 12: {
                return "Display parameters changed";
            }
            case 13: {
                return "Local connection";
            }
            case 14: {
                return "Network Search Mode Chang";
            }
            case 15: {
                return "Browsing status";
            }
            case 16: {
                return "Frames Information Change";
            }
            case 17: {
                return "I-WLAN Access Status";
            }
            case 18: {
                return "Network Rejection";
            }
            case 19: {
                return "HCI connectivity event";
            }
            case 20: {
                return "Access Technology Change (multiple access technologies)";
            }
            case 21: {
                return "CSG cell selection";
            }
            case 22: {
                return "Contactless state request";
            }
            case 23: {
                return "IMS Registration";
            }
            case 24: {
                return "IMS Incoming data";
            }
            case 25: {
                return "Profile Container";
            }
            case 27: {
                return "Secured Profile Container";
            }
            case 28: {
                return "Poll Interval Negotiation";
            }
            case 29: {
                return "Data Connection Status Change";
            }
            case 30: {
                return "CAG cell selection";
            }
        }
        return "";
    }
}

