/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.BerTLV;
import org.denom.smartcard.etsi.CTLV;
import org.denom.smartcard.etsi.CTLVList;

public class ProactiveCommand {
    public CTLVList ctlvs;
    public CTLV cmdDetails;
    public int commandNumber;
    public int typeOfCommand;
    public int commandQualifier;

    public ProactiveCommand(Binary fetchedData) {
        BerTLV tlv = new BerTLV(fetchedData);
        Ex.MUST(tlv.tag == 208, "Wrong proactive command tag");
        this.ctlvs = CTLVList.parse(tlv.value);
        this.cmdDetails = this.ctlvs.find(1);
        Ex.MUST(this.cmdDetails.val.size() == 3, "Wrong CTLV in proactive command: Command Details");
        this.commandNumber = this.cmdDetails.val.get(0);
        this.typeOfCommand = this.cmdDetails.val.get(1);
        this.commandQualifier = this.cmdDetails.val.get(2);
    }

    public CTLV find(int ctag) {
        return this.ctlvs.find(ctag);
    }
}

