/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import org.denom.Binary;
import org.denom.Strings;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.TripleDES;
import org.denom.format.LV;

public class SCP80Sms {
    public int firstByte = 96;
    public String originAddress;
    public int TP_PID = 127;
    public int TP_DCS = 246;
    public String timeStamp;
    public Binary SPI;
    public Binary KIC;
    public Binary KID;
    public Binary TAR;
    public Binary Counter;
    public Binary PCNTR = Binary.Bin("00");
    public Binary keyOTAMac;

    public static Binary encodePhoneNumber(int TON_NPI, String phoneNum) {
        int len = phoneNum.length();
        len = (len & 1) == 1 ? len + 1 : len;
        String destStr = Strings.PadRight(phoneNum, len, 'F');
        Binary bin = Binary.Bin(Binary.Bin(1, TON_NPI), Binary.Bin(destStr).nibbleSwap());
        return bin;
    }

    public static Binary calcCCS(Binary data, Binary des3Key) {
        Binary pad = Binary.Bin((8 - data.size() % 8) % 8);
        Binary aligned = Binary.Bin(data, pad);
        TripleDES cipher = new TripleDES(des3Key);
        Binary mac = cipher.calcMACAlg3(aligned, AlignMode.NONE, null);
        return mac;
    }

    public Binary toBin(Binary userData) {
        Binary sms = Binary.Bin().reserve(userData.size() + 40);
        Binary binOriginAddr = Binary.Bin(Binary.Bin(1, this.originAddress.length()), SCP80Sms.encodePhoneNumber(145, this.originAddress));
        sms.add(this.firstByte);
        sms.add(binOriginAddr);
        sms.add(this.TP_PID);
        sms.add(this.TP_DCS);
        sms.add(Binary.Bin(this.timeStamp).nibbleSwap());
        Binary cmdHeader = Binary.Bin(this.SPI, this.KIC, this.KID, this.TAR, this.Counter, this.PCNTR);
        int dsLen = 8;
        Binary lvCmdHeader = Binary.Bin().add(cmdHeader.size() + dsLen).add(cmdHeader);
        Binary toSignPart1 = Binary.Bin().addU16(lvCmdHeader.size() + dsLen + userData.size()).add(lvCmdHeader);
        Binary ccs = SCP80Sms.calcCCS(Binary.Bin(toSignPart1, userData), this.keyOTAMac);
        Binary fullUserData = Binary.Bin(LV.LV1(Binary.Bin("70 00"))).add(toSignPart1).add(ccs).add(userData);
        sms.add(fullUserData.size());
        sms.add(fullUserData);
        return sms;
    }
}

