/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.BerTLV;
import org.denom.format.JSONObject;
import org.denom.format.LV;
import org.denom.smartcard.etsi.CTLV;
import org.denom.smartcard.etsi.CTLVList;

public class SCP81SessionParams {
    public String host;
    public int port;
    public String networkAccessName = "internet";
    public int bufferSize = 512;
    public String PSKIdentity;
    public int keyVersion;
    public int keyIdentifier;
    public int retryCounter;
    public String retryWaitingDelay;
    public String administrationHost;
    public String administrationURI;
    public String agentID;

    public Binary toBin() {
        Binary hostBin = Binary.Bin();
        try {
            hostBin.assign(InetAddress.getByName(this.host).getAddress());
        }
        catch (UnknownHostException e) {
            Ex.THROW("Wrong hostname: " + this.host);
        }
        CTLVList ctlvs = new CTLVList();
        ctlvs.add(53, "03");
        ctlvs.add(57, Binary.Num_Bin(this.bufferSize, 2));
        ctlvs.add(71, LV.LV1(Binary.Bin().fromUTF8(this.networkAccessName)));
        ctlvs.add(60, Binary.Bin().add("02").add(Binary.Num_Bin(this.port, 2)));
        ctlvs.add(62, Binary.Bin().add("21").add(hostBin));
        Binary connectionParams = BerTLV.Tlv(132, ctlvs.toBin());
        Binary securityParams = BerTLV.Tlv(133, Binary.Bin(LV.LV1(Binary.Bin().fromUTF8(this.PSKIdentity)), Binary.Bin("02").add(this.keyVersion).add(this.keyIdentifier)));
        Binary retryPolicyParams = BerTLV.Tlv(134, Binary.Bin().addU16(this.retryCounter).add(new CTLV(37, Binary.Bin(this.retryWaitingDelay).nibbleSwap()).toBin()));
        Binary httpParams = BerTLV.Tlv(137, Binary.Bin(BerTLV.Tlv(138, Binary.Bin().fromUTF8(this.administrationHost)), BerTLV.Tlv(139, Binary.Bin().fromUTF8(this.agentID)), BerTLV.Tlv(140, Binary.Bin().fromUTF8(this.administrationURI))));
        return BerTLV.Tlv(129, BerTLV.Tlv(131, Binary.Bin(connectionParams, securityParams, retryPolicyParams, httpParams)));
    }

    public void fromJSON(JSONObject jo) {
        JSONObject joHTTPParams;
        JSONObject joRetryPolicyParams;
        JSONObject joSecurityParams;
        JSONObject joConnectionParams = jo.optJSONObject("Connection Parameters");
        if (joConnectionParams != null) {
            this.host = joConnectionParams.getString("Host");
            this.port = joConnectionParams.getInt("Port");
            this.bufferSize = joConnectionParams.getInt("Buffer Size");
        }
        if ((joSecurityParams = jo.optJSONObject("Security Parameters")) != null) {
            this.PSKIdentity = joSecurityParams.getString("PSK Identity");
            Binary b = joSecurityParams.getBinary("Key Version", 1);
            this.keyVersion = b.get(0);
            b = joSecurityParams.getBinary("Key Identifier", 1);
            this.keyIdentifier = b.get(0);
        }
        if ((joRetryPolicyParams = jo.optJSONObject("Retry Policy")) != null) {
            this.retryCounter = joRetryPolicyParams.getInt("Retry Counter");
            Binary b = joRetryPolicyParams.getBinary("Retry Waiting Delay", 3);
            this.retryWaitingDelay = b.Hex();
        }
        if ((joHTTPParams = jo.optJSONObject("HTTP POST Parameters")) != null) {
            this.administrationHost = joHTTPParams.optString("Administration Host", null);
            this.agentID = joHTTPParams.optString("Agent ID", null);
            this.administrationURI = joHTTPParams.optString("Administration URI", null);
        }
    }
}

